/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.google.common.collect.Multimap;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.items.HornShootable;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWandOfDropsies
extends Item
implements HornShootable {
    protected float attackDamage;
    protected final Item.ToolMaterial material = Item.ToolMaterial.IRON;
    private final String name = "wand_of_dropsies";

    public ItemWandOfDropsies() {
        this.field_77777_bU = 1;
        this.func_77656_e(50);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.attackDamage = 0.4f + this.material.func_78000_c();
        this.func_77655_b("wand_of_dropsies");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (player.func_184585_cz()) {
            stack.func_77972_a(4, (EntityLivingBase)player);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
    }

    @Override
    public void shoot(ItemStack stack, World worldIn, EntityLivingBase shooter, BlockPos targetPos) {
        if (!worldIn.field_72995_K && !CommonProxy.config.disableDropsyWand) {
            ItemHelper.horseDamageItem(stack, 1, shooter);
            Vec3d lookVec = shooter.func_70040_Z();
            for (Object obj : worldIn.func_72839_b((Entity)shooter, shooter.func_174813_aQ().func_72317_d(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c).func_72321_a(lookVec.field_72450_a * 25.0, lookVec.field_72448_b * 25.0, lookVec.field_72449_c * 25.0))) {
                EntityLiving el;
                ItemStack itemStackIn;
                Vec3d objVec;
                if (obj instanceof Entity && lookVec.func_72431_c(objVec = ((Entity)obj).func_174791_d().func_178788_d(shooter.func_174791_d()).func_72432_b()).func_72433_c() > 0.45) continue;
                if (obj instanceof EntityPlayer && obj != shooter.func_184179_bs()) {
                    EntityPlayer ep = (EntityPlayer)obj;
                    ep.func_71040_bB(true);
                    continue;
                }
                if (!(obj instanceof EntityLiving) || obj == shooter.func_184179_bs() || (itemStackIn = (el = (EntityLiving)obj).func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() || itemStackIn.func_190916_E() == 0 || itemStackIn.func_77973_b() == null) continue;
                EntityItem entityItem = new EntityItem(worldIn, el.field_70165_t, el.field_70163_u + (double)el.field_70131_O / 1.8, el.field_70161_v, itemStackIn);
                entityItem.func_174867_a(4);
                el.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                Vec3d targetLookVec = el.func_70040_Z();
                entityItem.field_70159_w = targetLookVec.field_72450_a / 1.3;
                double yTrajectory = targetLookVec.field_72448_b < 0.35 ? targetLookVec.field_72448_b + 0.2 : targetLookVec.field_72448_b;
                entityItem.field_70181_x = yTrajectory = yTrajectory < 0.1 ? 0.1 : yTrajectory;
                entityItem.field_70179_y = targetLookVec.field_72449_c / 1.3;
                worldIn.func_72838_d((Entity)entityItem);
                if (!(el instanceof EntitySkeleton)) continue;
                ((EntitySkeleton)el).func_85036_m();
            }
        }
    }

    @Override
    public void shootTargetEntity(ItemStack stack, World worldIn, EntityLivingBase shooter, EntityLivingBase targetEntity) {
        if (null != targetEntity) {
            this.shoot(stack, worldIn, shooter, targetEntity.func_180425_c());
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase playerIn, int timeLeft) {
        if (!worldIn.field_72995_K) {
            stack.func_77972_a((128 - timeLeft) / 8, playerIn);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.func_184586_b(p_onItemRightClick_3_);
        p_onItemRightClick_2_.func_184598_c(p_onItemRightClick_3_);
        this.shoot(lvt_4_1_, p_onItemRightClick_1_, (EntityLivingBase)p_onItemRightClick_2_, new BlockPos(0, 0, 0));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)lvt_4_1_);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public String getName() {
        return "wand_of_dropsies";
    }
}

