/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.compression;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.compression.ICompression;
import aroma1997.org.kamranzafar.jtar.TarEntry;
import aroma1997.org.kamranzafar.jtar.TarInputStream;
import aroma1997.org.kamranzafar.jtar.TarOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class TarCompression
implements ICompression {
    public void addFileToTar(String path, File folder, TarOutputStream zip) throws IOException {
        if (folder.isDirectory()) {
            this.addFolderToTar(path, folder, zip);
        } else {
            int len;
            byte[] buf = new byte[4096];
            FileInputStream in = new FileInputStream(folder);
            zip.putNextEntry(new TarEntry(folder, CompressionHelper.appendFilename(path, folder.getName())));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    public void addFolderToTar(String path, File folder, TarOutputStream zip) throws IOException {
        for (File file : folder.listFiles()) {
            this.addFileToTar(CompressionHelper.appendFilename(path, folder.getName()), file, zip);
        }
    }

    @Override
    public void compress(OutputStream fos, Collection<Map.Entry<File, String>> files, int compression) throws IOException {
        TarOutputStream zip = new TarOutputStream(fos);
        for (Map.Entry<File, String> e : files) {
            if (e.getKey().isFile()) {
                this.addFileToTar(e.getValue(), e.getKey(), zip);
                continue;
            }
            this.addFolderToTar(e.getValue(), e.getKey(), zip);
        }
        zip.flush();
        zip.close();
    }

    @Override
    public void decompress(InputStream is, Function<String, File> location) throws IOException {
        TarEntry e;
        TarInputStream zip = new TarInputStream(is);
        while ((e = zip.getNextEntry()) != null) {
            int len;
            File target = location.apply(e.getName());
            if (target == null) continue;
            if (e.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(target);
            byte[] buffer = new byte[4096];
            while ((len = zip.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
        }
        zip.close();
    }
}

