/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord;

import chikachi.discord.DiscordIntegration;
import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.Message;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.imc.IMCConfig;
import chikachi.discord.core.config.types.MessageConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    private static List<String> registeredIMCMods = new ArrayList<String>();

    private static void sendStatusIMC(String modId, boolean success, String method, String message) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("method", method);
        data.func_74778_a("message", message);
        FMLInterModComms.sendRuntimeMessage((Object)DiscordIntegration.instance, (String)modId, (String)(success ? "success" : "error"), (NBTTagCompound)data);
    }

    static void onMessageReceived(FMLInterModComms.IMCMessage imcMessage) {
        String modId = imcMessage.getSender();
        if (imcMessage.isStringMessage()) {
            IMCHandler.onMessageReceived(modId, imcMessage.key, imcMessage.getStringValue());
        } else if (imcMessage.isNBTMessage()) {
            IMCHandler.onMessageReceived(modId, imcMessage.key, imcMessage.getNBTValue());
        }
    }

    private static void onMessageReceived(String modId, String key, String message) {
        IMCConfig imcConfig = Configuration.getConfig().imc;
        if (key.equalsIgnoreCase("registerListener")) {
            if (!registeredIMCMods.contains(modId)) {
                if (imcConfig.isAllowed(modId)) {
                    DiscordIntegrationLogger.Log(String.format("Added %s as listener", modId));
                    IMCHandler.sendStatusIMC(modId, true, key, "Registered");
                    registeredIMCMods.add(modId);
                } else {
                    IMCHandler.notAllowed(modId, key, "register as IMC listener");
                }
            } else if (imcConfig.isAllowed(modId)) {
                IMCHandler.sendStatusIMC(modId, false, key, "Already registered");
            }
        } else if (key.equalsIgnoreCase("unregisterListener")) {
            if (registeredIMCMods.contains(modId)) {
                DiscordIntegrationLogger.Log(String.format("Removed %s as listener", modId));
                IMCHandler.sendStatusIMC(modId, true, key, "Unregistered");
                registeredIMCMods.remove(modId);
            } else if (imcConfig.isAllowed(modId)) {
                IMCHandler.sendStatusIMC(modId, false, key, "Already unregistered");
            }
        }
    }

    private static void onMessageReceived(String modId, String key, NBTTagCompound message) {
        IMCConfig imcConfig = Configuration.getConfig().imc;
        if (key.equalsIgnoreCase("sendMessage")) {
            if (!imcConfig.isAllowed(modId)) {
                IMCHandler.notAllowed(modId, key, "send a message");
                return;
            }
            if (!message.func_74764_b("message") || message.func_74779_i("message").trim().length() == 0) {
                IMCHandler.sendStatusIMC(modId, false, key, "Missing message");
                return;
            }
            if (!message.func_74764_b("channel") || message.func_74763_f("channel") == 0L) {
                IMCHandler.sendStatusIMC(modId, false, key, "Missing channel");
                return;
            }
            DiscordClient.getInstance().broadcast(new Message(modId, new MessageConfig(message.func_74779_i("message"))), message.func_74763_f("channel"));
            IMCHandler.sendStatusIMC(modId, true, key, "Sent");
        }
    }

    private static void notAllowed(String modId, String key, String action) {
        IMCConfig imcConfig = Configuration.getConfig().imc;
        DiscordIntegrationLogger.Log(String.format("%s tried to %s but %s", modId, action, imcConfig.isWhitelist() ? "wasn't on the whitelist" : "was on the blacklist"));
        IMCHandler.sendStatusIMC(modId, false, key, "Not Allowed");
    }

    public static boolean haveListeners() {
        return registeredIMCMods.size() > 0;
    }

    public static List<String> getRegisteredIMCMods() {
        return registeredIMCMods;
    }

    public static void emitMessage(String key, String message) {
        registeredIMCMods.forEach(registeredIMCMod -> FMLInterModComms.sendRuntimeMessage((Object)DiscordIntegration.instance, (String)registeredIMCMod, (String)key, (String)message));
    }

    public static void emitMessage(String key, NBTTagCompound message) {
        registeredIMCMods.forEach(registeredIMCMod -> FMLInterModComms.sendRuntimeMessage((Object)DiscordIntegration.instance, (String)registeredIMCMod, (String)key, (NBTTagCompound)message));
    }
}

