/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.command;

import chikachi.discord.command.SubCommandConfig;
import chikachi.discord.command.SubCommandOnline;
import chikachi.discord.command.SubCommandTps;
import chikachi.discord.command.SubCommandUnstuck;
import chikachi.discord.command.SubCommandUptime;
import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.MinecraftFormattingCodes;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.linking.LinkingRequest;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CommandDiscord
extends CommandBase {
    public String func_71517_b() {
        return "discord";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/discord <config|online" + (Configuration.getConfig().discord.allowLinking ? "|link|unlink" : "") + "|tps|unstuck|uptime> [options]";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String commandName;
        if (args.length == 0) {
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        switch (commandName = argsList.remove(0).toLowerCase()) {
            case "config": {
                SubCommandConfig.execute(sender, argsList);
                break;
            }
            case "online": {
                SubCommandOnline.execute(sender);
                break;
            }
            case "link": {
                if (!Configuration.getConfig().discord.allowLinking) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Linking is not enabled"));
                    break;
                }
                if (!(sender instanceof EntityPlayer)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "You need to be a player"));
                    break;
                }
                UUID minecraftUUID = ((EntityPlayer)sender).func_146103_bH().getId();
                Long discordId = Configuration.getLinking().getDiscordId(minecraftUUID);
                if (discordId != null) {
                    User discordUser = DiscordClient.getInstance().getJda().getUserById(discordId);
                    sender.func_145747_a((ITextComponent)new TextComponentString(String.format((Object)((Object)MinecraftFormattingCodes.YELLOW) + "You're already linked to %s#%s", discordUser.getName(), discordUser.getDiscriminator())));
                    break;
                }
                if (argsList.size() == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Missing code"));
                    break;
                }
                Optional<LinkingRequest> requestOptional = Configuration.getLinking().getRequestByCode(argsList.remove(0));
                if (requestOptional.isPresent()) {
                    LinkingRequest request = requestOptional.get();
                    if (request.hasExpired()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Linking request has expired"));
                        break;
                    }
                    request.executeLinking(minecraftUUID);
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.GREEN) + "Linked"));
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Linking request not found"));
                break;
            }
            case "unlink": {
                if (!Configuration.getConfig().discord.allowLinking) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Linking is not enabled"));
                    break;
                }
                if (!(sender instanceof EntityPlayer)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "You need to be a player"));
                    break;
                }
                UUID minecraftUUID = ((EntityPlayer)sender).func_146103_bH().getId();
                if (Configuration.getLinking().getDiscordId(minecraftUUID) == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "You aren't linked"));
                    break;
                }
                Configuration.getLinking().removeLink(minecraftUUID);
                sender.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)MinecraftFormattingCodes.DARK_RED) + "Unlinked"));
                break;
            }
            case "tps": {
                SubCommandTps.execute(sender, argsList);
                break;
            }
            case "unstuck": {
                SubCommandUnstuck.execute(sender, argsList);
                break;
            }
            case "uptime": {
                SubCommandUptime.execute(sender);
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentString("Unknown command"));
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        int position = args.length;
        if (position == 1) {
            if (!Configuration.getConfig().discord.allowLinking) {
                return CommandDiscord.func_71530_a((String[])args, (String[])new String[]{"config", "link", "online", "tps", "unstuck", "uptime", "unlink"});
            }
            return CommandDiscord.func_71530_a((String[])args, (String[])new String[]{"config", "link", "online", "tps", "unstuck", "uptime", "unlink"});
        }
        if (position == 2) {
            if (args[0].equalsIgnoreCase("config")) {
                return CommandDiscord.func_71530_a((String[])args, (String[])new String[]{"load", "reload", "save"});
            }
            if (args[0].equalsIgnoreCase("tps")) {
                return CommandDiscord.func_71530_a((String[])args, (String[])new String[]{"--color"});
            }
            if (args[0].equalsIgnoreCase("unstuck")) {
                return CommandDiscord.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
            }
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return args.length > 1 && args[0].equalsIgnoreCase("unstuck") && index == 1;
    }

    public int compareTo(@NotNull ICommand o) {
        return super.compareTo(o);
    }
}

