/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Batcher<T> {
    private final Consumer<List<T>> consumer;
    private final long delayMs;
    private final int largeQueueSize;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> nextFlush;
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    public Batcher(Consumer<List<T>> consumer, long delayMs, int largeQueueSize, String threadName) {
        this(consumer, delayMs, largeQueueSize, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(threadName).setDaemon(true).build()));
    }

    public Batcher(Consumer<List<T>> consumer, long delayMs, int largeQueueSize, ScheduledExecutorService executor) {
        this.consumer = consumer;
        this.delayMs = delayMs;
        this.largeQueueSize = largeQueueSize;
        this.executor = executor;
    }

    public void queue(T item) {
        if (this.nextFlush != null) {
            this.nextFlush.cancel(false);
        }
        this.queue.add(item);
        long delay = this.queue.size() >= this.largeQueueSize ? 1L : this.delayMs;
        this.nextFlush = this.executor.schedule(this::flushQueue, delay, TimeUnit.MILLISECONDS);
    }

    private void flushQueue() {
        ArrayList messages = new ArrayList(this.queue.size());
        this.queue.drainTo(messages);
        if (!messages.isEmpty()) {
            this.consumer.accept(messages);
        }
    }
}

