/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core;

import chikachi.discord.core.config.Configuration;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class WebhookMessage {
    private String content;
    private String username;
    private String avatarUrl;

    WebhookMessage(String content, String username, String avatarUrl) {
        this.content = content;
        this.username = username;
        this.avatarUrl = avatarUrl;
    }

    boolean queue(JDA jda, Long channelId) {
        if (this.content == null || this.content.trim().length() == 0) {
            return false;
        }
        String webhook = Configuration.getConfig().discord.channels.channels.get((Object)channelId).webhook.trim();
        Matcher matcher = Pattern.compile("https://(ptb\\.)?discordapp\\.com/api/webhooks/([0-9]+)/([a-zA-Z0-9\\-_]+)").matcher(webhook);
        if (matcher.matches()) {
            String text;
            String webhookId = matcher.group(2);
            String webhookToken = matcher.group(3);
            Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK.compile(webhookId, webhookToken);
            JSONObject json = new JSONObject();
            if (this.username != null) {
                json.put("username", this.username);
            }
            if (this.avatarUrl != null) {
                json.put("avatar_url", this.avatarUrl);
            }
            if ((text = this.content).length() > 2000) {
                text = text.substring(0, 1997) + "...";
            }
            json.put("content", text);
            new RestAction<Void>(jda, route, json){

                @Override
                protected void handleResponse(Response response, Request<Void> request) {
                    try {
                        if (response.isOk()) {
                            request.onSuccess(null);
                        } else {
                            request.onFailure(response);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.queue();
            return true;
        }
        return false;
    }
}

