/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config;

import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.config.ConfigWrapper;
import chikachi.discord.core.config.linking.LinkingWrapper;
import chikachi.discord.core.config.types.ChannelConfigType;
import chikachi.discord.core.config.types.ChannelConfigTypeAdapter;
import chikachi.discord.core.config.types.DimensionConfigType;
import chikachi.discord.core.config.types.DimensionConfigTypeAdapter;
import chikachi.discord.core.config.types.MessageConfig;
import chikachi.discord.core.config.types.MessageConfigAdapter;
import chikachi.discord.core.config.types.PatternAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;

public class Configuration {
    private static File directory;
    private static File configFile;
    private static File linkingFile;
    private static ConfigWrapper config;
    private static LinkingWrapper linking;

    public static void onPreInit(String directoryPath) {
        directory = new File(directoryPath);
        directory.mkdirs();
        configFile = new File(directory, "discordintegration.json");
        linkingFile = new File(directory, "discordintegration_links.json");
        Configuration.loadConfig();
        Configuration.loadLinking();
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(ChannelConfigType.class, (Object)new ChannelConfigTypeAdapter()).registerTypeAdapter(DimensionConfigType.class, (Object)new DimensionConfigTypeAdapter()).registerTypeAdapter(MessageConfig.class, (Object)new MessageConfigAdapter()).registerTypeAdapter(Pattern.class, (Object)new PatternAdapter()).setVersion(3.0).setPrettyPrinting().create();
    }

    public static void loadConfig() {
        if (configFile == null) {
            return;
        }
        Gson gson = Configuration.createGson();
        if (!configFile.exists()) {
            config = new ConfigWrapper();
            config.fillFields();
            Configuration.saveConfig();
        } else {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(configFile);
                config = (ConfigWrapper)gson.fromJson((Reader)fileReader, ConfigWrapper.class);
                if (config == null) {
                    config = new ConfigWrapper();
                }
                config.fillFields();
            }
            catch (Exception e) {
                if (e instanceof JsonSyntaxException) {
                    DiscordIntegrationLogger.Log("Config had invalid syntax - Please check it using a JSON tool ( https://jsonlint.com/ ) or make sure it have the right content", true);
                }
                e.printStackTrace();
                if (config == null) {
                    config = new ConfigWrapper();
                    config.fillFields();
                }
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void saveConfig() {
        Configuration.saveToFile(configFile, config);
    }

    public static void loadLinking() {
        if (linkingFile == null) {
            return;
        }
        Gson gson = Configuration.createGson();
        if (!linkingFile.exists()) {
            linking = new LinkingWrapper();
            Configuration.saveLinking();
        } else {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(linkingFile);
                linking = (LinkingWrapper)gson.fromJson((Reader)fileReader, LinkingWrapper.class);
                if (linking == null) {
                    linking = new LinkingWrapper();
                }
            }
            catch (Exception e) {
                if (e instanceof JsonSyntaxException) {
                    DiscordIntegrationLogger.Log("Linking file is corrupt", true);
                }
                e.printStackTrace();
                if (linking == null) {
                    linking = new LinkingWrapper();
                }
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void saveLinking() {
        Configuration.saveToFile(linkingFile, linking);
    }

    private static void saveToFile(File file, Object data) {
        Gson gson = Configuration.createGson();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(gson.toJson(data));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveClean() {
        Gson gson = Configuration.createGson();
        try {
            FileWriter writer = new FileWriter(new File(directory, "discordintegration_clean.json"));
            ConfigWrapper cleanConfig = new ConfigWrapper();
            cleanConfig.fillFields();
            writer.write(gson.toJson((Object)cleanConfig));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ConfigWrapper getConfig() {
        return config;
    }

    public static LinkingWrapper getLinking() {
        return linking;
    }
}

