/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.types;

import chikachi.discord.core.config.types.ChannelConfigType;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class ChannelConfigTypeAdapter
implements JsonSerializer<ChannelConfigType>,
JsonDeserializer<ChannelConfigType> {
    public JsonElement serialize(ChannelConfigType src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isDisabled()) {
            return new JsonPrimitive(Boolean.valueOf(false));
        }
        if (src.isDefault()) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        ArrayList<Long> channels = src.getChannels();
        if (channels == null) {
            return null;
        }
        JsonArray array = new JsonArray();
        for (Long channelId : channels) {
            array.add((JsonElement)new JsonPrimitive((Number)channelId));
        }
        return array;
    }

    public ChannelConfigType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ChannelConfigType channelConfigType = new ChannelConfigType();
        if (json.isJsonArray()) {
            ArrayList<Long> channels = new ArrayList<Long>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement element : array) {
                Long longValue;
                JsonPrimitive primitive;
                if (!element.isJsonPrimitive() || !(primitive = (JsonPrimitive)element).isNumber() || (longValue = Long.valueOf(primitive.getAsLong())) <= 0L) continue;
                channels.add(longValue);
            }
            channelConfigType.setChannels(channels).setDefault(false).setDisabled(false);
        } else if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                Long longValue = primitive.getAsLong();
                if (longValue > 0L) {
                    channelConfigType.addChannel(longValue).setDefault(false).setDisabled(false);
                }
            } else if (primitive.isBoolean()) {
                if (primitive.getAsBoolean()) {
                    channelConfigType.setDefault(true).setDisabled(false);
                } else {
                    channelConfigType.setDefault(false).setDisabled(true);
                }
            }
        }
        return channelConfigType;
    }
}

