/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.types;

import chikachi.discord.core.config.types.MessageConfig;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class MessageConfigAdapter
implements JsonSerializer<MessageConfig>,
JsonDeserializer<MessageConfig> {
    public JsonElement serialize(MessageConfig src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.normal.equals(src.webhook)) {
            return new JsonPrimitive(src.normal);
        }
        JsonObject object = new JsonObject();
        object.add("normal", (JsonElement)new JsonPrimitive(src.normal));
        object.add("webhook", (JsonElement)new JsonPrimitive(src.webhook));
        return object;
    }

    public MessageConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String normal = null;
        String webhook = null;
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            if (object.has("normal")) {
                normal = object.get("normal").getAsString();
            }
            if (object.has("webhook")) {
                webhook = object.get("webhook").getAsString();
            }
            if (normal == null && webhook == null) {
                return null;
            }
            return new MessageConfig(normal != null ? normal : webhook, webhook != null ? webhook : normal);
        }
        if (json.isJsonPrimitive()) {
            return new MessageConfig(json.getAsString());
        }
        return null;
    }
}

