/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.listener;

import chikachi.discord.DiscordCommandSender;
import chikachi.discord.IMCHandler;
import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.Message;
import chikachi.discord.core.Patterns;
import chikachi.discord.core.config.ConfigWrapper;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.discord.CommandConfig;
import chikachi.discord.core.config.discord.DiscordChannelGenericConfig;
import chikachi.discord.core.config.discord.DiscordConfig;
import chikachi.discord.core.config.linking.LinkingRequest;
import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.ListenerAdapter;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class DiscordListener
extends ListenerAdapter {
    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        String prefix;
        ConfigWrapper config = Configuration.getConfig();
        DiscordConfig discordConfig = config.discord;
        if (discordConfig.ignoresBots && event.getAuthor().isBot()) {
            return;
        }
        if (event.getAuthor().getId().equals(DiscordClient.getInstance().getSelf().getId())) {
            return;
        }
        if (discordConfig.isIgnoringUser(event.getAuthor())) {
            return;
        }
        String content = event.getMessage().getContentDisplay().trim();
        if (event.getChannelType() == ChannelType.TEXT) {
            String prefix2;
            ArrayList<Integer> dimensions;
            DiscordChannelGenericConfig channelConfig;
            Long channelId = event.getChannel().getIdLong();
            boolean stripMinecraftCodes = discordConfig.channels.generic.stripMinecraftCodes;
            if (discordConfig.channels.channels.containsKey(channelId)) {
                channelConfig = discordConfig.channels.channels.get(channelId);
                dimensions = channelConfig.relayChat.getDimensions(discordConfig.channels.generic.relayChat);
                if (channelConfig.stripMinecraftCodes != null) {
                    stripMinecraftCodes = channelConfig.stripMinecraftCodes;
                }
            } else {
                return;
            }
            if (dimensions == null) {
                return;
            }
            if (IMCHandler.haveListeners()) {
                NBTTagCompound eventTagCompound = new NBTTagCompound();
                eventTagCompound.func_74778_a("type", "chat");
                NBTTagCompound userTagComponent = new NBTTagCompound();
                userTagComponent.func_74778_a("id", event.getAuthor().getId());
                userTagComponent.func_74778_a("username", event.getAuthor().getName());
                userTagComponent.func_74778_a("discriminator", event.getAuthor().getDiscriminator());
                eventTagCompound.func_74782_a("user", (NBTBase)userTagComponent);
                eventTagCompound.func_74778_a("message", content);
                IMCHandler.emitMessage("event", eventTagCompound);
            }
            String string = prefix2 = channelConfig.commandPrefix != null ? channelConfig.commandPrefix : discordConfig.channels.generic.commandPrefix;
            if (content.startsWith(prefix2)) {
                ArrayList<String> args = new ArrayList<String>(Arrays.asList(content.substring(prefix2.length()).split(" ")));
                this.tryExecuteCommand(event, args);
                return;
            }
            MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            List players = dimensions.size() == 0 ? minecraftServer.func_184103_al().func_181057_v() : minecraftServer.func_184103_al().func_181057_v().stream().filter(player -> dimensions.contains(player.field_71093_bK)).collect(Collectors.toList());
            if (stripMinecraftCodes) {
                content = Patterns.minecraftCodePattern.matcher(content).replaceAll("");
            }
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("MESSAGE", content);
            Message message = new Message().setAuthor(event.getMember().getEffectiveName()).setMessage(config.discord.channels.generic.messages.chatMessage).setArguments(arguments);
            DiscordIntegrationLogger.Log(message.getFormattedTextMinecraft());
            for (EntityPlayerMP player2 : players) {
                player2.func_145747_a((ITextComponent)new TextComponentString(message.getFormattedTextMinecraft()));
            }
        } else if (event.getChannelType() == ChannelType.PRIVATE && Configuration.getConfig().discord.channels.generic.allowDMCommands.booleanValue() && content.startsWith(prefix = discordConfig.channels.generic.commandPrefix)) {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(content.substring(prefix.length()).split(" ")));
            this.tryExecuteCommand(event, args);
        }
    }

    private void tryExecuteCommand(MessageReceivedEvent event, List<String> args) {
        MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        String cmd = args.remove(0);
        if (Configuration.getConfig().discord.allowLinking) {
            if (cmd.equalsIgnoreCase("link")) {
                UUID minecraftUUID = Configuration.getLinking().getMinecraftId(event.getAuthor().getIdLong());
                if (minecraftUUID != null) {
                    GameProfile minecraftProfile = minecraftServer.func_152358_ax().func_152652_a(minecraftUUID);
                    event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage(String.format("You are already linked to %s", minecraftProfile == null ? "a Minecraft account" : minecraftProfile.getName())).queue());
                    return;
                }
                LinkingRequest request = Configuration.getLinking().getRequest(event.getAuthor().getIdLong());
                if (request.hasExpired()) {
                    request.generateCode();
                }
                event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage(String.format("Use `/discord link %s` on the Minecraft server to link your Discord user with your Minecraft user.\nThe code expires in %s!", request.getCode(), request.expiresIn())).queue());
                if (event.getMember().getPermissions(event.getTextChannel()).contains((Object)Permission.MESSAGE_MANAGE)) {
                    event.getMessage().delete().queue();
                }
                Configuration.saveLinking();
                return;
            }
            if (cmd.equalsIgnoreCase("unlink")) {
                UUID minecraftUUID = Configuration.getLinking().getMinecraftId(event.getAuthor().getIdLong());
                if (minecraftUUID == null) {
                    event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage("You aren't linked").queue());
                } else {
                    Configuration.getLinking().removeLink(minecraftUUID);
                    event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage("Unlinked").queue());
                }
                if (event.getMember().getPermissions(event.getTextChannel()).contains((Object)Permission.MESSAGE_MANAGE)) {
                    event.getMessage().delete().queue();
                }
                return;
            }
        }
        ArrayList<CommandConfig> commands = Configuration.getConfig().discord.getCommandConfigs();
        for (CommandConfig command : commands) {
            if (!command.shouldExecute(cmd, event.getAuthor(), event.getChannel())) continue;
            FMLCommonHandler.instance().getMinecraftServerInstance().func_175586_a(() -> {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D().func_71556_a((ICommandSender)new DiscordCommandSender(event.getChannel(), event.getAuthor()), command.buildCommand(args));
                return 0;
            });
            return;
        }
    }
}

