/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.client.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.CallUser;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.CallableChannel;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.Group;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.CallImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.CallUserImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.CallVoiceStateImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.Region;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import gnu.trove.map.TLongObjectMap;

public class CallCreateHandler
extends SocketHandler {
    public CallCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long channelId = content.getLong("channel_id");
        long messageId = content.getLong("message_id");
        Region region = Region.fromKey(content.getString("region"));
        JSONArray voiceStates = content.getJSONArray("voice_states");
        JSONArray ringing = content.getJSONArray("ringing");
        CallableChannel channel = this.api.asClient().getGroupById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CALL_CREATE for a Group/PrivateChannel that is not yet cached. JSON: {}", (Object)content);
            return null;
        }
        CallImpl call = new CallImpl(channel, messageId);
        call.setRegion(region);
        TLongObjectMap<CallUser> callUsers = call.getCallUserMap();
        if (channel instanceof Group) {
            GroupImpl group = (GroupImpl)channel;
            if (group.getCurrentCall() != null) {
                WebSocketClient.LOG.error("Received a CALL_CREATE for a Group that already has an active call cached! JSON: {}", (Object)content);
            }
            group.setCurrentCall(call);
            group.getUserMap().forEachEntry((userId, user) -> {
                CallUserImpl callUser = new CallUserImpl(call, (User)user);
                callUsers.put(userId, callUser);
                for (int i = 0; i < ringing.length(); ++i) {
                    long current = ringing.getLong(i);
                    if (current != userId) continue;
                    callUser.setRinging(true);
                    break;
                }
                return true;
            });
        } else {
            PrivateChannelImpl priv = (PrivateChannelImpl)channel;
            if (priv.getCurrentCall() != null) {
                WebSocketClient.LOG.error("Received a CALL_CREATE for a PrivateChannel that already has an active call cached! JSON: {}", (Object)content);
            }
            priv.setCurrentCall(call);
            callUsers.put(priv.getUser().getIdLong(), new CallUserImpl(call, priv.getUser()));
            callUsers.put(this.api.getSelfUser().getIdLong(), new CallUserImpl(call, this.api.getSelfUser()));
        }
        for (int i = 0; i < voiceStates.length(); ++i) {
            JSONObject voiceState = voiceStates.getJSONObject(i);
            long userId2 = voiceState.getLong("user_id");
            CallUser cUser = callUsers.get(userId2);
            CallVoiceStateImpl vState = (CallVoiceStateImpl)cUser.getVoiceState();
            vState.setInCall(true);
            vState.setSessionId(voiceState.getString("session_id"));
            vState.setSelfMuted(voiceState.getBoolean("self_mute"));
            vState.setSelfDeafened(voiceState.getBoolean("self_deaf"));
            this.api.asClient().getCallUserMap().put(userId2, cUser);
        }
        this.api.getEventCache().playbackCache(EventCache.Type.CALL, channelId);
        return null;
    }
}

