/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.client.managers;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.Application;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.ApplicationImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.managers.fields.ApplicationField;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Icon;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;

public class ApplicationManagerUpdatable {
    public static final Pattern URL_PATTERN = Pattern.compile("\\s*https?://.+\\..{2,}\\s*", 2);
    private final ApplicationImpl application;
    private ApplicationField<String> description;
    private ApplicationField<Boolean> doesBotRequireCodeGrant;
    private ApplicationField<Icon> icon;
    private ApplicationField<Boolean> isBotPublic;
    private ApplicationField<String> name;
    private ApplicationField<List<String>> redirectUris;

    public ApplicationManagerUpdatable(ApplicationImpl application) {
        this.application = application;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.application.getJDA();
    }

    public final Application getApplication() {
        return this.application;
    }

    public final ApplicationField<String> getDescriptionField() {
        return this.description;
    }

    public final ApplicationField<Boolean> getDoesBotRequireCodeGrantField() {
        return this.doesBotRequireCodeGrant;
    }

    public final ApplicationField<Icon> getIconField() {
        return this.icon;
    }

    public final ApplicationField<Boolean> getIsBotPublicField() {
        return this.isBotPublic;
    }

    public final ApplicationField<String> getNameField() {
        return this.name;
    }

    public final ApplicationField<List<String>> getRedirectUrisField() {
        return this.redirectUris;
    }

    public void reset() {
        this.description.reset();
        this.doesBotRequireCodeGrant.reset();
        this.icon.reset();
        this.isBotPublic.reset();
        this.name.reset();
        this.redirectUris.reset();
    }

    protected boolean needsUpdate() {
        return this.description.shouldUpdate() || this.doesBotRequireCodeGrant.shouldUpdate() || this.icon.shouldUpdate() || this.isBotPublic.shouldUpdate() || this.name.shouldUpdate() || this.redirectUris.shouldUpdate();
    }

    protected void setupFields() {
        this.description = new ApplicationField<String>(this, this.application::getDescription){

            @Override
            public void checkValue(String value) {
                if (value != null && value.length() > 400) {
                    throw new IllegalArgumentException("application description must not be more than 400 characters long");
                }
            }
        };
        this.doesBotRequireCodeGrant = new ApplicationField<Boolean>(this, this.application::doesBotRequireCodeGrant){

            @Override
            public void checkValue(Boolean value) {
                Checks.notNull(value, "doesBotRequireCodeGrant");
            }
        };
        this.icon = new ApplicationField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Avatar. Use Application#getIconUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.isBotPublic = new ApplicationField<Boolean>(this, this.application::isBotPublic){

            @Override
            public void checkValue(Boolean value) {
                Checks.notNull(value, "isBotPublic");
            }
        };
        this.name = new ApplicationField<String>(this, this.application::getName){

            @Override
            public void checkValue(String value) {
                Checks.notNull(value, "application name");
                if (value.length() < 2 || value.length() > 32) {
                    throw new IllegalArgumentException("Application name must be 2 to 32 characters in length");
                }
            }
        };
        this.redirectUris = new ApplicationField<List<String>>(this, this.application::getRedirectUris){

            @Override
            public void checkValue(List<String> value) {
                Checks.notNull(value, "redirect uris");
                for (String url : value) {
                    Checks.notNull(url, "redirect uri");
                    if (URL_PATTERN.matcher(url).matches()) continue;
                    throw new IllegalArgumentException("URL must be a valid http or https url.");
                }
            }

            @Override
            public ApplicationManagerUpdatable setValue(List<String> value) {
                this.checkValue(value);
                this.value = Collections.unmodifiableList(new ArrayList<String>(value));
                this.set = true;
                return (ApplicationManagerUpdatable)this.manager;
            }
        };
    }

    @CheckReturnValue
    public RestAction<Void> update() {
        if (!this.needsUpdate()) {
            return new RestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject();
        body.put("description", this.description.shouldUpdate() ? this.description.getValue() : this.description.getOriginalValue());
        body.put("bot_require_code_grant", this.doesBotRequireCodeGrant.shouldUpdate() ? (Boolean)this.doesBotRequireCodeGrant.getValue() : (Boolean)this.doesBotRequireCodeGrant.getOriginalValue());
        body.put("icon", this.icon.shouldUpdate() ? (this.icon.getValue() == null ? JSONObject.NULL : ((Icon)this.icon.getValue()).getEncoding()) : this.application.getIconUrl());
        body.put("bot_public", this.isBotPublic.shouldUpdate() ? (Boolean)this.isBotPublic.getValue() : (Boolean)this.isBotPublic.getOriginalValue());
        body.put("name", this.name.shouldUpdate() ? this.name.getValue() : this.name.getOriginalValue());
        body.put("redirect_uris", this.redirectUris.shouldUpdate() ? (Collection)this.redirectUris.getValue() : (Collection)this.redirectUris.getOriginalValue());
        this.reset();
        Route.CompiledRoute route = Route.Applications.MODIFY_APPLICATION.compile(this.application.getId());
        return new RestAction<Void>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    ApplicationManagerUpdatable.this.application.updateFromJson(response.getObject());
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

