/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core;

import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.EmbedType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageEmbed;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Helpers;
import java.awt.Color;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class EmbedBuilder {
    public static final String ZERO_WIDTH_SPACE = "\u200e";
    public static final Pattern URL_PATTERN = Pattern.compile("\\s*(https?|attachment)://.+\\..{2,}\\s*", 2);
    private final List<MessageEmbed.Field> fields = new LinkedList<MessageEmbed.Field>();
    private final StringBuilder description = new StringBuilder();
    private String url;
    private String title;
    private OffsetDateTime timestamp;
    private Color color;
    private MessageEmbed.Thumbnail thumbnail;
    private MessageEmbed.AuthorInfo author;
    private MessageEmbed.Footer footer;
    private MessageEmbed.ImageInfo image;

    public EmbedBuilder() {
    }

    public EmbedBuilder(EmbedBuilder builder) {
        if (builder != null) {
            this.setDescription(builder.description.toString());
            this.fields.addAll(builder.fields);
            this.url = builder.url;
            this.title = builder.title;
            this.timestamp = builder.timestamp;
            this.color = builder.color;
            this.thumbnail = builder.thumbnail;
            this.author = builder.author;
            this.footer = builder.footer;
            this.image = builder.image;
        }
    }

    public EmbedBuilder(MessageEmbed embed) {
        if (embed != null) {
            this.setDescription(embed.getDescription());
            this.url = embed.getUrl();
            this.title = embed.getTitle();
            this.timestamp = embed.getTimestamp();
            this.color = embed.getColor();
            this.thumbnail = embed.getThumbnail();
            this.author = embed.getAuthor();
            this.footer = embed.getFooter();
            this.image = embed.getImage();
            if (embed.getFields() != null) {
                this.fields.addAll(embed.getFields());
            }
        }
    }

    public MessageEmbed build() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot build an empty embed!");
        }
        if (this.description.length() > 2048) {
            throw new IllegalStateException(String.format("Description is longer than %d! Please limit your input!", 2048));
        }
        String descrip = this.description.length() < 1 ? null : this.description.toString();
        return EntityBuilder.createMessageEmbed(this.url, this.title, descrip, EmbedType.RICH, this.timestamp, this.color, this.thumbnail, null, this.author, null, this.footer, this.image, new LinkedList<MessageEmbed.Field>(this.fields));
    }

    public EmbedBuilder clear() {
        this.description.setLength(0);
        this.fields.clear();
        this.url = null;
        this.title = null;
        this.timestamp = null;
        this.color = null;
        this.thumbnail = null;
        this.author = null;
        this.footer = null;
        this.image = null;
        return this;
    }

    public boolean isEmpty() {
        return this.title == null && this.description.length() == 0 && this.timestamp == null && this.thumbnail == null && this.author == null && this.footer == null && this.image == null && this.fields.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        int length = this.description.length();
        List<MessageEmbed.Field> list = this.fields;
        synchronized (list) {
            length = this.fields.stream().map(f -> f.getName().length() + f.getValue().length()).reduce(length, Integer::sum);
        }
        if (this.title != null) {
            length += this.title.length();
        }
        if (this.author != null) {
            length += this.author.getName().length();
        }
        if (this.footer != null) {
            length += this.footer.getText().length();
        }
        return length;
    }

    public boolean isValidLength(AccountType type) {
        Checks.notNull((Object)type, "AccountType");
        int length = this.length();
        switch (type) {
            case BOT: {
                return length <= 6000;
            }
        }
        return length <= 2000;
    }

    public EmbedBuilder setTitle(String title) {
        return this.setTitle(title, null);
    }

    public EmbedBuilder setTitle(String title, String url) {
        if (title == null) {
            this.title = null;
            this.url = null;
        } else {
            if (title.isEmpty()) {
                throw new IllegalArgumentException("Title cannot be empty!");
            }
            if (title.length() > 256) {
                throw new IllegalArgumentException("Title cannot be longer than 256 characters.");
            }
            if (Helpers.isBlank(url)) {
                url = null;
            }
            this.urlCheck(url);
            this.title = title;
            this.url = url;
        }
        return this;
    }

    public StringBuilder getDescriptionBuilder() {
        return this.description;
    }

    public final EmbedBuilder setDescription(CharSequence description) {
        this.description.setLength(0);
        if (description != null && description.length() >= 1) {
            this.appendDescription(description);
        }
        return this;
    }

    public EmbedBuilder appendDescription(CharSequence description) {
        Checks.notNull(description, "description");
        Checks.check(this.description.length() + description.length() <= 2048, "Description cannot be longer than %d characters.", (Object)2048);
        this.description.append(description);
        return this;
    }

    public EmbedBuilder setTimestamp(TemporalAccessor temporal) {
        if (temporal == null) {
            this.timestamp = null;
        } else if (temporal instanceof OffsetDateTime) {
            this.timestamp = (OffsetDateTime)temporal;
        } else {
            ZoneOffset offset;
            try {
                offset = ZoneOffset.from(temporal);
            }
            catch (DateTimeException ignore) {
                offset = ZoneOffset.UTC;
            }
            try {
                LocalDateTime ldt = LocalDateTime.from(temporal);
                this.timestamp = OffsetDateTime.of(ldt, offset);
            }
            catch (DateTimeException ignore) {
                try {
                    Instant instant = Instant.from(temporal);
                    this.timestamp = OffsetDateTime.ofInstant(instant, offset);
                }
                catch (DateTimeException ex) {
                    throw new DateTimeException("Unable to obtain OffsetDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
                }
            }
        }
        return this;
    }

    public EmbedBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public EmbedBuilder setThumbnail(String url) {
        if (url == null) {
            this.thumbnail = null;
        } else {
            this.urlCheck(url);
            this.thumbnail = new MessageEmbed.Thumbnail(url, null, 0, 0);
        }
        return this;
    }

    public EmbedBuilder setImage(String url) {
        if (url == null) {
            this.image = null;
        } else {
            this.urlCheck(url);
            this.image = new MessageEmbed.ImageInfo(url, null, 0, 0);
        }
        return this;
    }

    public EmbedBuilder setAuthor(String name) {
        return this.setAuthor(name, null, null);
    }

    public EmbedBuilder setAuthor(String name, String url) {
        return this.setAuthor(name, url, null);
    }

    public EmbedBuilder setAuthor(String name, String url, String iconUrl) {
        if (name == null) {
            this.author = null;
        } else {
            this.urlCheck(url);
            this.urlCheck(iconUrl);
            this.author = new MessageEmbed.AuthorInfo(name, url, iconUrl, null);
        }
        return this;
    }

    public EmbedBuilder setFooter(String text, String iconUrl) {
        if (text == null) {
            this.footer = null;
        } else {
            if (text.length() > 2048) {
                throw new IllegalArgumentException("Text cannot be longer than 2048 characters.");
            }
            this.urlCheck(iconUrl);
            this.footer = new MessageEmbed.Footer(text, iconUrl, null);
        }
        return this;
    }

    public EmbedBuilder addField(MessageEmbed.Field field) {
        return field == null ? this : this.addField(field.getName(), field.getValue(), field.isInline());
    }

    public EmbedBuilder addField(String name, String value, boolean inline) {
        if (name == null && value == null) {
            return this;
        }
        this.fields.add(new MessageEmbed.Field(name, value, inline));
        return this;
    }

    public EmbedBuilder addBlankField(boolean inline) {
        this.fields.add(new MessageEmbed.Field(ZERO_WIDTH_SPACE, ZERO_WIDTH_SPACE, inline));
        return this;
    }

    public EmbedBuilder clearFields() {
        this.fields.clear();
        return this;
    }

    public List<MessageEmbed.Field> getFields() {
        return this.fields;
    }

    private void urlCheck(String url) {
        if (url == null) {
            return;
        }
        if (url.length() > 2000) {
            throw new IllegalArgumentException("URL cannot be longer than 2000 characters.");
        }
        if (!URL_PATTERN.matcher(url).matches()) {
            throw new IllegalArgumentException("URL must be a valid http or https url.");
        }
    }
}

