/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.audio;

import chikachi.discord.repack.com.neovisionaries.ws.client.ThreadType;
import chikachi.discord.repack.com.neovisionaries.ws.client.WebSocket;
import chikachi.discord.repack.com.neovisionaries.ws.client.WebSocketAdapter;
import chikachi.discord.repack.com.neovisionaries.ws.client.WebSocketException;
import chikachi.discord.repack.com.neovisionaries.ws.client.WebSocketFrame;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.AudioConnection;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.VoiceCode;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import chikachi.discord.repack.net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.ExceptionEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.JDALogger;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import chikachi.discord.repack.org.slf4j.Logger;
import chikachi.discord.repack.org.slf4j.MDC;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class AudioWebSocket
extends WebSocketAdapter {
    public static final Logger LOG = JDALogger.getLog(AudioWebSocket.class);
    public static final int DISCORD_SECRET_KEY_LENGTH = 32;
    public static final int AUDIO_GATEWAY_VERSION = 3;
    protected final ConnectionListener listener;
    protected final ScheduledThreadPoolExecutor keepAlivePool;
    protected AudioConnection audioConnection;
    protected ConnectionStatus connectionStatus = ConnectionStatus.NOT_CONNECTED;
    private final JDAImpl api;
    private final Guild guild;
    private final String endpoint;
    private final String sessionId;
    private final String token;
    private boolean connected = false;
    private boolean ready = false;
    private boolean reconnecting = false;
    private Future<?> keepAliveHandle;
    private String wssEndpoint;
    private boolean shouldReconnect;
    private int ssrc;
    private byte[] secretKey;
    private DatagramSocket udpSocket;
    private InetSocketAddress address;
    private volatile boolean shutdown = false;
    public WebSocket socket;

    public AudioWebSocket(ConnectionListener listener, String endpoint, JDAImpl api, Guild guild, String sessionId, String token, boolean shouldReconnect) {
        this.listener = listener;
        this.endpoint = endpoint;
        this.api = api;
        this.guild = guild;
        this.sessionId = sessionId;
        this.token = token;
        this.shouldReconnect = shouldReconnect;
        this.keepAlivePool = api.getAudioKeepAlivePool();
        this.wssEndpoint = String.format("wss://%s/?v=%d", endpoint, 3);
        if (sessionId == null || sessionId.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty sessionId!");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a voice connection using a null/empty token!");
        }
    }

    protected void send(String message) {
        LOG.trace("<- {}", (Object)message);
        this.socket.sendText(message);
    }

    protected void send(int op, Object data) {
        this.send(new JSONObject().put("op", op).put("d", data == null ? JSONObject.NULL : data).toString());
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) {
        if (this.api.getContextMap() != null) {
            MDC.setContextMap(this.api.getContextMap());
        }
        if (this.shutdown) {
            this.socket.sendClose(1000);
            return;
        }
        if (this.reconnecting) {
            this.resume();
        } else {
            this.identify();
        }
        this.connected = true;
        this.reconnecting = false;
        this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_AUTHENTICATING);
        if (!this.reconnecting) {
            this.audioConnection.ready();
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) {
        try {
            if (this.api.getContextMap() != null) {
                MDC.setContextMap(this.api.getContextMap());
            }
            this.handleEvent(new JSONObject(message));
        }
        catch (Exception ex) {
            LOG.error("Encountered exception trying to handle an event message: {}", (Object)message, (Object)ex);
        }
    }

    private void handleEvent(JSONObject contentAll) {
        int opCode = contentAll.getInt("op");
        switch (opCode) {
            case 8: {
                LOG.trace("-> HELLO {}", (Object)contentAll);
                JSONObject payload = contentAll.getJSONObject("d");
                int interval = payload.getInt("heartbeat_interval");
                this.stopKeepAlive();
                this.setupKeepAlive(interval / 2);
                break;
            }
            case 2: {
                InetSocketAddress externalIpAndPort;
                LOG.trace("-> READY {}", (Object)contentAll);
                JSONObject content = contentAll.getJSONObject("d");
                this.ssrc = content.getInt("ssrc");
                int port = content.getInt("port");
                this.changeStatus(ConnectionStatus.CONNECTING_ATTEMPTING_UDP_DISCOVERY);
                int tries = 0;
                do {
                    if ((externalIpAndPort = this.handleUdpDiscovery(new InetSocketAddress(this.endpoint, port), this.ssrc)) != null || ++tries <= 5) continue;
                    this.close(ConnectionStatus.ERROR_UDP_UNABLE_TO_CONNECT);
                    return;
                } while (externalIpAndPort == null);
                JSONObject object = new JSONObject().put("protocol", "udp").put("data", new JSONObject().put("address", externalIpAndPort.getHostString()).put("port", externalIpAndPort.getPort()).put("mode", "xsalsa20_poly1305"));
                this.send(1, object);
                this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_READY);
                break;
            }
            case 9: {
                LOG.trace("-> RESUMED {}", (Object)contentAll);
                LOG.debug("Successfully resumed session!");
                this.changeStatus(ConnectionStatus.CONNECTED);
                this.ready = true;
                break;
            }
            case 4: {
                LOG.trace("-> SESSION_DESCRIPTION {}", (Object)contentAll);
                JSONArray keyArray = contentAll.getJSONObject("d").getJSONArray("secret_key");
                this.secretKey = new byte[32];
                for (int i = 0; i < keyArray.length(); ++i) {
                    this.secretKey[i] = (byte)keyArray.getInt(i);
                }
                LOG.trace("Audio connection has finished connecting!");
                this.ready = true;
                this.changeStatus(ConnectionStatus.CONNECTED);
                break;
            }
            case 3: {
                LOG.trace("-> HEARTBEAT {}", (Object)contentAll);
                this.send(3, System.currentTimeMillis());
                break;
            }
            case 6: {
                LOG.trace("-> HEARTBEAT_ACK {}", (Object)contentAll);
                long ping = System.currentTimeMillis() - contentAll.getLong("d");
                this.listener.onPing(ping);
                break;
            }
            case 5: {
                LOG.trace("-> USER_SPEAKING_UPDATE {}", (Object)contentAll);
                JSONObject content = contentAll.getJSONObject("d");
                boolean speaking = content.getBoolean("speaking");
                int ssrc = content.getInt("ssrc");
                long userId = content.getLong("user_id");
                User user = this.getUser(userId);
                if (user == null) {
                    AudioConnection.LOG.trace("Got an Audio USER_SPEAKING_UPDATE for a non-existent User. JSON: {}", (Object)contentAll);
                    break;
                }
                this.audioConnection.updateUserSSRC(ssrc, userId);
                this.listener.onUserSpeaking(user, speaking);
                break;
            }
            case 13: {
                LOG.trace("-> USER_DISCONNECT {}", (Object)contentAll);
                JSONObject payload = contentAll.getJSONObject("d");
                long userId = payload.getLong("user_id");
                this.audioConnection.removeUserSSRC(userId);
                break;
            }
            case 12: {
                LOG.trace("-> OP 12 {}", (Object)contentAll);
                break;
            }
            default: {
                LOG.debug("Unknown Audio OP code.\n{}", (Object)contentAll);
            }
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        LOG.debug("The Audio connection was closed!\nBy remote? {}", (Object)closedByServer);
        if (serverCloseFrame != null) {
            LOG.debug("Reason: {}\nClose code: {}", (Object)serverCloseFrame.getCloseReason(), (Object)serverCloseFrame.getCloseCode());
            int code = serverCloseFrame.getCloseCode();
            VoiceCode.Close closeCode = VoiceCode.Close.from(code);
            switch (closeCode) {
                case SERVER_NOT_FOUND: 
                case SERVER_CRASH: 
                case INVALID_SESSION: {
                    this.close(ConnectionStatus.ERROR_CANNOT_RESUME);
                    break;
                }
                case AUTHENTICATION_FAILED: {
                    this.close(ConnectionStatus.DISCONNECTED_AUTHENTICATION_FAILURE);
                    break;
                }
                default: {
                    this.reconnect(ConnectionStatus.ERROR_LOST_CONNECTION);
                }
            }
            return;
        }
        if (clientCloseFrame != null) {
            LOG.debug("ClientReason: {}\nClientCode: {}", (Object)clientCloseFrame.getCloseReason(), (Object)clientCloseFrame.getCloseCode());
            if (clientCloseFrame.getCloseCode() != 1000) {
                this.reconnect(ConnectionStatus.ERROR_LOST_CONNECTION);
                return;
            }
        }
        this.close(ConnectionStatus.NOT_CONNECTED);
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) {
        this.handleCallbackError(websocket, cause);
    }

    @Override
    public void handleCallbackError(WebSocket websocket, Throwable cause) {
        MDC.setContextMap(this.api.getContextMap());
        LOG.error("There was some audio websocket error", cause);
        this.api.getEventManager().handle(new ExceptionEvent(this.api, cause, true));
    }

    @Override
    public void onThreadCreated(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
        String identifier = this.api.getIdentifierString();
        String guildId = this.guild.getId();
        switch (threadType) {
            case CONNECT_THREAD: {
                thread.setName(identifier + " AudioWS-ConnectThread (guildId: " + guildId + ')');
                break;
            }
            case FINISH_THREAD: {
                thread.setName(identifier + " AudioWS-FinishThread (guildId: " + guildId + ')');
                break;
            }
            case WRITING_THREAD: {
                thread.setName(identifier + " AudioWS-WriteThread (guildId: " + guildId + ')');
                break;
            }
            case READING_THREAD: {
                thread.setName(identifier + " AudioWS-ReadThread (guildId: " + guildId + ')');
                break;
            }
            default: {
                thread.setName(identifier + " AudioWS-" + (Object)((Object)threadType) + " (guildId: " + guildId + ')');
            }
        }
    }

    @Override
    public void onConnectError(WebSocket webSocket, WebSocketException e) {
        MDC.setContextMap(this.api.getContextMap());
        LOG.warn("Failed to establish websocket connection: {} - {}\nClosing connection and attempting to reconnect.", (Object)e.getError(), (Object)e.getMessage());
        this.close(ConnectionStatus.ERROR_WEBSOCKET_UNABLE_TO_CONNECT);
    }

    private void identify() {
        JSONObject connectObj = new JSONObject().put("server_id", this.guild.getId()).put("user_id", this.api.getSelfUser().getId()).put("session_id", this.sessionId).put("token", this.token);
        this.send(0, connectObj);
    }

    private void resume() {
        LOG.debug("Sending resume payload...");
        JSONObject resumeObj = new JSONObject().put("server_id", this.guild.getId()).put("session_id", this.sessionId).put("token", this.token);
        this.send(7, resumeObj);
    }

    public void startConnection() {
        if (!this.reconnecting && this.socket != null) {
            throw new IllegalStateException("Somehow, someway, this AudioWebSocket has already attempted to start a connection!");
        }
        try {
            this.socket = this.api.getWebSocketFactory().createSocket(this.wssEndpoint).addListener(this);
            this.changeStatus(ConnectionStatus.CONNECTING_AWAITING_WEBSOCKET_CONNECT);
            this.socket.connectAsynchronously();
        }
        catch (IOException e) {
            LOG.warn("Encountered IOException while attempting to connect: {}\nClosing connection and attempting to reconnect.", (Object)e.getMessage());
            this.close(ConnectionStatus.ERROR_WEBSOCKET_UNABLE_TO_CONNECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked(Consumer<AudioManagerImpl> runnable) {
        AudioManagerImpl manager = (AudioManagerImpl)this.guild.getAudioManager();
        Object object = manager.CONNECTION_LOCK;
        synchronized (object) {
            runnable.accept(manager);
        }
    }

    public void reconnect(ConnectionStatus closeStatus) {
        if (this.shutdown) {
            return;
        }
        this.locked(unused -> {
            if (this.shutdown) {
                return;
            }
            this.connected = false;
            this.ready = false;
            this.reconnecting = true;
            this.changeStatus(closeStatus);
            this.startConnection();
        });
    }

    public void close(ConnectionStatus closeStatus) {
        if (this.shutdown) {
            return;
        }
        this.locked(manager -> {
            Guild connGuild;
            if (this.shutdown) {
                return;
            }
            ConnectionStatus status = closeStatus;
            this.connected = false;
            this.ready = false;
            this.shutdown = true;
            this.stopKeepAlive();
            if (this.udpSocket != null) {
                this.udpSocket.close();
            }
            if (this.socket != null && this.socket.isOpen()) {
                this.socket.sendClose(1000);
            }
            if (this.audioConnection != null) {
                this.audioConnection.shutdown();
            }
            VoiceChannel disconnectedChannel = manager.getConnectedChannel() != null ? manager.getConnectedChannel() : manager.getQueuedAudioConnection();
            manager.setAudioConnection(null);
            if (status == ConnectionStatus.ERROR_LOST_CONNECTION && (connGuild = this.api.getGuildById(this.guild.getIdLong())) != null && connGuild.getVoiceChannelById(this.audioConnection.getChannel().getIdLong()) == null) {
                status = ConnectionStatus.DISCONNECTED_CHANNEL_DELETED;
            }
            this.changeStatus(status);
            if (this.shouldReconnect && status != ConnectionStatus.NOT_CONNECTED && status != ConnectionStatus.DISCONNECTED_CHANNEL_DELETED && status != ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD && status != ConnectionStatus.AUDIO_REGION_CHANGE) {
                manager.setQueuedAudioConnection(disconnectedChannel);
                this.api.getClient().queueAudioReconnect(disconnectedChannel);
            } else if (status != ConnectionStatus.AUDIO_REGION_CHANGE) {
                this.api.getClient().queueAudioDisconnect(this.guild);
            }
        });
    }

    public DatagramSocket getUdpSocket() {
        return this.udpSocket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public byte[] getSecretKey() {
        return Arrays.copyOf(this.secretKey, this.secretKey.length);
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isReady() {
        return this.ready;
    }

    private InetSocketAddress handleUdpDiscovery(InetSocketAddress address, int ssrc) {
        try {
            this.udpSocket = new DatagramSocket();
            ByteBuffer buffer = ByteBuffer.allocate(70);
            buffer.putInt(ssrc);
            DatagramPacket discoveryPacket = new DatagramPacket(buffer.array(), buffer.array().length, address);
            this.udpSocket.send(discoveryPacket);
            DatagramPacket receivedPacket = new DatagramPacket(new byte[70], 70);
            this.udpSocket.setSoTimeout(1000);
            this.udpSocket.receive(receivedPacket);
            byte[] received = receivedPacket.getData();
            String ourIP = new String(receivedPacket.getData());
            ourIP = ourIP.substring(4, ourIP.length() - 2);
            ourIP = ourIP.trim();
            byte[] portBytes = new byte[]{received[received.length - 1], received[received.length - 2]};
            int firstByte = 0xFF & portBytes[0];
            int secondByte = 0xFF & portBytes[1];
            int ourPort = firstByte << 8 | secondByte;
            this.address = address;
            return new InetSocketAddress(ourIP, ourPort);
        }
        catch (SocketException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void stopKeepAlive() {
        if (this.keepAliveHandle != null) {
            this.keepAliveHandle.cancel(true);
        }
        this.keepAliveHandle = null;
    }

    private void setupKeepAlive(int keepAliveInterval) {
        if (this.keepAliveHandle != null) {
            LOG.error("Setting up a KeepAlive runnable while the previous one seems to still be active!!");
        }
        Runnable keepAliveRunnable = () -> {
            if (this.socket != null && this.socket.isOpen()) {
                this.send(3, System.currentTimeMillis());
            }
            if (this.udpSocket != null && !this.udpSocket.isClosed()) {
                long seq = 0L;
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(9);
                    buffer.put((byte)-55);
                    buffer.putLong(seq);
                    DatagramPacket keepAlivePacket = new DatagramPacket(buffer.array(), buffer.array().length, this.address);
                    this.udpSocket.send(keepAlivePacket);
                }
                catch (NoRouteToHostException e) {
                    LOG.warn("Closing AudioConnection due to inability to ping audio packets.");
                    LOG.warn("Cannot send audio packet because JDA navigate the route to Discord.\nAre you sure you have internet connection? It is likely that you've lost connection.");
                    this.close(ConnectionStatus.ERROR_LOST_CONNECTION);
                }
                catch (IOException e) {
                    LOG.error("There was some error sending an audio keepalive packet", e);
                }
            }
        };
        try {
            this.keepAliveHandle = this.keepAlivePool.scheduleAtFixedRate(keepAliveRunnable, 0L, keepAliveInterval, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void changeStatus(ConnectionStatus newStatus) {
        this.connectionStatus = newStatus;
        this.listener.onStatusChange(newStatus);
    }

    private User getUser(long userId) {
        User user = this.api.getUserById(userId);
        if (user != null) {
            return user;
        }
        return this.api.getFakeUserMap().get(userId);
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setAutoReconnect(boolean shouldReconnect) {
        this.shouldReconnect = shouldReconnect;
    }

    protected void finalize() throws Throwable {
        if (!this.shutdown) {
            LOG.error("Finalization hook of AudioWebSocket was triggered without properly shutting down");
            this.close(ConnectionStatus.NOT_CONNECTED);
        }
    }

    public static class KeepAliveThreadFactory
    implements ThreadFactory {
        final String identifier;
        final AtomicInteger threadCount = new AtomicInteger(1);
        final ConcurrentMap<String, String> contextMap;

        public KeepAliveThreadFactory(JDAImpl api) {
            this.contextMap = api.getContextMap();
            this.identifier = api.getIdentifierString() + " Audio-KeepAlive Pool";
        }

        @Override
        public Thread newThread(Runnable r) {
            Runnable r2 = () -> {
                if (this.contextMap != null) {
                    MDC.setContextMap(this.contextMap);
                }
                r.run();
            };
            Thread t = new Thread(AudioManagerImpl.AUDIO_THREADS, r2, this.identifier + " - Thread " + this.threadCount.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

