/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.Group;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.VoiceChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.MemberImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.guild.member.GuildMemberLeaveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.guild.voice.GuildVoiceLeaveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.org.json.JSONObject;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if (guild == null) {
            return null;
        }
        long userId = content.getJSONObject("user").getLong("id");
        if (userId == this.api.getSelfUser().getIdLong()) {
            return null;
        }
        MemberImpl member = (MemberImpl)guild.getMembersMap().remove(userId);
        if (member == null) {
            WebSocketClient.LOG.debug("Received GUILD_MEMBER_REMOVE for a Member that does not exist in the specified Guild.");
            return null;
        }
        if (member.getVoiceState().inVoiceChannel()) {
            GuildVoiceStateImpl vState = (GuildVoiceStateImpl)member.getVoiceState();
            VoiceChannel channel = vState.getChannel();
            vState.setConnectedChannel(null);
            ((VoiceChannelImpl)channel).getConnectedMembersMap().remove(member.getUser().getIdLong());
            this.api.getEventManager().handle(new GuildVoiceLeaveEvent(this.api, this.responseNumber, member, channel));
        }
        if (userId != this.api.getSelfUser().getIdLong() && this.api.getGuildMap().valueCollection().stream().noneMatch(g -> ((GuildImpl)g).getMembersMap().containsKey(userId)) && (this.api.getAccountType() != AccountType.CLIENT || this.api.asClient().getFriendById(userId) == null)) {
            UserImpl user = (UserImpl)this.api.getUserMap().remove(userId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getIdLong(), user);
                this.api.getFakePrivateChannelMap().put(priv.getIdLong(), priv);
            } else if (this.api.getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.api.asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.api.getFakeUserMap().put(user.getIdLong(), user);
                    break;
                }
            }
            this.api.getEventCache().clear(EventCache.Type.USER, userId);
        }
        this.api.getEventManager().handle(new GuildMemberLeaveEvent(this.api, this.responseNumber, guild, member));
        return null;
    }
}

