/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.LinkedList;
import java.util.List;

public class GuildMembersChunkHandler
extends SocketHandler {
    private final TLongIntMap expectedGuildMembers = new TLongIntHashMap();
    private final TLongObjectMap<List<JSONArray>> memberChunksCache = new TLongObjectHashMap<List<JSONArray>>();

    public GuildMembersChunkHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        List<JSONArray> memberChunks = this.memberChunksCache.get(guildId);
        int expectMemberCount = this.expectedGuildMembers.get(guildId);
        JSONArray members = content.getJSONArray("members");
        JDAImpl.LOG.debug("GUILD_MEMBER_CHUNK for: {}\tMembers: {}", (Object)guildId, (Object)members.length());
        memberChunks.add(members);
        int currentTotal = 0;
        for (JSONArray arr : memberChunks) {
            currentTotal += arr.length();
        }
        if (currentTotal >= expectMemberCount) {
            JDAImpl.LOG.debug("Finished chunking for: {}", (Object)guildId);
            this.api.getEntityBuilder().createGuildSecondPass(guildId, memberChunks);
            this.memberChunksCache.remove(guildId);
            this.expectedGuildMembers.remove(guildId);
        }
        return null;
    }

    public void setExpectedGuildMembers(long guildId, int count) {
        if (this.expectedGuildMembers.containsKey(guildId)) {
            JDAImpl.LOG.warn("Set the count of expected users from GuildMembersChunk even though a value already exists! GuildId: {}", (Object)guildId);
        }
        this.expectedGuildMembers.put(guildId, count);
        if (this.memberChunksCache.containsKey(guildId)) {
            JDAImpl.LOG.warn("Set the memberChunks for MemberChunking for a guild that was already setup for chunking! GuildId: {}", (Object)guildId);
        }
        this.memberChunksCache.put(guildId, new LinkedList());
    }

    public void modifyExpectedGuildMember(long guildId, int changeAmount) {
        try {
            Integer i = this.expectedGuildMembers.get(guildId);
            i = i + changeAmount;
            this.expectedGuildMembers.put(guildId, i);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void clearCache() {
        this.expectedGuildMembers.clear();
        this.memberChunksCache.clear();
    }
}

