/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.core.entities.Member;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.MemberImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.role.RoleDeleteEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.org.json.JSONObject;

public class GuildRoleDeleteHandler
extends SocketHandler {
    public GuildRoleDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("GUILD_ROLE_DELETE was received for a Guild that is not yet cached: {}", (Object)content);
            return null;
        }
        long roleId = content.getLong("role_id");
        Role removedRole = guild.getRolesMap().remove(roleId);
        if (removedRole == null) {
            WebSocketClient.LOG.debug("GUILD_ROLE_DELETE was received for a Role that is not yet cached: {}", (Object)content);
            return null;
        }
        for (Member m : guild.getMembersMap().valueCollection()) {
            MemberImpl member = (MemberImpl)m;
            member.getRoleSet().remove(removedRole);
        }
        this.api.getEventManager().handle(new RoleDeleteEvent(this.api, this.responseNumber, removedRole));
        this.api.getEventCache().clear(EventCache.Type.ROLE, roleId);
        return null;
    }
}

