/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.GroupImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.events.message.group.GroupMessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Message;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.IEventManager;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.org.json.JSONObject;

public class MessageCreateHandler
extends SocketHandler {
    public MessageCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        Message message;
        MessageType type = MessageType.fromId(content.getInt("type"));
        if (type == MessageType.UNKNOWN) {
            WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: {}  JSON: {}", (Object)type, (Object)content);
            return null;
        }
        try {
            message = this.api.getEntityBuilder().createMessage(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getJSONObject("author").getLong("id");
                    this.api.getEventCache().cache(EventCache.Type.USER, authorId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("Received a message for a user that JDA does not currently have cached");
                    return null;
                }
            }
            throw e;
        }
        IEventManager manager = this.api.getEventManager();
        switch (message.getChannelType()) {
            case TEXT: {
                TextChannelImpl channel = (TextChannelImpl)message.getTextChannel();
                if (this.api.getGuildLock().isLocked(channel.getGuild().getIdLong())) {
                    return channel.getGuild().getIdLong();
                }
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new GuildMessageReceivedEvent((JDA)this.api, this.responseNumber, message));
                break;
            }
            case PRIVATE: {
                PrivateChannelImpl channel = (PrivateChannelImpl)message.getPrivateChannel();
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new PrivateMessageReceivedEvent(this.api, this.responseNumber, message));
                break;
            }
            case GROUP: {
                GroupImpl channel = (GroupImpl)message.getGroup();
                channel.setLastMessageId(message.getIdLong());
                manager.handle(new GroupMessageReceivedEvent((JDA)this.api, this.responseNumber, message));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a MESSAGE_CREATE with a unknown MessageChannel ChannelType. JSON: {}", (Object)content);
                return null;
            }
        }
        manager.handle(new MessageReceivedEvent(this.api, this.responseNumber, message));
        return null;
    }
}

