/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.FriendImpl;
import chikachi.discord.repack.net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.OnlineStatus;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Game;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.MemberImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.UserImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.user.UserAvatarUpdateEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.user.UserGameUpdateEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.user.UserNameUpdateEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.user.UserOnlineStatusUpdateEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.Objects;

public class PresenceUpdateHandler
extends SocketHandler {
    public PresenceUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        GuildImpl guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.api.getGuildLock().isLocked(guildId)) {
                return guildId;
            }
            guild = (GuildImpl)this.api.getGuildById(guildId);
            if (guild == null) {
                this.api.getEventCache().cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
                EventCache.LOG.debug("Received a PRESENCE_UPDATE for a guild that is not yet cached! GuildId: " + guildId + " UserId: " + content.getJSONObject("user").get("id"));
                return null;
            }
        }
        JSONObject jsonUser = content.getJSONObject("user");
        long userId = jsonUser.getLong("id");
        UserImpl user = (UserImpl)this.api.getUserMap().get(userId);
        if (user != null) {
            if (jsonUser.has("username")) {
                String oldAvatar;
                String name = jsonUser.getString("username");
                String discriminator = jsonUser.get("discriminator").toString();
                String avatarId = jsonUser.optString("avatar", null);
                if (!user.getName().equals(name) || !user.getDiscriminator().equals(discriminator)) {
                    String oldUsername = user.getName();
                    String oldDiscriminator = user.getDiscriminator();
                    user.setName(name);
                    user.setDiscriminator(discriminator);
                    this.api.getEventManager().handle(new UserNameUpdateEvent(this.api, this.responseNumber, user, oldUsername, oldDiscriminator));
                }
                if (!Objects.equals(avatarId, oldAvatar = user.getAvatarId())) {
                    String oldAvatarId = user.getAvatarId();
                    user.setAvatarId(avatarId);
                    this.api.getEventManager().handle(new UserAvatarUpdateEvent(this.api, this.responseNumber, user, oldAvatarId));
                }
            }
            JSONObject game = content.isNull("game") ? null : content.optJSONObject("game");
            Game nextGame = null;
            boolean parsedGame = false;
            try {
                nextGame = game == null ? null : EntityBuilder.createGame(game);
                parsedGame = true;
            }
            catch (Exception ex) {
                if (EntityBuilder.LOG.isDebugEnabled()) {
                    EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} JSON: {}", userId, game, ex);
                }
                EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
            }
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (guild != null) {
                MemberImpl member = (MemberImpl)guild.getMember(user);
                if (member == null) {
                    if (status != OnlineStatus.OFFLINE) {
                        guild.getCachedPresenceMap().put(userId, content);
                        return null;
                    }
                } else {
                    if (!member.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = member.getOnlineStatus();
                        member.setOnlineStatus(status);
                        this.api.getEventManager().handle(new UserOnlineStatusUpdateEvent(this.api, this.responseNumber, user, guild, oldStatus));
                    }
                    if (parsedGame && !Objects.equals(member.getGame(), nextGame)) {
                        Game oldGame = member.getGame();
                        member.setGame(nextGame);
                        this.api.getEventManager().handle(new UserGameUpdateEvent(this.api, this.responseNumber, user, guild, oldGame));
                    }
                }
            } else {
                if (this.api.getAccountType() != AccountType.CLIENT) {
                    return null;
                }
                JDAClientImpl client = this.api.asClient();
                FriendImpl friend = (FriendImpl)client.getFriendById(userId);
                if (friend != null) {
                    if (!friend.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = friend.getOnlineStatus();
                        friend.setOnlineStatus(status);
                        this.api.getEventManager().handle(new UserOnlineStatusUpdateEvent(this.api, this.responseNumber, user, null, oldStatus));
                    }
                    if (parsedGame && !Objects.equals(friend.getGame(), nextGame)) {
                        Game oldGame = friend.getGame();
                        friend.setGame(nextGame);
                        this.api.getEventManager().handle(new UserGameUpdateEvent(this.api, this.responseNumber, user, null, oldGame));
                    }
                }
            }
        } else {
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (status != OnlineStatus.OFFLINE && guild != null) {
                guild.getCachedPresenceMap().put(userId, content);
            }
        }
        return null;
    }
}

