/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.SelfUserImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateAvatarEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateEmailEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateMFAEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateMobileEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateNameEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateNitroEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdatePhoneNumberEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.self.SelfUpdateVerifiedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.Objects;

public class UserUpdateHandler
extends SocketHandler {
    public UserUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        SelfUserImpl self = (SelfUserImpl)this.api.getSelfUser();
        String name = content.getString("username");
        String discriminator = content.getString("discriminator");
        String avatarId = content.optString("avatar", null);
        Boolean verified = content.has("verified") ? Boolean.valueOf(content.getBoolean("verified")) : null;
        Boolean mfaEnabled = content.has("mfa_enabled") ? Boolean.valueOf(content.getBoolean("mfa_enabled")) : null;
        String email = content.optString("email", null);
        Boolean mobile = content.has("mobile") ? Boolean.valueOf(content.getBoolean("mobile")) : null;
        Boolean nitro = content.has("premium") ? Boolean.valueOf(content.getBoolean("premium")) : null;
        String phoneNumber = content.optString("phone", null);
        if (!Objects.equals(name, self.getName()) || !Objects.equals(discriminator, self.getDiscriminator())) {
            String oldName = self.getName();
            String oldDiscriminator = self.getDiscriminator();
            self.setName(name);
            self.setDiscriminator(discriminator);
            this.api.getEventManager().handle(new SelfUpdateNameEvent(this.api, this.responseNumber, oldName, oldDiscriminator));
        }
        if (!Objects.equals(avatarId, self.getAvatarId())) {
            String oldAvatarId = self.getAvatarId();
            self.setAvatarId(avatarId);
            this.api.getEventManager().handle(new SelfUpdateAvatarEvent(this.api, this.responseNumber, oldAvatarId));
        }
        if (verified != null && verified.booleanValue() != self.isVerified()) {
            boolean wasVerified = self.isVerified();
            self.setVerified(verified);
            this.api.getEventManager().handle(new SelfUpdateVerifiedEvent(this.api, this.responseNumber, wasVerified));
        }
        if (mfaEnabled != null && mfaEnabled.booleanValue() != self.isMfaEnabled()) {
            boolean wasMfaEnabled = self.isMfaEnabled();
            self.setMfaEnabled(mfaEnabled);
            this.api.getEventManager().handle(new SelfUpdateMFAEvent(this.api, this.responseNumber, wasMfaEnabled));
        }
        if (this.api.getAccountType() == AccountType.CLIENT) {
            if (!Objects.equals(email, self.getEmail())) {
                String oldEmail = self.getEmail();
                self.setEmail(email);
                this.api.getEventManager().handle(new SelfUpdateEmailEvent(this.api, this.responseNumber, oldEmail));
            }
            if (mobile != null && mobile.booleanValue() != self.isMobile()) {
                boolean oldMobile = self.isMobile();
                self.setMobile(mobile);
                this.api.getEventManager().handle(new SelfUpdateMobileEvent(this.api, this.responseNumber, oldMobile));
            }
            if (nitro != null && nitro.booleanValue() != self.isNitro()) {
                boolean oldNitro = self.isNitro();
                self.setNitro(nitro);
                this.api.getEventManager().handle(new SelfUpdateNitroEvent(this.api, this.responseNumber, oldNitro));
            }
            if (!Objects.equals(phoneNumber, self.getPhoneNumber())) {
                String oldPhoneNumber = self.getPhoneNumber();
                self.setPhoneNumber(phoneNumber);
                this.api.getEventManager().handle(new SelfUpdatePhoneNumberEvent(this.api, this.responseNumber, oldPhoneNumber));
            }
        }
        return null;
    }
}

