/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests.ratelimit;

import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.ExceptionEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RateLimiter;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Requester;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.ratelimit.IBucket;
import chikachi.discord.repack.org.json.JSONObject;
import chikachi.discord.repack.org.json.JSONTokener;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Response;

public class BotRateLimiter
extends RateLimiter {
    protected volatile Long timeOffset = null;

    public BotRateLimiter(Requester requester, int poolSize) {
        super(requester, poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRateLimit(Route.CompiledRoute route) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            return bucket.getRateLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueRequest(Request request) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(request.getRoute());
        synchronized (bucket2) {
            bucket.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleResponse(Route.CompiledRoute route, Response response) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            Headers headers = response.headers();
            int code = response.code();
            if (this.timeOffset == null) {
                this.setTimeOffset(headers);
            }
            if (code == 429) {
                String global = headers.get("X-RateLimit-Global");
                String retry = headers.get("Retry-After");
                if (retry == null || retry.isEmpty()) {
                    try (InputStream in = Requester.getBody(response);){
                        JSONObject limitObj = new JSONObject(new JSONTokener(in));
                        retry = limitObj.get("retry_after").toString();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                long retryAfter = Long.parseLong(retry);
                if (!Boolean.parseBoolean(global)) {
                    this.updateBucket(bucket, headers);
                } else {
                    this.requester.getJDA().getSessionController().setGlobalRatelimit(this.getNow() + retryAfter);
                }
                return retryAfter;
            }
            this.updateBucket(bucket, headers);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getBucket(Route.CompiledRoute route) {
        String rateLimitRoute = route.getRatelimitRoute();
        Bucket bucket = (Bucket)this.buckets.get(rateLimitRoute);
        if (bucket == null) {
            ConcurrentHashMap concurrentHashMap = this.buckets;
            synchronized (concurrentHashMap) {
                bucket = (Bucket)this.buckets.get(rateLimitRoute);
                if (bucket == null) {
                    bucket = new Bucket(rateLimitRoute, route.getBaseRoute().getRatelimit());
                    this.buckets.put(rateLimitRoute, bucket);
                }
            }
        }
        return bucket;
    }

    public long getNow() {
        return System.currentTimeMillis() + this.getTimeOffset();
    }

    public long getTimeOffset() {
        return this.timeOffset == null ? 0L : this.timeOffset;
    }

    private void setTimeOffset(Headers headers) {
        String date;
        long time = System.currentTimeMillis();
        if (this.timeOffset == null && (date = headers.get("Date")) != null) {
            OffsetDateTime tDate = OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
            long lDate = tDate.toInstant().toEpochMilli();
            this.timeOffset = lDate - time;
        }
    }

    private void updateBucket(Bucket bucket, Headers headers) {
        block4: {
            try {
                if (bucket.hasRatelimit()) {
                    bucket.resetTime = this.getNow() + (long)bucket.getRatelimit().getResetTime();
                } else {
                    bucket.resetTime = Long.parseLong(headers.get("X-RateLimit-Reset")) * 1000L;
                    bucket.routeUsageLimit = Integer.parseInt(headers.get("X-RateLimit-Limit"));
                }
                bucket.routeUsageRemaining = Integer.parseInt(headers.get("X-RateLimit-Remaining"));
            }
            catch (NumberFormatException ex) {
                if (bucket.getRoute().equals("gateway") || bucket.getRoute().equals("users/@me")) break block4;
                Requester.LOG.debug("Encountered issue with headers when updating a bucket\nRoute: {}\nHeaders: {}", (Object)bucket.getRoute(), (Object)headers);
            }
        }
    }

    private class Bucket
    implements IBucket,
    Runnable {
        final String route;
        final Route.RateLimit rateLimit;
        final ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();
        volatile long resetTime = 0L;
        volatile int routeUsageRemaining = 1;
        volatile int routeUsageLimit = 1;

        public Bucket(String route, Route.RateLimit rateLimit) {
            this.route = route;
            this.rateLimit = rateLimit;
            if (rateLimit != null) {
                this.routeUsageRemaining = rateLimit.getUsageLimit();
                this.routeUsageLimit = rateLimit.getUsageLimit();
            }
        }

        void addToQueue(Request request) {
            this.requests.add(request);
            this.submitForProcessing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitForProcessing() {
            ConcurrentLinkedQueue concurrentLinkedQueue = BotRateLimiter.this.submittedBuckets;
            synchronized (concurrentLinkedQueue) {
                if (!BotRateLimiter.this.submittedBuckets.contains(this)) {
                    Long delay = this.getRateLimit();
                    if (delay == null) {
                        delay = 0L;
                    }
                    BotRateLimiter.this.pool.schedule(this, (long)delay, TimeUnit.MILLISECONDS);
                    BotRateLimiter.this.submittedBuckets.add(this);
                }
            }
        }

        Long getRateLimit() {
            long gCooldown = BotRateLimiter.this.requester.getJDA().getSessionController().getGlobalRatelimit();
            if (gCooldown > 0L) {
                long now = BotRateLimiter.this.getNow();
                if (now > gCooldown) {
                    BotRateLimiter.this.requester.getJDA().getSessionController().setGlobalRatelimit(Long.MIN_VALUE);
                } else {
                    return gCooldown - now;
                }
            }
            if (this.routeUsageRemaining <= 0 && BotRateLimiter.this.getNow() > this.resetTime) {
                this.routeUsageRemaining = this.routeUsageLimit;
                this.resetTime = 0L;
            }
            if (this.routeUsageRemaining > 0) {
                return null;
            }
            return this.resetTime - BotRateLimiter.this.getNow();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket oBucket = (Bucket)o;
            return this.route.equals(oBucket.route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    ConcurrentLinkedQueue<Request> concurrentLinkedQueue = this.requests;
                    synchronized (concurrentLinkedQueue) {
                        Long limit;
                        Object it = this.requests.iterator();
                        while (it.hasNext() && ((limit = this.getRateLimit()) == null || limit <= 0L)) {
                            Request request = null;
                            try {
                                request = (Request)it.next();
                                if (BotRateLimiter.this.isSkipped((Iterator)it, request)) continue;
                                Long retryAfter = BotRateLimiter.this.requester.execute(request);
                                if (retryAfter != null) break;
                                it.remove();
                            }
                            catch (Throwable t) {
                                Requester.LOG.error("Requester system encountered an internal error", t);
                                it.remove();
                                if (request == null) continue;
                                request.onFailure(t);
                            }
                        }
                        it = BotRateLimiter.this.submittedBuckets;
                        synchronized (it) {
                            BotRateLimiter.this.submittedBuckets.remove(this);
                            if (!this.requests.isEmpty()) {
                                try {
                                    this.submitForProcessing();
                                }
                                catch (RejectedExecutionException e) {
                                    Requester.LOG.debug("Caught RejectedExecutionException when re-queuing a ratelimited request. The requester is probably shutdown, thus, this can be ignored.");
                                }
                            }
                        }
                    }
                }
                catch (Throwable err) {
                    Requester.LOG.error("Requester system encountered an internal error from beyond the synchronized execution blocks. NOT GOOD!", err);
                    if (!(err instanceof Error)) break block14;
                    JDAImpl api = BotRateLimiter.this.requester.getJDA();
                    api.getEventManager().handle(new ExceptionEvent(api, err, true));
                }
            }
        }

        @Override
        public Route.RateLimit getRatelimit() {
            return this.rateLimit;
        }

        @Override
        public String getRoute() {
            return this.route;
        }

        @Override
        public Queue<Request> getRequests() {
            return this.requests;
        }
    }
}

