/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction;

import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Category;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Channel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.IPermissionHolder;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Member;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.PermOverrideData;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import okhttp3.RequestBody;

public class ChannelAction
extends AuditableRestAction<Channel> {
    protected final Set<PermOverrideData> overrides = new HashSet<PermOverrideData>();
    protected final Guild guild;
    protected final ChannelType type;
    protected String name;
    protected Category parent;
    protected String topic = null;
    protected Boolean nsfw = null;
    protected Integer bitrate = null;
    protected Integer userlimit = null;

    public ChannelAction(Route.CompiledRoute route, String name, Guild guild, ChannelType type) {
        super(guild.getJDA(), route);
        this.guild = guild;
        this.type = type;
        this.name = name;
    }

    @Override
    public ChannelAction setCheck(BooleanSupplier checks) {
        return (ChannelAction)super.setCheck(checks);
    }

    @CheckReturnValue
    public ChannelAction setName(String name) {
        Checks.notNull(name, "Channel name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided channel name must be 2 to 100 characters in length");
        }
        this.name = name;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setParent(Category category) {
        Checks.check(category == null || category.getGuild().equals(this.guild), "Category is not from same guild!");
        this.parent = category;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setTopic(String topic) {
        if (this.type != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Can only set the topic for a TextChannel!");
        }
        if (topic != null && topic.length() > 1024) {
            throw new IllegalArgumentException("Channel Topic must not be greater than 1024 in length!");
        }
        this.topic = topic;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setNSFW(boolean nsfw) {
        if (this.type != ChannelType.TEXT) {
            throw new UnsupportedOperationException("Can only set nsfw for a TextChannel!");
        }
        this.nsfw = nsfw;
        return this;
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(IPermissionHolder target, Collection<Permission> allow, Collection<Permission> deny) {
        this.checkPermissions(allow);
        this.checkPermissions(deny);
        long allowRaw = allow != null ? Permission.getRaw(allow) : 0L;
        long denyRaw = deny != null ? Permission.getRaw(deny) : 0L;
        return this.addPermissionOverride(target, allowRaw, denyRaw);
    }

    @CheckReturnValue
    public ChannelAction addPermissionOverride(IPermissionHolder target, long allow, long deny) {
        Checks.notNull(target, "Override Role");
        Checks.notNegative(allow, "Granted permissions value");
        Checks.notNegative(deny, "Denied permissions value");
        Checks.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        Checks.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        Checks.check(target.getGuild().equals(this.guild), "Specified Role is not in the same Guild!");
        if (target instanceof Role) {
            Role r = (Role)target;
            long id = r.getIdLong();
            this.overrides.add(new PermOverrideData(0, id, allow, deny));
        } else {
            Member m = (Member)target;
            long id = m.getUser().getIdLong();
            this.overrides.add(new PermOverrideData(1, id, allow, deny));
        }
        return this;
    }

    @CheckReturnValue
    public ChannelAction setBitrate(Integer bitrate) {
        if (this.type != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Can only set the bitrate for a VoiceChannel!");
        }
        if (bitrate != null) {
            int maxBitrate;
            int n = maxBitrate = this.guild.getFeatures().contains("VIP_REGIONS") ? 128000 : 96000;
            if (bitrate < 8000) {
                throw new IllegalArgumentException("Bitrate must be greater than 8000.");
            }
            if (bitrate > maxBitrate) {
                throw new IllegalArgumentException("Bitrate must be less than " + maxBitrate);
            }
        }
        this.bitrate = bitrate;
        return this;
    }

    @CheckReturnValue
    public ChannelAction setUserlimit(Integer userlimit) {
        if (this.type != ChannelType.VOICE) {
            throw new UnsupportedOperationException("Can only set the userlimit for a VoiceChannel!");
        }
        if (userlimit != null && (userlimit < 0 || userlimit > 99)) {
            throw new IllegalArgumentException("Userlimit must be between 0-99!");
        }
        this.userlimit = userlimit;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        object.put("type", this.type.getId());
        object.put("permission_overwrites", new JSONArray(this.overrides));
        switch (this.type) {
            case VOICE: {
                if (this.bitrate != null) {
                    object.put("bitrate", this.bitrate);
                }
                if (this.userlimit == null) break;
                object.put("user_limit", this.userlimit);
                break;
            }
            case TEXT: {
                if (this.topic != null && !this.topic.isEmpty()) {
                    object.put("topic", this.topic);
                }
                if (this.nsfw == null) break;
                object.put("nsfw", this.nsfw);
            }
        }
        if (this.type != ChannelType.CATEGORY && this.parent != null) {
            object.put("parent_id", this.parent.getId());
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Channel> request) {
        Channel channel;
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        switch (this.type) {
            case VOICE: {
                channel = builder.createVoiceChannel(response.getObject(), this.guild.getIdLong());
                break;
            }
            case TEXT: {
                channel = builder.createTextChannel(response.getObject(), this.guild.getIdLong());
                break;
            }
            case CATEGORY: {
                channel = builder.createCategory(response.getObject(), this.guild.getIdLong());
                break;
            }
            default: {
                request.onFailure(new IllegalStateException("Created channel of unknown type!"));
                return;
            }
        }
        request.onSuccess(channel);
    }

    protected void checkPermissions(Permission ... permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Checks.notNull((Object)p, "Permissions");
        }
    }

    protected void checkPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Checks.notNull((Object)p, "Permissions");
        }
    }
}

