/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction;

import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.Region;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Icon;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.RestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.PermOverrideData;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import chikachi.discord.repack.org.json.JSONString;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import okhttp3.RequestBody;

public class GuildAction
extends RestAction<Void> {
    protected String name;
    protected Region region;
    protected Icon icon;
    protected Guild.VerificationLevel verificationLevel;
    protected Guild.NotificationLevel notificationLevel;
    protected Guild.ExplicitContentLevel explicitContentLevel;
    protected final List<RoleData> roles;
    protected final List<ChannelData> channels;

    public GuildAction(JDA api, String name) {
        super(api, Route.Guilds.CREATE_GUILD.compile(new String[0]));
        this.setName(name);
        this.roles = new LinkedList<RoleData>();
        this.channels = new LinkedList<ChannelData>();
        this.roles.add(new RoleData(0L));
    }

    public GuildAction setCheck(BooleanSupplier checks) {
        return (GuildAction)super.setCheck(checks);
    }

    @CheckReturnValue
    public GuildAction setRegion(Region region) {
        Checks.check(region == null || !region.isVip(), "Cannot create a Guild with a VIP voice region!");
        this.region = region;
        return this;
    }

    @CheckReturnValue
    public GuildAction setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    @CheckReturnValue
    public GuildAction setName(String name) {
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() >= 2 && name.length() <= 100, "Name must have 2-100 characters in length!");
        this.name = name;
        return this;
    }

    @CheckReturnValue
    public GuildAction setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        return this;
    }

    @CheckReturnValue
    public GuildAction setNotificationLevel(Guild.NotificationLevel level) {
        this.notificationLevel = level;
        return this;
    }

    @CheckReturnValue
    public GuildAction setExplicitContentLevel(Guild.ExplicitContentLevel level) {
        this.explicitContentLevel = level;
        return this;
    }

    @CheckReturnValue
    public GuildAction addChannel(ChannelData channel) {
        Checks.notNull(channel, "Channel");
        this.channels.add(channel);
        return this;
    }

    @CheckReturnValue
    public ChannelData getChannel(int index) {
        return this.channels.get(index);
    }

    @CheckReturnValue
    public ChannelData removeChannel(int index) {
        return this.channels.remove(index);
    }

    @CheckReturnValue
    public GuildAction removeChannel(ChannelData data) {
        this.channels.remove(data);
        return this;
    }

    @CheckReturnValue
    public ChannelData newChannel(ChannelType type, String name) {
        ChannelData data = new ChannelData(type, name);
        this.addChannel(data);
        return data;
    }

    @CheckReturnValue
    public RoleData getPublicRole() {
        return this.roles.get(0);
    }

    @CheckReturnValue
    public RoleData getRole(int index) {
        return this.roles.get(index);
    }

    @CheckReturnValue
    public RoleData newRole() {
        RoleData role = new RoleData(this.roles.size());
        this.roles.add(role);
        return role;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        object.put("roles", new JSONArray(this.roles));
        if (!this.channels.isEmpty()) {
            object.put("channels", new JSONArray(this.channels));
        }
        if (this.icon != null) {
            object.put("icon", this.icon.getEncoding());
        }
        if (this.verificationLevel != null) {
            object.put("verification_level", this.verificationLevel.getKey());
        }
        if (this.notificationLevel != null) {
            object.put("default_message_notifications", this.notificationLevel.getKey());
        }
        if (this.explicitContentLevel != null) {
            object.put("explicit_content_filter", this.explicitContentLevel.getKey());
        }
        if (this.region != null) {
            object.put("region", this.region.getKey());
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Void> request) {
        if (response.isOk()) {
            request.onSuccess(null);
        } else {
            request.onFailure(response);
        }
    }

    public static class ChannelData
    implements JSONString {
        protected final ChannelType type;
        protected final String name;
        protected final Set<PermOverrideData> overrides = new HashSet<PermOverrideData>();
        protected Integer position;
        protected String topic;
        protected Boolean nsfw;
        protected Integer bitrate;
        protected Integer userlimit;

        public ChannelData(ChannelType type, String name) {
            Checks.notBlank(name, "Name");
            Checks.check(type == ChannelType.TEXT || type == ChannelType.VOICE, "Can only create channels of type TEXT or VOICE in GuildAction!");
            Checks.check(name.length() >= 2 && name.length() <= 100, "Channel name has to be between 2-100 characters long!");
            Checks.check(type == ChannelType.VOICE || name.matches("[a-zA-Z0-9-_]+"), "Channels of type TEXT must have a name in alphanumeric with underscores!");
            this.type = type;
            this.name = name;
        }

        public ChannelData setTopic(String topic) {
            if (topic != null && topic.length() > 1024) {
                throw new IllegalArgumentException("Channel Topic must not be greater than 1024 in length!");
            }
            this.topic = topic;
            return this;
        }

        public ChannelData setNSFW(Boolean nsfw) {
            this.nsfw = nsfw;
            return this;
        }

        public ChannelData setBitrate(Integer bitrate) {
            if (bitrate != null) {
                Checks.check(bitrate >= 8000, "Bitrate must be greater than 8000.");
                Checks.check(bitrate <= 96000, "Bitrate must be less than 96000.");
            }
            this.bitrate = bitrate;
            return this;
        }

        public ChannelData setUserlimit(Integer userlimit) {
            if (userlimit != null && (userlimit < 0 || userlimit > 99)) {
                throw new IllegalArgumentException("Userlimit must be between 0-99!");
            }
            this.userlimit = userlimit;
            return this;
        }

        public ChannelData setPosition(Integer position) {
            this.position = position;
            return this;
        }

        public ChannelData addPermissionOverride(RoleData role, long allow, long deny) {
            Checks.notNull(role, "Role");
            Checks.notNegative(allow, "Granted permissions value");
            Checks.notNegative(deny, "Denied permissions value");
            Checks.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
            Checks.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
            this.overrides.add(new PermOverrideData(0, role.id, allow, deny));
            return this;
        }

        public ChannelData addPermissionOverride(RoleData role, @Nullable Collection<Permission> allow, @Nullable Collection<Permission> deny) {
            long allowRaw = 0L;
            long denyRaw = 0L;
            if (allow != null) {
                Checks.noneNull(allow, "Granted Permissions");
                allowRaw = Permission.getRaw(allow);
            }
            if (deny != null) {
                Checks.noneNull(deny, "Denied Permissions");
                denyRaw = Permission.getRaw(deny);
            }
            return this.addPermissionOverride(role, allowRaw, denyRaw);
        }

        @Override
        public String toJSONString() {
            JSONObject o = new JSONObject();
            o.put("name", this.name);
            o.put("type", this.type.getId());
            if (this.topic != null) {
                o.put("topic", this.topic);
            }
            if (this.nsfw != null) {
                o.put("nsfw", this.nsfw);
            }
            if (this.bitrate != null) {
                o.put("bitrate", this.bitrate);
            }
            if (this.userlimit != null) {
                o.put("user_limit", this.userlimit);
            }
            if (this.position != null) {
                o.put("position", this.position);
            }
            if (!this.overrides.isEmpty()) {
                o.put("permission_overwrites", this.overrides);
            }
            return o.toString();
        }
    }

    public static class RoleData
    implements JSONString {
        protected final long id;
        protected final boolean isPublicRole;
        protected Long permissions;
        protected String name;
        protected Integer color;
        protected Integer position;
        protected Boolean mentionable;
        protected Boolean hoisted;

        protected RoleData(long id) {
            this.id = id;
            this.isPublicRole = id == 0L;
        }

        public RoleData setPermissionsRaw(Long rawPermissions) {
            if (rawPermissions != null) {
                Checks.notNegative(rawPermissions, "Raw Permissions");
                Checks.check(rawPermissions <= Permission.ALL_PERMISSIONS, "Provided permissions may not be greater than a full permission set!");
            }
            this.permissions = rawPermissions;
            return this;
        }

        public RoleData addPermissions(Permission ... permissions) {
            Checks.notNull(permissions, "Permissions");
            for (Permission perm : permissions) {
                Checks.notNull((Object)perm, "Permissions");
            }
            if (this.permissions == null) {
                this.permissions = 0L;
            }
            this.permissions = this.permissions | Permission.getRaw(permissions);
            return this;
        }

        public RoleData addPermissions(Collection<Permission> permissions) {
            Checks.noneNull(permissions, "Permissions");
            if (this.permissions == null) {
                this.permissions = 0L;
            }
            this.permissions = this.permissions | Permission.getRaw(permissions);
            return this;
        }

        public RoleData setName(String name) {
            this.checkPublic("name");
            this.name = name;
            return this;
        }

        public RoleData setColor(Color color) {
            this.checkPublic("color");
            this.color = color == null ? null : Integer.valueOf(color.getRGB());
            return this;
        }

        public RoleData setPosition(Integer position) {
            this.checkPublic("position");
            this.position = position;
            return this;
        }

        public RoleData setMentionable(Boolean mentionable) {
            this.checkPublic("mentionable");
            this.mentionable = mentionable;
            return this;
        }

        public RoleData setHoisted(Boolean hoisted) {
            this.checkPublic("hoisted");
            this.hoisted = hoisted;
            return this;
        }

        @Override
        public String toJSONString() {
            JSONObject o = new JSONObject().put("id", Long.toUnsignedString(this.id));
            if (this.permissions != null) {
                o.put("permissions", this.permissions);
            }
            if (this.position != null) {
                o.put("position", this.position);
            }
            if (this.name != null) {
                o.put("name", this.name);
            }
            if (this.color != null) {
                o.put("color", (int)(this.color & 0xFFFFFF));
            }
            if (this.mentionable != null) {
                o.put("mentionable", this.mentionable);
            }
            if (this.hoisted != null) {
                o.put("hoist", this.hoisted);
            }
            return o.toString();
        }

        protected void checkPublic(String comment) {
            if (this.isPublicRole) {
                throw new IllegalStateException("Cannot modify " + comment + " for the public role!");
            }
        }
    }
}

