/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.order;

import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Member;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.order.OrderAction;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.RequestBody;

public class RoleOrderAction
extends OrderAction<Role, RoleOrderAction> {
    protected final Guild guild;

    public RoleOrderAction(Guild guild, boolean useDiscordOrder) {
        super(guild.getJDA(), !useDiscordOrder, Route.Guilds.MODIFY_ROLES.compile(guild.getId()));
        this.guild = guild;
        List<Role> roles = guild.getRoles();
        roles = roles.subList(0, roles.size() - 1);
        if (useDiscordOrder) {
            for (int i = roles.size() - 1; i >= 0; --i) {
                this.orderList.add(roles.get(i));
            }
        } else {
            this.orderList.addAll(roles);
        }
    }

    public Guild getGuild() {
        return this.guild;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        boolean isOwner = self.isOwner();
        if (!isOwner) {
            if (self.getRoles().isEmpty()) {
                throw new IllegalStateException("Cannot move roles above your highest role unless you are the guild owner");
            }
            if (!self.hasPermission(Permission.MANAGE_ROLES)) {
                throw new InsufficientPermissionException(Permission.MANAGE_ROLES);
            }
        }
        JSONArray array = new JSONArray();
        ArrayList ordering = new ArrayList(this.orderList);
        if (this.ascendingOrder) {
            Collections.reverse(ordering);
        }
        for (int i = 0; i < ordering.size(); ++i) {
            Role role = (Role)ordering.get(i);
            int initialPos = role.getPosition();
            if (initialPos != i && !isOwner && !self.canInteract(role)) {
                throw new IllegalStateException("Cannot change order: One of the roles could not be moved due to hierarchical power!");
            }
            array.put(new JSONObject().put("id", role.getId()).put("position", i + 1));
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(Role entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided selected role is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided role is not in the list of orderable roles!");
    }
}

