/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.client;

import fathertoast.naturalabsorption.NaturalAbsorptionMod;
import fathertoast.naturalabsorption.client.ClientProxy;
import fathertoast.naturalabsorption.config.Config;
import fathertoast.naturalabsorption.health.HealthManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderEventHandler {
    private Random rand = new Random();
    private long healthUpdateCounter;
    private int playerHealth;
    private int lastPlayerHealth;
    private long lastSystemTime;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void beforeRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (Config.get().ABSORPTION_HEALTH.ENABLED) {
            if (Config.get().ARMOR.REPLACE_ARMOR && Config.get().ARMOR.HIDE_ARMOR_BAR && event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
                event.setCanceled(true);
            } else if (Config.get().ABSORPTION_HEALTH.RENDER_CAPACITY_BACKGROUND && event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
                try {
                    this.renderAbsorptionCapacity(event);
                }
                catch (Exception ex) {
                    NaturalAbsorptionMod.log().error("Encountered exception during render tick", (Throwable)ex);
                    event.setCanceled(false);
                }
            }
        }
    }

    private void renderAbsorptionCapacity(RenderGameOverlayEvent.Pre event) {
        boolean highlight;
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GlStateManager.func_179147_l();
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
        if (player == null || ClientProxy.clientAbsorptionCapacity <= 0.0f) {
            return;
        }
        int updateCounter = Minecraft.func_71410_x().field_71456_v.func_73834_c();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        float absorbMax = Math.min(ClientProxy.clientAbsorptionCapacity + HealthManager.getArmorAbsorption(player), Config.get().ABSORPTION_HEALTH.GLOBAL_MAXIMUM) + HealthManager.getPotionAbsorption(player);
        int extraHearts = MathHelper.func_76123_f((float)((healthMax + absorbMax) / 2.0f)) - MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f));
        if (extraHearts <= 0) {
            return;
        }
        event.setCanceled(true);
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorbMax) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = updateCounter % 25;
        }
        int TOP = 9 * (Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorbMax) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            int halfHeartHealth = i * 2 + 1;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (halfHeartHealth < healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (halfHeartHealth == healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (extraHearts > 0) {
                --extraHearts;
                continue;
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (halfHeartHealth < health) {
                this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (halfHeartHealth != health) continue;
            this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9);
        }
        GlStateManager.func_179084_k();
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float zLevel = -90.0f;
        float res = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), -90.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), -90.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, -90.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, -90.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

