/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.config;

import fathertoast.naturalabsorption.ModObjects;
import fathertoast.naturalabsorption.config.EntityListConfig;
import fathertoast.naturalabsorption.config.EntryEntity;
import fathertoast.naturalabsorption.config.EnvironmentListConfig;
import fathertoast.naturalabsorption.config.TargetBlock;
import fathertoast.naturalabsorption.config.TargetEnvironment;
import fathertoast.naturalabsorption.health.HealthManager;
import fathertoast.naturalabsorption.item.RecipeStyle;
import java.io.File;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class Config {
    public final GENERAL GENERAL = new GENERAL();
    public final ABSORPTION_HEALTH ABSORPTION_HEALTH = new ABSORPTION_HEALTH();
    public final ABSORPTION_UPGRADES ABSORPTION_UPGRADES = new ABSORPTION_UPGRADES();
    public final ARMOR ARMOR = new ARMOR();
    public final ENCHANTMENT ENCHANTMENT = new ENCHANTMENT();
    public final NORMAL_HEALTH NORMAL_HEALTH = new NORMAL_HEALTH();
    static Logger log;
    private static Configuration configLoading;
    private static Config INSTANCE;

    public static Config get() {
        return INSTANCE;
    }

    public static void load(Logger logger, String fileName, File configDir) {
        log = logger;
        log.info("Loading configs...");
        long startTime = System.nanoTime();
        configLoading = new Configuration(new File(configDir, fileName + ".cfg"));
        configLoading.load();
        INSTANCE = new Config();
        configLoading.save();
        configLoading = null;
        long estimatedTime = System.nanoTime() - startTime;
        log.info("Loaded configs in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private Config() {
    }

    private static abstract class PropertyCategory {
        static final double[] R_DBL_ALL = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_POS = new double[]{0.0, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_ONE = new double[]{0.0, 1.0};
        static final float[] R_FLT_ALL = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_POS = new float[]{0.0f, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_ONE = new float[]{0.0f, 1.0f};
        static final int[] R_INT_ALL = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        static final int[] R_INT_TOKEN_NEG = new int[]{-1, Integer.MAX_VALUE};
        static final int[] R_INT_POS0 = new int[]{0, Integer.MAX_VALUE};
        static final int[] R_INT_POS1 = new int[]{1, Integer.MAX_VALUE};
        static final int[] R_INT_SRT_POS = new int[]{0, Short.MAX_VALUE};
        static final int[] R_INT_BYT_UNS = new int[]{0, 255};
        static final int[] R_INT_BYT_POS = new int[]{0, 127};
        final String KEY;

        PropertyCategory(String key) {
            this.KEY = key;
            configLoading.addCustomCategoryComment(this.name(), this.comment());
        }

        PropertyCategory() {
            this(null);
        }

        abstract String name();

        abstract String comment();

        double[] defaultDblRange() {
            return R_DBL_POS;
        }

        float[] defaultFltRange() {
            return R_FLT_POS;
        }

        int[] defaultIntRange() {
            return R_INT_POS0;
        }

        <T extends Enum<T>> T prop(String key, T defaultValue, String comment) {
            Enum[] enumValues;
            String name = this.cprop(key, defaultValue, comment).getString();
            for (Enum value : enumValues = (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return (T)value;
            }
            log.error("Invalid enum value '{}' in config (category:{}, option:{}) - falling back to default value '{}'", (Object)name, (Object)this.name(), (Object)key, (Object)defaultValue.name().toLowerCase());
            return defaultValue;
        }

        <T extends Enum<T>> Property cprop(String key, T defaultValue, String comment) {
            Enum[] enumValues = (Enum[])defaultValue.getClass().getEnumConstants();
            String defaultId = defaultValue.name().toLowerCase();
            Object[] validValues = new String[enumValues.length];
            for (int i = 0; i < validValues.length; ++i) {
                validValues[i] = enumValues[i].name().toLowerCase();
            }
            comment = this.amendComment(comment, "Enum", (Object)defaultId, validValues);
            return configLoading.get(this.name(), key, defaultId, comment);
        }

        IBlockState prop(String key, IBlockState defaultValue, String comment) {
            String target = this.cprop(key, defaultValue, comment).getString();
            String[] pair = target.split(" ", 2);
            IBlockState block = TargetBlock.getStringAsBlock(pair[0]);
            if (pair.length > 1) {
                return block.func_177230_c().func_176203_a(Integer.parseInt(pair[1].trim()));
            }
            return block;
        }

        Property cprop(String key, IBlockState defaultValue, String comment) {
            String defaultId = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultValue.func_177230_c())).toString() + " " + defaultValue.func_177230_c().func_176201_c(defaultValue);
            comment = this.amendComment(comment, "Block", (Object)defaultId, "mod_id:block_id, mod_id:block_id meta");
            return configLoading.get(this.name(), key, defaultId, comment);
        }

        HashSet<TargetBlock> prop(String key, Block[] defaultValues, String comment) {
            TargetBlock[] wrappedDefaultValues = new TargetBlock[defaultValues.length];
            for (int i = 0; i < wrappedDefaultValues.length; ++i) {
                wrappedDefaultValues[i] = new TargetBlock(defaultValues[i]);
            }
            return this.prop(key, wrappedDefaultValues, comment);
        }

        HashSet<TargetBlock> prop(String key, TargetBlock[] defaultValues, String comment) {
            return TargetBlock.newBlockSet(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetBlock[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultValues[i].BLOCK)).toString();
                if (defaultValues[i].BLOCK_DATA < 0) continue;
                defaultIds[i] = (String)defaultIds[i] + " " + defaultValues[i].BLOCK_DATA;
            }
            comment = this.amendComment(comment, "Block_Array", defaultIds, "mod_id:block_id, mod_id:block_id meta, mod_id:*");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EntityListConfig prop(String key, EntryEntity[] defaultValues, String comment) {
            return new EntityListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, EntryEntity[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Entity_Array", defaultIds, "entity_id <extra_data>, ~entity_id <extra_data>");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EnvironmentListConfig prop(String key, TargetEnvironment[] defaultValues, String comment) {
            return new EnvironmentListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetEnvironment[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Environment_Array", defaultIds, "biome/mod_id:biome_id=value, biome/mod_id:prefix*=value, dimension/dimension_id=value");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        boolean prop(String key, boolean defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getBoolean();
        }

        Property cprop(String key, boolean defaultValue, String comment) {
            comment = this.amendComment(comment, "Boolean", (Object)defaultValue, new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValue, comment);
        }

        boolean[] prop(String key, boolean[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getBooleanList();
        }

        Property cprop(String key, boolean[] defaultValues, String comment) {
            comment = this.amendComment(comment, "Boolean_Array", (Object[])ArrayUtils.toObject((boolean[])defaultValues), new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValues, comment);
        }

        int prop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getInt();
        }

        int prop(String key, int defaultValue, String comment, int ... range) {
            return this.cprop(key, defaultValue, comment, range).getInt();
        }

        Property cprop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultIntRange());
        }

        Property cprop(String key, int defaultValue, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        int[] prop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getIntList();
        }

        int[] prop(String key, int[] defaultValues, String comment, int ... range) {
            return this.cprop(key, defaultValues, comment, range).getIntList();
        }

        Property cprop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultIntRange());
        }

        Property cprop(String key, int[] defaultValues, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer_Array", ArrayUtils.toObject((int[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        float prop(String key, float defaultValue, String comment) {
            return (float)this.cprop(key, defaultValue, comment).getDouble();
        }

        float prop(String key, float defaultValue, String comment, float ... range) {
            return (float)this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, float defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultFltRange());
        }

        Property cprop(String key, float defaultValue, String comment, float ... range) {
            comment = this.amendComment(comment, "Float", Float.valueOf(defaultValue), (Object)Float.valueOf(range[0]), (Object)Float.valueOf(range[1]));
            return configLoading.get(this.name(), key, this.prettyFloatToDouble(defaultValue), comment, this.prettyFloatToDouble(range[0]), this.prettyFloatToDouble(range[1]));
        }

        double prop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getDouble();
        }

        double prop(String key, double defaultValue, String comment, double ... range) {
            return this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultDblRange());
        }

        Property cprop(String key, double defaultValue, String comment, double ... range) {
            comment = this.amendComment(comment, "Double", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        double[] prop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getDoubleList();
        }

        double[] prop(String key, double[] defaultValues, String comment, double ... range) {
            return this.cprop(key, defaultValues, comment, range).getDoubleList();
        }

        Property cprop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultDblRange());
        }

        Property cprop(String key, double[] defaultValues, String comment, double ... range) {
            comment = this.amendComment(comment, "Double_Array", ArrayUtils.toObject((double[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        String prop(String key, String defaultValue, String comment, String valueDescription) {
            return this.cprop(key, defaultValue, comment, valueDescription).getString();
        }

        String prop(String key, String defaultValue, String comment, String ... validValues) {
            return this.cprop(key, defaultValue, comment, validValues).getString();
        }

        Property cprop(String key, String defaultValue, String comment, String valueDescription) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, valueDescription);
            return configLoading.get(this.name(), key, defaultValue, comment, new String[0]);
        }

        Property cprop(String key, String defaultValue, String comment, String ... validValues) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, (Object[])validValues);
            return configLoading.get(this.name(), key, defaultValue, comment, validValues);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, String description) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), description);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object min, Object max) {
            return this.amendComment(comment, type, "{ " + this.toReadable(defaultValues) + " }", min, max);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object[] validValues) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), validValues);
        }

        private String amendComment(String comment, String type, Object defaultValue, String description) {
            return comment + "\n   >> " + type + ":[ Value={ " + description + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object min, Object max) {
            return comment + "\n   >> " + type + ":[ Range={ " + min + ", " + max + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object[] validValues) {
            if (validValues.length < 2) {
                throw new IllegalArgumentException("Attempted to create config with no options!");
            }
            return comment + "\n   >> " + type + ":[ Valid_Values={ " + this.toReadable(validValues) + " }, Default=" + defaultValue + " ]";
        }

        private double prettyFloatToDouble(float f) {
            return Double.parseDouble(Float.toString(f));
        }

        private String toReadable(Object[] array) {
            if (array.length <= 0) {
                return "";
            }
            StringBuilder commentBuilder = new StringBuilder();
            for (Object value : array) {
                commentBuilder.append(value).append(", ");
            }
            return commentBuilder.substring(0, commentBuilder.length() - 2);
        }
    }

    public class NORMAL_HEALTH
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "Set this to false to disable all features from this mod related to normal health.\nThat is, every feature in this specific category. You will need to reset the regen game rule manually.");
        public final boolean DISABLE_GAMERULE_REGEN = this.prop("disable_gamerule_regen", true, "When set to true, this mod will constantly set the vanilla regeneration game rule \"naturalRegeneration\" to \"false\"\nto disable other sources of normal health regeneration.");
        public final float FOOD_HEALING = this.prop("food_healing", 0.25f, "The amount of normal health recovered for each point of hunger granted by eaten food.\nSet this to 0 to disable healing from eating.");
        public final float HUNGER_COST = this.prop("hunger_cost", 1.0f, "The amount of hunger or saturation drained for each point of normal health regenerated.\nPlayers can't lose more than 10 points of hunger or saturation at a time in this way.") * 4.0f;
        public final int HUNGER_REQUIRED = this.prop("hunger_required", 6, "Players need to have at least this much hunger to regenerate normal health.");
        public final float MAXIMUM = this.prop("max_regen", 6.0f, "The maximum that normal health that can be restored to by this mod's regeneration.");
        public final int RECOVER_DELAY = this.prop("recover_delay", 20, "The amount of time (in ticks) a player must go without taking damage before their normal health\nbegins to recover. If this is set less than 0, the normal health recovery from this mod is disabled.\nThis ignores the regeneration game rule.\n(20 ticks = 1 second)", R_INT_TOKEN_NEG);
        public final float RECOVER_RATE = this.prop("recover_rate", 0.25f, "The amount of normal health regenerated each second while recovering.") / 20.0f;
        public final float RECOVERY_ON_RESPAWN = this.prop("recovery_on_respawn", 6.0f, "Players will respawn with up to this much health, limited by their personal max health.\nSet this to 0 to leave respawn health unchanged.");

        @Override
        String name() {
            return "normal_health";
        }

        @Override
        String comment() {
            return "Options relating to normal health (red hearts).\nAll normal health amounts are in half-hearts, hunger amounts are in half-shanks.";
        }
    }

    public class ENCHANTMENT
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "Set this to false to disable the Absorption enchantment entirely.");
        public final boolean BOOKS = this.prop("books", true, "If false, the Absorption enchantment will not be allowed on books.");
        public final int ENCHANTIBILITY_BASE = this.prop("enchantibility_base", 3, "Base enchantibility required.\nDon't mess with this unless you are very familiar with enchanting mechanics.");
        public final int ENCHANTIBILITY_PER_LEVEL = this.prop("enchantibility_per_level", 6, "Enchantibility required per enchantment level.\nDon't mess with this unless you are very familiar with enchanting mechanics.");
        public final int MAXIMUM_LEVEL = this.prop("level_max", 4, "Maximum level for the Absorption enchantment.\nWithout messing with enchantibility, it is recommended you only alter this to +/- 1 default max level.");
        public final float POTENCY = this.prop("potency", 2.0f, "Max absorption gained for each rank of the Absorption enchantment.");
        public final float POTENCY_BASE = this.prop("potency_base", 2.0f, "Max absorption gained for for having at least one rank of the Absorption enchantment.\nA negative value reduces the effect of the first rank(s).", PropertyCategory.R_FLT_ALL);
        public final float POTENCY_MAX = this.prop("potency_max", 20.0f, "The limit on max absorbtion that can be gained from Absorption enchantments on a single player.");
        public final ModObjects.EnchantRarity RARITY = this.prop("rarity", ModObjects.EnchantRarity.RARE, "The rarity of the Absorption enchantment. Relates to how often it is selected when enchanting a valid item.");
        public final ModObjects.EnchantArmorType SLOT = this.prop("slot", ModObjects.EnchantArmorType.ALL, "The slot the Absorption enchantment is normally applicable to. Will still work on any armor piece\nif force-applied (e.g., creative mode anvil).");
        public final boolean STACKING = this.prop("stacking", true, "If false, only the highest level Absorption enchantment will be counted. Otherwise, all equipped\nAbsorption enchantments are added together (like vanilla Protection enchants).");
        public final boolean TREASURE = this.prop("treasure_only", false, "If true, the Absorption enchantment will not be generated by enchanting tables.");

        @Override
        String name() {
            return "enchantment";
        }

        @Override
        String comment() {
            return "Options related to the 'Absorption' armor enchantment.";
        }
    }

    public class ARMOR
    extends PropertyCategory {
        public final boolean REPLACE_ARMOR = this.prop("_armor_replacement", false, "If true, player armor will provide max absorption instead of damage reduction.\nThis option must be set to 'true' for the majority of this config section to function.");
        public final float ARMOR_MULT = this.prop("armor_multiplier", 1.0f, "The amount of max absorption that armor grants per armor point.\nNo effect if armor replacement AND armor multiplier override are disabled.");
        public final float ARMOR_TOUGHNESS_RECOVERY = this.prop("armor_toughness_recovery", 0.07f, "The increase in absorption recovery rate for each point of armor toughness.\nFor reference, the maximum attainable toughness in vanilla is 8 (full diamond armor).\nNo effect if armor replacement is disabled.");
        public final boolean ARMOR_MULT_OVERRIDE = this.prop("armor_multiplier_override", false, "Enable this option to grant the player absorption based on their armor points without disabling\narmor's damage reduction. Enables ONLY the armor multiplier option in this section.");
        public final boolean DURABILITY_FRIENDLY = this.prop("durability_friendly", true, "If true, armor will only take durability damage based on damage dealt to your absorption.\nNo effect if armor replacement is disabled.");
        public final float DURABILITY_MULT = this.prop("durability_multiplier", 2.0f, "The multiplier applied to armor durability damage.\nNo effect if armor replacement is disabled.");
        public final float DURABILITY_THRESHOLD = this.prop("durability_threshold", 1.0f, "Damage dealt to health must bypass this threshold value to cause durability damage.\nNo effect if armor replacement is disabled.");
        public final HealthManager.EnumDurabilityTrigger DURABILITY_TRIGGER = this.prop("durability_trigger", HealthManager.EnumDurabilityTrigger.ALL, "Decide which damage sources can inflict durability damage.\nNo effect if armor replacement is disabled.\n  all   - all damage except thorns\n  hits  - all damage except thorns and damage-over-time (poison, burning, etc.)\n  none  - no damage hurts armor");
        public final boolean HIDE_ARMOR_BAR = this.prop("hide_armor_bar", true, "If true, the (now much less useful) armor bar will not be rendered.\nNo effect if armor replacement is disabled.");

        @Override
        String name() {
            return "armor";
        }

        @Override
        String comment() {
            return "Options related to the replacement of armor with absorption health.\nThis part of the mod is disabled by default; enable armor replacement to activate it.";
        }
    }

    public class ABSORPTION_UPGRADES
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_upgrades_enabled", true, "Set this to false to prevent players from upgrading their absorption health.\nAlso disables the Book of Absorption and its recipe.");
        public final float CAPACITY_GAIN = this.prop("capacity_gain", 2.0f, "The amount of maximum natural absorption gained from each upgrade.");
        public final float LEVEL_COST = this.prop("level_cost", -5.0f, "The base number of levels required to use a Book of Absorption.\nThe final level cost is rounded down to the nearest whole number and clamped between 0 and \"level_cost_limit\".", R_FLT_ALL);
        public final int LEVEL_COST_MAX = this.prop("level_cost_limit", 30, "The maximum number of levels that will be required to use a Book of Absorption.");
        public final float LEVEL_COST_PER_POINT = this.prop("level_cost_per_point", 2.5f, "The number of levels required to use a Book of Absorption for each point of maximum absorption\nhealth the player already has.\nThe final level cost is rounded down to the nearest whole number and clamped between 0 and \"level_cost_limit\".", R_FLT_ALL);
        public final float MAXIMUM = this.prop("max_absorption", 20.0f, "The maximum natural absorption a player may obtain from upgrades.\nDoes not include max absorption gained from potions or equipment.", 0.0f, Float.MAX_VALUE);
        public final RecipeStyle.Type RECIPE = this.prop("recipe", RecipeStyle.Type.CROSS, "The recipe for making a Book of Absorption.\n  none     - <no recipe>\n  simple   - aB  (book + apple, shapeless)\n  sandwich - aBa (book + 2 apples)\n  cross    -  a  (book + 4 apples)\n             aBa \n              a  \n  surround - aaa (book + 8 apples)\n             aBa \n             aaa \nB = book & quill, a = golden apple");
        public final boolean SHOW_INFO_IN_TOOLTIP = this.prop("show_info_in_tooltip", false, "Set to true to display current and max natural absorption on the Book of Absorption tooltip.\nParticularly helpful if you must disable the heart background rendering.");

        @Override
        String name() {
            return "absorption_upgrades";
        }

        @Override
        String comment() {
            return "Options relating to increasing maximum absorption health (yellow hearts).\nAll absorption amounts are in half-hearts.";
        }
    }

    public class ABSORPTION_HEALTH
    extends PropertyCategory {
        public final boolean ENABLED = this.prop("_enabled", true, "Set this to false to disable all features from this mod related to absorption health.\nThat is, every feature in the mod except for the features in the \"normal_health\" category.");
        public final float DEATH_PENALTY = this.prop("death_penalty", 2.0f, "The amount of natural absorption a player loses with each death. Will not drop below the death penalty limit.");
        public final float DEATH_PENALTY_LIMIT = this.prop("death_penalty_limit", 8.0f, "A player will not drop below this much natural absorption due to death penalty.");
        public final float GLOBAL_MAXIMUM = this.prop("global_max_absorption", Float.POSITIVE_INFINITY, "The total maximum absorption a player may obtain through natural, enchantments, and/or armor replacement.\nDoes not include max absorption gained from potions.");
        public final int RECOVER_DELAY = this.prop("recover_delay", 120, "The amount of time (in ticks) a player must go without taking damage before their absorption shield\nbegins to recover. If this is set less than 0, players will not naturally recover lost absorption shields.\n(20 ticks = 1 second)", R_INT_TOKEN_NEG);
        public final float RECOVER_RATE = this.prop("recover_rate", 2.0f, "The amount of absorption health regenerated each second while recovering.") / 20.0f;
        public final float RECOVERY_ON_RESPAWN = this.prop("recovery_on_respawn", 0.0f, "Players will respawn with up to this much absorption health, limited by their personal max absorption.");
        public final boolean RENDER_CAPACITY_BACKGROUND = this.prop("render_capacity_bg", true, "If true, the mod will render the empty heart background behind absorption hearts you are missing,\nbut can regenerate back. This may not work right if another mod changes health bar rendering.");
        public final float STARTING_AMOUNT = this.prop("starting_absorption", 4.0f, "The amount of natural absorption a new player starts with.");

        @Override
        String name() {
            return "absorption_health";
        }

        @Override
        String comment() {
            return "Options relating to absorption health (yellow hearts) in general.\nAll absorption amounts are in half-hearts.";
        }
    }

    public class GENERAL
    extends PropertyCategory {
        public final int UPDATE_TIME = this.prop("update_time", 5, "The number of ticks between recovery updates.\n(20 ticks = 1 second)", R_INT_POS1);

        @Override
        String name() {
            return "_general";
        }

        @Override
        String comment() {
            return "General and/or miscellaneous options.";
        }
    }
}

