/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.naturalabsorption.health;

import fathertoast.naturalabsorption.MessageCapacity;
import fathertoast.naturalabsorption.ObfuscationHelper;
import fathertoast.naturalabsorption.config.Config;
import fathertoast.naturalabsorption.health.HealthData;
import fathertoast.naturalabsorption.item.EnchantmentAbsorption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HealthManager {
    private static final Set<DamageSource> MODDED_SOURCES = new HashSet<DamageSource>();
    private int cleanupCounter = 0;
    private int updateCounter = 0;

    private static boolean isSourceModified(DamageSource source) {
        return MODDED_SOURCES.contains(source);
    }

    private static void modifySource(DamageSource source) {
        if (source.func_76363_c()) {
            return;
        }
        ObfuscationHelper.DamageSource_isUnblockable.set(source, true);
    }

    private static void unmodifySource(DamageSource source) {
        ObfuscationHelper.DamageSource_isUnblockable.set(source, false);
        MODDED_SOURCES.remove(source);
    }

    public static void clearSources() {
        for (DamageSource source : MODDED_SOURCES) {
            ObfuscationHelper.DamageSource_isUnblockable.set(source, false);
        }
        MODDED_SOURCES.clear();
    }

    public static float getArmorAbsorption(EntityPlayer player) {
        float bonus = 0.0f;
        if (Config.get().ARMOR.REPLACE_ARMOR || Config.get().ARMOR.ARMOR_MULT_OVERRIDE) {
            bonus += Config.get().ARMOR.ARMOR_MULT * (float)player.func_70658_aO();
        }
        if (Config.get().ENCHANTMENT.ENABLED) {
            bonus += EnchantmentAbsorption.getBonusCapacity(player);
        }
        return bonus;
    }

    public static float getPotionAbsorption(EntityPlayer player) {
        PotionEffect absorptionPotion = player.func_70660_b(MobEffects.field_76444_x);
        if (absorptionPotion != null) {
            return 4 * (absorptionPotion.func_76458_c() + 1);
        }
        return 0.0f;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (++this.cleanupCounter >= 600) {
                this.cleanupCounter = 0;
                HealthManager.clearSources();
                HealthData.clearCache();
            }
            if (++this.updateCounter >= Config.get().GENERAL.UPDATE_TIME) {
                WorldServer[] worlds;
                this.updateCounter = 0;
                for (WorldServer world : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    if (world == null) continue;
                    if (Config.get().NORMAL_HEALTH.ENABLED && Config.get().NORMAL_HEALTH.DISABLE_GAMERULE_REGEN) {
                        world.func_82736_K().func_82764_b("naturalRegeneration", "false");
                    }
                    for (EntityPlayer player : new ArrayList(world.field_73010_i)) {
                        if (player == null || !player.func_70089_S()) continue;
                        HealthData.get(player).update();
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        int hungerRestore;
        ItemStack stack;
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K && Config.get().NORMAL_HEALTH.ENABLED && Config.get().NORMAL_HEALTH.FOOD_HEALING > 0.0f && !(stack = event.getItem()).func_190926_b() && stack.func_77973_b() instanceof ItemFood && (hungerRestore = ((ItemFood)stack.func_77973_b()).func_150905_g(stack)) > 0) {
            event.getEntityLiving().func_70691_i((float)hungerRestore * Config.get().NORMAL_HEALTH.FOOD_HEALING);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K && !event.isEndConquered()) {
            HealthData data = HealthData.get(event.player);
            if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ABSORPTION_HEALTH.DEATH_PENALTY > 0.0f && data.getAbsorptionCapacity() > Config.get().ABSORPTION_HEALTH.DEATH_PENALTY_LIMIT) {
                float newCapacity = data.getAbsorptionCapacity() - Config.get().ABSORPTION_HEALTH.DEATH_PENALTY;
                if (newCapacity < Config.get().ABSORPTION_HEALTH.DEATH_PENALTY_LIMIT) {
                    data.setAbsorptionCapacity(Config.get().ABSORPTION_HEALTH.DEATH_PENALTY_LIMIT);
                } else {
                    data.setAbsorptionCapacity(newCapacity);
                }
            }
            data.startRecoveryDelay();
            if (Config.get().NORMAL_HEALTH.ENABLED && Config.get().NORMAL_HEALTH.RECOVERY_ON_RESPAWN > 0.0f) {
                data.owner.func_70606_j(Config.get().NORMAL_HEALTH.RECOVERY_ON_RESPAWN);
            }
            if (Config.get().ABSORPTION_HEALTH.ENABLED) {
                data.setAbsorptionHealth(Config.get().ABSORPTION_HEALTH.RECOVERY_ON_RESPAWN);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            float absorptionHealth = player.func_110139_bj();
            player.func_110149_m(absorptionHealth + 0.01f);
            player.func_110149_m(absorptionHealth);
            MessageCapacity.sendFor(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            HealthData data = HealthData.get((EntityPlayer)event.getEntityLiving());
            data.startRecoveryDelay();
            if (Config.get().ABSORPTION_HEALTH.ENABLED && Config.get().ARMOR.REPLACE_ARMOR) {
                if (!event.getSource().func_76363_c()) {
                    HealthManager.modifySource(event.getSource());
                }
                if (event.getAmount() > Config.get().ARMOR.DURABILITY_THRESHOLD && !event.getSource().func_76357_e() && !"thorns".equalsIgnoreCase(event.getSource().field_76373_n)) {
                    switch (Config.get().ARMOR.DURABILITY_TRIGGER) {
                        case NONE: {
                            break;
                        }
                        case HITS: {
                            if (this.isSourceDamageOverTime(event.getSource(), event.getAmount())) break;
                        }
                        default: {
                            this.damageArmor(event);
                        }
                    }
                }
            }
        } else if (Config.get().ARMOR.REPLACE_ARMOR && HealthManager.isSourceModified(event.getSource())) {
            HealthManager.unmodifySource(event.getSource());
        }
    }

    private boolean isSourceDamageOverTime(DamageSource source, float amount) {
        return source == DamageSource.field_76376_m && amount <= 1.0f || source == DamageSource.field_82727_n || source == DamageSource.field_76370_b || source == DamageSource.field_76372_a || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e || source == DamageSource.field_76367_g || source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76369_e || source == DamageSource.field_76366_f;
    }

    private void damageArmor(LivingHurtEvent event) {
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        float durabilityDamage = event.getAmount();
        if (Config.get().ARMOR.DURABILITY_FRIENDLY && durabilityDamage > player.func_110139_bj()) {
            durabilityDamage = player.func_110139_bj();
        }
        durabilityDamage *= Config.get().ARMOR.DURABILITY_MULT;
        if (!event.getSource().func_76357_e() && durabilityDamage > 0.0f) {
            player.field_71071_by.func_70449_g(durabilityDamage);
        }
    }

    public static enum EnumDurabilityTrigger {
        ALL,
        HITS,
        NONE;

    }
}

