/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.torocraft.toroquest.entities.EntityGuard;

public class TileEntityToroSpawner
extends TileEntity
implements ITickable {
    private int triggerDistance = 60;
    private List<String> entityIds = new ArrayList<String>();
    private int spawnRadius = 0;
    private int spawnTryCount = 0;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private List<String> entityTags = new ArrayList<String>();

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    public void setTriggerDistance(int triggerDistance) {
        this.triggerDistance = triggerDistance;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagList list;
        super.func_145839_a(compound);
        this.triggerDistance = compound.func_74762_e("trigger_distance");
        this.spawnRadius = compound.func_74762_e("spawn_radius");
        this.helmet = this.readItemStack("helment", compound);
        this.boots = this.readItemStack("boots", compound);
        this.chestplate = this.readItemStack("chestplate", compound);
        this.leggings = this.readItemStack("leggings", compound);
        this.entityIds = new ArrayList<String>();
        this.entityTags = new ArrayList<String>();
        try {
            list = (NBTTagList)compound.func_74781_a("entity_ids");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.entityIds.add(list.func_150307_f(i));
        }
        try {
            list = (NBTTagList)compound.func_74781_a("entity_tags");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.entityTags.add(list.func_150307_f(i));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("trigger_distance", this.triggerDistance);
        compound.func_74768_a("spawn_radius", this.spawnRadius);
        this.storeItemStack("helment", this.helmet, compound);
        this.storeItemStack("boots", this.boots, compound);
        this.storeItemStack("chestplate", this.chestplate, compound);
        this.storeItemStack("leggings", this.leggings, compound);
        NBTTagList list = new NBTTagList();
        for (String id : this.entityIds) {
            list.func_74742_a((NBTBase)new NBTTagString(id));
        }
        compound.func_74782_a("entity_ids", (NBTBase)list);
        list = new NBTTagList();
        if (this.entityTags != null) {
            for (String id : this.entityTags) {
                list.func_74742_a((NBTBase)new NBTTagString(id));
            }
        }
        compound.func_74782_a("entity_tags", (NBTBase)list);
        return compound;
    }

    protected void storeItemStack(String key, ItemStack stack, NBTTagCompound compound) {
        if (stack == null) {
            return;
        }
        NBTTagCompound c = new NBTTagCompound();
        stack.func_77955_b(c);
        compound.func_74782_a(key, (NBTBase)c);
    }

    protected ItemStack readItemStack(String key, NBTTagCompound compound) {
        if (!compound.func_74764_b(key)) {
            return null;
        }
        return new ItemStack(compound.func_74775_l(key));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isRunTick() && this.withinRange()) {
            this.triggerSpawner();
        }
    }

    protected void triggerSpawner() {
        for (String entityId : this.entityIds) {
            this.spawnCreature(entityId);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public void spawnCreature(String entityID) {
        Random rand = this.field_145850_b.field_73012_v;
        Entity entity = TileEntityToroSpawner.getEntityForId(this.func_145831_w(), entityID);
        if (!(entity instanceof EntityLivingBase)) {
            System.out.println("entity not EntityLivingBase: " + entityID);
            return;
        }
        this.spawnEntityLiving((EntityLiving)entity, this.findSuitableSpawnLocation());
    }

    private BlockPos findSuitableSpawnLocation() {
        Random rand = this.field_145850_b.field_73012_v;
        if (this.spawnRadius < 1) {
            return this.func_174877_v();
        }
        for (int i = 0; i < 10; ++i) {
            int z;
            int degrees;
            int distance = rand.nextInt(this.spawnRadius);
            int x = distance * (int)Math.round(Math.cos(Math.toRadians(degrees = rand.nextInt(360))));
            BlockPos pos = this.findSurface(x, z = distance * (int)Math.round(Math.sin(Math.toRadians(degrees))));
            if (pos == null) continue;
            return pos;
        }
        return this.func_174877_v();
    }

    private BlockPos findSurface(int x, int z) {
        BlockPos pos = this.func_174877_v().func_177982_a(x, -3, z);
        boolean groundFound = false;
        boolean[] airSpace = new boolean[]{false, false};
        for (int yOffset = 0; yOffset < 14; ++yOffset) {
            IBlockState blockState = this.field_145850_b.func_180495_p(pos);
            if (this.isGroundBlock(blockState)) {
                groundFound = true;
                airSpace[0] = false;
                airSpace[1] = false;
            } else {
                if (airSpace[0] && airSpace[1] && groundFound) {
                    return pos.func_177977_b();
                }
                if (Blocks.field_150350_a.equals(blockState.func_177230_c())) {
                    if (airSpace[0]) {
                        airSpace[1] = true;
                    } else {
                        airSpace[0] = true;
                    }
                }
            }
            pos = pos.func_177984_a();
        }
        return null;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    public static Entity getEntityForId(World world, String entityID) {
        String entityName;
        String domain;
        String[] parts = entityID.split(":");
        if (parts.length == 2) {
            domain = parts[0];
            entityName = parts[1];
        } else {
            domain = "minecraft";
            entityName = entityID;
        }
        return EntityList.func_188429_b((ResourceLocation)new ResourceLocation(domain, entityName), (World)world);
    }

    protected boolean spawnEntityLiving(EntityLiving entity, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)entity)), (IEntityLivingData)null);
        entity.func_110163_bv();
        if (this.entityTags != null) {
            for (String tag : this.entityTags) {
                entity.func_184211_a(tag);
            }
        }
        if (this.helmet != null) {
            try {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, this.helmet);
            }
            catch (Exception e) {
                System.out.println("failed to add helment: " + e.getMessage());
            }
        }
        if (this.boots != null) {
            try {
                entity.func_184201_a(EntityEquipmentSlot.FEET, this.boots);
            }
            catch (Exception e) {
                System.out.println("failed to add boots: " + e.getMessage());
            }
        }
        if (this.chestplate != null) {
            try {
                entity.func_184201_a(EntityEquipmentSlot.CHEST, this.chestplate);
            }
            catch (Exception e) {
                System.out.println("failed to add chestplate: " + e.getMessage());
            }
        }
        if (this.leggings != null) {
            try {
                entity.func_184201_a(EntityEquipmentSlot.LEGS, this.leggings);
            }
            catch (Exception e) {
                System.out.println("failed to add leggings: " + e.getMessage());
            }
        }
        this.field_145850_b.func_72838_d((Entity)entity);
        entity.func_70642_aH();
        return true;
    }

    private void spawnCreature() {
        EntityGuard entity;
        EntityGuard entityliving = entity = new EntityGuard(this.field_145850_b);
        entity.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        ((EntityLiving)entityliving).field_70759_as = ((EntityLiving)entityliving).field_70177_z;
        ((EntityLiving)entityliving).field_70761_aq = ((EntityLiving)entityliving).field_70177_z;
        entityliving.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)entityliving)), null);
        this.field_145850_b.func_72838_d((Entity)entity);
    }

    private boolean withinRange() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.triggerDistance);
    }

    private boolean isRunTick() {
        return this.field_145850_b.func_82737_E() % 20L == 0L;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbttagcompound = this.func_189515_b(new NBTTagCompound());
        nbttagcompound.func_82580_o("SpawnPotentials");
        return nbttagcompound;
    }

    public boolean func_183000_F() {
        return true;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
    }

    public int getTriggerDistance() {
        return this.triggerDistance;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
    }

    public List<String> getEntityTags() {
        return this.entityTags;
    }

    public void setEntityTags(List<String> entityTags) {
        this.entityTags = entityTags;
    }

    public void addEntityTag(String tag) {
        if (this.entityTags == null) {
            this.entityTags = new ArrayList<String>();
        }
        this.entityTags.add(tag);
    }
}

