/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationEvent;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityFugitive;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.util.TaskRunner;

public class CivilizationHandlers {
    @SubscribeEvent
    public void handleReputationChange(CivilizationEvent.ReputationChange event) {
    }

    @SubscribeEvent
    public void handleEnterProvince(CivilizationEvent.Enter event) {
    }

    @SubscribeEvent
    public void handleLeaveProvince(CivilizationEvent.Leave event) {
    }

    @SubscribeEvent
    public void onDeath(PlayerEvent.Clone event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability newCap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        PlayerCivilizationCapability originalCap = PlayerCivilizationCapabilityImpl.get(event.getOriginal());
        if (originalCap == null) {
            return;
        }
        if (newCap == null) {
            throw new NullPointerException("missing player capability during clone");
        }
        newCap.readNBT((NBTBase)originalCap.writeNBT());
    }

    @SubscribeEvent
    public void onSave(PlayerEvent.SaveToFile event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability cap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        if (cap == null) {
            return;
        }
        NBTTagCompound civData = cap.writeNBT();
        if (civData == null || civData.func_74781_a("reputations") == null || ((NBTTagList)civData.func_74781_a("reputations")).func_74745_c() < 1) {
            return;
        }
        event.getEntityPlayer().getEntityData().func_74782_a("toroquest.playerCivilization", (NBTBase)civData);
    }

    @SubscribeEvent
    public void onLoad(PlayerEvent.LoadFromFile event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PlayerCivilizationCapability cap = PlayerCivilizationCapabilityImpl.get(event.getEntityPlayer());
        if (cap == null) {
            return;
        }
        NBTTagCompound c = event.getEntityPlayer().getEntityData().func_74775_l("toroquest.playerCivilization");
        if (c != null) {
            System.out.println("LOAD: " + c.toString());
        }
        cap.readNBT((NBTBase)c);
    }

    @SubscribeEvent
    public void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getObject();
        event.addCapability(new ResourceLocation("toroquest", "playerCivilization"), (ICapabilityProvider)new PlayerCivilizationCapabilityProvider(player));
        this.syncClientCapability(player);
    }

    private void syncClientCapability(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            TaskRunner.queueTask(new EventHandlers.SyncTask(), 30);
        }
    }

    public static void adjustPlayerRep(EntityPlayer player, int chunkX, int chunkZ, int value) {
        Province province = CivilizationUtil.getProvinceAt(player.func_130014_f_(), chunkX, chunkZ);
        if (province == null || province.civilization == null) {
            return;
        }
        PlayerCivilizationCapabilityImpl.get(player).adjustReputation(province.civilization, value);
    }

    @SubscribeEvent
    public void checkKillsInCivilization(LivingDeathEvent event) {
        EntityPlayer player = null;
        EntityLivingBase victim = (EntityLivingBase)event.getEntity();
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)source.func_76346_g();
        }
        if (player == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        PlayerCivilizationCapabilityImpl.get(player).adjustReputation(province.civilization, this.getRepuationAdjustmentFor(victim, province));
    }

    private int getRepuationAdjustmentFor(EntityLivingBase victim, Province province) {
        if (province == null || province.civilization == null) {
            return 0;
        }
        if (victim instanceof EntityFugitive) {
            return 5;
        }
        if (victim.getClass().getName().equals("net.minecraft.entity.passive.EntityVillager")) {
            return -10;
        }
        if (this.isHostileMob(victim)) {
            return 1;
        }
        if (victim instanceof EntityToroNpc) {
            CivilizationType npcCiv = ((EntityToroNpc)victim).getCivilization();
            int amount = 0;
            amount = npcCiv == null ? -1 : (npcCiv.equals((Object)province.civilization) ? -10 : 10);
            if (victim instanceof EntityVillageLord) {
                amount *= 10;
            }
            return amount;
        }
        if (victim instanceof EntityBat) {
            return 0;
        }
        if (ToroQuestConfiguration.animalsAffectRep && this.isAnimal(victim)) {
            return -1;
        }
        return 0;
    }

    private boolean isAnimal(EntityLivingBase victim) {
        return victim instanceof EntityCow || victim instanceof EntityHorse || victim instanceof EntityPig || victim instanceof EntityDonkey || victim instanceof EntityChicken || victim instanceof EntitySheep;
    }

    private boolean isHostileMob(EntityLivingBase victim) {
        return victim instanceof EntityMob || victim instanceof EntitySlime || victim instanceof EntityMagmaCube || victim instanceof EntityGhast || victim instanceof EntityShulker;
    }

    @SubscribeEvent
    public void handleEnteringProvince(EntityEvent.EnteringChunk event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        PlayerCivilizationCapabilityImpl.get((EntityPlayer)player).updatePlayerLocation(event.getNewChunkX(), event.getNewChunkZ());
    }

    public static TextComponentString leavingMessage(EntityPlayer player, Province province) {
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        String s = rep >= 10 ? province.civilization.getFriendlyLeavingMessage(province) : (rep <= -10 ? province.civilization.getHostileLeavingMessage(province) : province.civilization.getNeutralLeavingMessage(province));
        return new TextComponentString(s);
    }

    public static TextComponentString enteringMessage(EntityPlayer player, Province province) {
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        String s = rep >= 10 ? province.civilization.getFriendlyEnteringMessage(province) : (rep <= -10 ? province.civilization.getHostileEnteringMessage(province) : province.civilization.getNeutralEnteringMessage(province));
        return new TextComponentString(s);
    }

    @SubscribeEvent
    public void breed(BabyEntitySpawnEvent event) {
        if (!ToroQuestConfiguration.animalsAffectRep) {
            return;
        }
        if (!(event.getParentA() instanceof EntityAnimal)) {
            return;
        }
        if (!(event.getParentB() instanceof EntityAnimal)) {
            return;
        }
        EntityPlayerMP playerA = ((EntityAnimal)event.getParentA()).func_191993_do();
        EntityPlayerMP playerB = ((EntityAnimal)event.getParentB()).func_191993_do();
        if (playerA != null) {
            CivilizationHandlers.adjustPlayerRep((EntityPlayer)playerA, event.getParentA().field_70176_ah, event.getParentA().field_70164_aj, 1);
        }
        if (playerB != null) {
            CivilizationHandlers.adjustPlayerRep((EntityPlayer)playerB, event.getParentB().field_70176_ah, event.getParentB().field_70164_aj, 1);
        }
    }

    private int getFarmRepAmount(Random rand) {
        return rand.nextInt(5) == 0 ? 1 : 0;
    }

    @SubscribeEvent
    public void farm(BlockEvent.PlaceEvent event) {
        if (!ToroQuestConfiguration.cropsAffectRep) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (CivilizationHandlers.isCrop(event.getState().func_177230_c())) {
            if (CivilizationHandlers.isCrop(event.getBlockSnapshot().getReplacedBlock().func_177230_c()) && event.getWorld().field_73012_v.nextInt(100) > 20) {
                return;
            }
            BlockPos pos = event.getBlockSnapshot().getPos();
            CivilizationHandlers.adjustPlayerRep(event.getPlayer(), pos.func_177958_n() / 16, pos.func_177952_p() / 16, this.getFarmRepAmount(event.getWorld().field_73012_v));
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (!ToroQuestConfiguration.cropsAffectRep) {
            return;
        }
        if (CivilizationHandlers.isCrop(event.getState().func_177230_c())) {
            BlockPos pos = event.getPos();
            AxisAlignedBB bb = new AxisAlignedBB(pos);
            List players = event.getWorld().func_72872_a(EntityPlayer.class, bb);
            if (players != null && players.size() > 0) {
                for (EntityPlayer player : players) {
                    CivilizationHandlers.adjustPlayerRep(player, pos.func_177958_n() / 16, pos.func_177952_p() / 16, -this.getFarmRepAmount(event.getWorld().field_73012_v));
                }
            }
        }
    }

    @SubscribeEvent
    public void harvest(BlockEvent.BreakEvent event) {
        if (!ToroQuestConfiguration.cropsAffectRep) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (CivilizationHandlers.isCrop(event.getState().func_177230_c())) {
            BlockPos pos = event.getPos();
            CivilizationHandlers.adjustPlayerRep(event.getPlayer(), pos.func_177958_n() / 16, pos.func_177952_p() / 16, -this.getFarmRepAmount(event.getWorld().field_73012_v));
        }
    }

    public static boolean isCrop(Block block) {
        return block instanceof BlockCrops || block instanceof BlockStem;
    }

    private int randomSpawnDistance(Random rand) {
        int d = rand.nextInt(20) + 20;
        if (rand.nextBoolean()) {
            d = -d;
        }
        return d;
    }

    @SubscribeEvent
    public void spawnSentries(TickEvent.PlayerTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (world.field_72995_K || world.func_82737_E() % 200L != 0L) {
            return;
        }
        this.spawnSentry(player, player.func_180425_c(), world);
        this.spawnFugitive(player.func_180425_c(), world);
    }

    private void spawnFugitive(BlockPos position, World world) {
        BlockPos randomNearbySpot = position.func_177982_a(this.randomSpawnDistance(world.field_73012_v), 0, this.randomSpawnDistance(world.field_73012_v));
        if (world.field_73012_v.nextInt(200) != 0) {
            return;
        }
        Province province = CivilizationUtil.getProvinceAt(world, randomNearbySpot.func_177958_n() / 16, randomNearbySpot.func_177952_p() / 16);
        if (province == null) {
            return;
        }
        BlockPos spawnPos = this.findSpawnLocationFrom(world, randomNearbySpot);
        if (spawnPos == null) {
            return;
        }
        int localFugitiveCount = world.func_72872_a(EntityFugitive.class, new AxisAlignedBB(spawnPos).func_72321_a(50.0, 40.0, 50.0)).size();
        if (localFugitiveCount > 1) {
            return;
        }
        EntityFugitive e = new EntityFugitive(world);
        e.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
        world.func_72838_d((Entity)e);
    }

    protected void spawnSentry(EntityPlayer player, BlockPos position, World world) {
        if (world == null || world.field_73011_w == null) {
            return;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        BlockPos randomNearbySpot = position.func_177982_a(this.randomSpawnDistance(world.field_73012_v), 0, this.randomSpawnDistance(world.field_73012_v));
        Province province = CivilizationUtil.getProvinceAt(world, randomNearbySpot.func_177958_n() / 16, randomNearbySpot.func_177952_p() / 16);
        if (province == null) {
            return;
        }
        if (!province.hasLord) {
            return;
        }
        BlockPos spawnPos = this.findSpawnLocationFrom(world, randomNearbySpot);
        if (spawnPos == null) {
            return;
        }
        int localSentryCount = world.func_72872_a(EntitySentry.class, new AxisAlignedBB(spawnPos).func_72321_a(50.0, 40.0, 50.0)).size();
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(province.civilization);
        int extraSpawns = 0;
        if (rep < -10) {
            extraSpawns = Math.round((float)(-rep) / 50.0f);
        }
        if (localSentryCount > 5 + extraSpawns) {
            return;
        }
        int count = world.field_73012_v.nextInt(3) + 1;
        for (int i = 0; i < count; ++i) {
            EntitySentry e = new EntitySentry(world);
            e.setCivilization(province.civilization);
            e.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
        }
    }

    private BlockPos findSpawnLocationFrom(World world, BlockPos from) {
        BlockPos spawnPos = from.func_177982_a(0, 20, 0);
        boolean[] airSpace = new boolean[]{false, false};
        for (int i = 0; i < 40; ++i) {
            IBlockState blockState = world.func_180495_p(spawnPos);
            if (this.isAir(blockState)) {
                if (airSpace[0]) {
                    airSpace[1] = true;
                } else {
                    airSpace[0] = true;
                }
            } else if (this.isGroundBlock(blockState)) {
                if (airSpace[0] && airSpace[1]) {
                    return spawnPos.func_177984_a();
                }
                airSpace[0] = false;
                airSpace[1] = false;
            } else {
                airSpace[0] = false;
                airSpace[1] = false;
            }
            spawnPos = spawnPos.func_177977_b();
        }
        return null;
    }

    private boolean isAir(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150350_a;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    public static class PlayerCivilizationCapabilityProvider
    implements ICapabilityProvider {
        @CapabilityInject(value=PlayerCivilizationCapability.class)
        public static final Capability<PlayerCivilizationCapability> CAP = null;
        private PlayerCivilizationCapability instance;

        public PlayerCivilizationCapabilityProvider(EntityPlayer player) {
            this.instance = new PlayerCivilizationCapabilityImpl(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (CAP != null && capability == CAP) {
                return (T)PlayerCivilizationCapabilityImpl.INSTANCE.cast((Object)this.instance);
            }
            return null;
        }
    }
}

