/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ProvinceNames;
import net.torocraft.toroquest.civilization.Structure;
import net.torocraft.toroquest.config.ToroQuestConfiguration;

public class CivilizationsWorldSaveData
extends WorldSavedData
implements CivilizationDataAccessor {
    private static final String DATA_NAME = "toroquest_civilizations";
    private static final int RADIUS = 12;
    public World world;
    private TreeMap<Integer, TreeMap<Integer, Province>> provincesTreeMap = new TreeMap();
    private List<Province> provinces = new ArrayList<Province>();
    private List<Structure> structures = new ArrayList<Structure>();

    public CivilizationsWorldSaveData() {
        super(DATA_NAME);
    }

    public CivilizationsWorldSaveData(String name) {
        super(name);
    }

    @Override
    public synchronized boolean canGenStructure(String type, int chunkX, int chunkZ) {
        if (chunkX < 70 && chunkZ < 70) {
            return false;
        }
        for (Structure s : this.structures) {
            if (s.distanceSqFrom(chunkX, chunkZ) < (double)ToroQuestConfiguration.structureMinDistance) {
                return false;
            }
            if (!type.equals(s.type) || !(s.distanceSqFrom(chunkX, chunkZ) < (double)ToroQuestConfiguration.structureMinDistanceBetweenSame)) continue;
            return false;
        }
        Structure newStructure = new Structure();
        newStructure.type = type;
        newStructure.chunkX = chunkX;
        newStructure.chunkZ = chunkZ;
        this.structures.add(newStructure);
        return true;
    }

    @Override
    public Province atLocation(final int chunkX, final int chunkZ) {
        Iterator<Province> iterator;
        Collection<Province> provinces = this.scan(chunkX, chunkZ);
        if (provinces == null || provinces.size() < 1) {
            return null;
        }
        if (provinces.size() == 1 && (iterator = provinces.iterator()).hasNext()) {
            Province border = iterator.next();
            return border;
        }
        ArrayList<Province> list = new ArrayList<Province>(provinces);
        Collections.sort(list, new Comparator<Province>(){

            @Override
            public int compare(Province a, Province b) {
                double d1;
                double d0 = CivilizationsWorldSaveData.this.chunkDistanceSq(chunkX, chunkZ, a.chunkX, a.chunkZ);
                return d0 < (d1 = (double)CivilizationsWorldSaveData.this.chunkDistanceSq(chunkX, chunkZ, b.chunkX, b.chunkZ)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        });
        return (Province)list.get(0);
    }

    public int chunkDistanceSq(int aX, int aZ, int bX, int bZ) {
        int x = aX - bX;
        int z = aZ - bZ;
        return x * x + z * z;
    }

    private Collection<Province> scan(int chunkX, int chunkZ) {
        return this.sequentialScan(chunkX, chunkZ);
    }

    private Collection<Province> sequentialScan(int chunkX, int chunkZ) {
        int lowerX = chunkX - 12;
        int upperX = chunkX + 12;
        int lowerZ = chunkZ - 12;
        int upperZ = chunkZ + 12;
        ArrayList<Province> subset = new ArrayList<Province>();
        for (Province p : this.provinces) {
            if (p.chunkX < lowerX || p.chunkX > upperX || p.chunkZ < lowerZ || p.chunkZ > upperZ) continue;
            subset.add(p);
        }
        return subset;
    }

    protected Collection<Province> rangeQueryOnProvinces(int chunkX, int chunkZ) {
        try {
            Iterator<TreeMap<Integer, Province>> iterator = this.provincesTreeMap.subMap(chunkX - 12, chunkX + 12).values().iterator();
            if (iterator.hasNext()) {
                TreeMap<Integer, Province> zValues = iterator.next();
                return zValues.subMap(chunkZ - 12, chunkZ + 12).values();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized Province register(int chunkX, int chunkZ) {
        Province province = this.atLocation(chunkX, chunkZ);
        if (province != null) {
            this.updateExistingProvince(province, chunkX, chunkZ);
        } else {
            province = this.buildNewProvince(chunkX, chunkZ);
        }
        this.func_76185_a();
        return province;
    }

    @Override
    public void setProvinceHasLord(UUID provinceId, boolean hasLord) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            p.hasLord = hasLord;
            this.func_76185_a();
            return;
        }
    }

    @Override
    public boolean provinceHasLord(UUID provinceId) {
        for (Province p : this.provinces) {
            if (!provinceId.equals(p.id)) continue;
            return p.hasLord;
        }
        return false;
    }

    protected Province buildNewProvince(int chunkX, int chunkZ) {
        Province province = new Province();
        province.id = UUID.randomUUID();
        province.chunkX = chunkX;
        province.chunkZ = chunkZ;
        province.civilization = this.randomCivilizationType();
        province.name = ProvinceNames.random(new Random());
        province.hasLord = false;
        province.lowerVillageBoundX = chunkX;
        province.upperVillageBoundX = chunkX;
        province.lowerVillageBoundZ = chunkZ;
        province.upperVillageBoundZ = chunkZ;
        province.computeSize();
        this.addProvinceToSaveData(province);
        return province;
    }

    protected CivilizationType randomCivilizationType() {
        Random rand = this.world.field_73012_v;
        return CivilizationType.values()[rand.nextInt(CivilizationType.values().length)];
    }

    private synchronized void updateExistingProvince(Province province, int chunkX, int chunkZ) {
        province.addToBoundsAndRecenter(chunkX, chunkZ);
    }

    private synchronized void addProvinceToSaveData(Province province) {
        this.provinces.add(province);
        this.addProvinceToTreeMap(province);
    }

    protected void addProvinceToTreeMap(Province border) {
        if (this.provincesTreeMap.get(border.chunkX) == null) {
            this.provincesTreeMap.put(border.chunkX, new TreeMap());
        }
        this.provincesTreeMap.get(border.chunkX).put(border.chunkZ, border);
    }

    public void func_76184_a(NBTTagCompound t) {
        NBTTagList list;
        try {
            list = (NBTTagList)t.func_74781_a("provinces");
        }
        catch (Exception e) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Province province = new Province();
            province.readNBT(list.func_150305_b(i));
            if (province.id == null) {
                province.id = UUID.randomUUID();
                System.out.println("----- adding missing province ID");
                this.func_76185_a();
            }
            if (province.name == null || province.name.trim().length() == 0) {
                province.name = ProvinceNames.random(new Random());
                System.out.println("----- adding missing province name");
                this.func_76185_a();
            }
            this.addProvinceToSaveData(province);
        }
        NBTTagList slist = null;
        try {
            slist = (NBTTagList)t.func_74781_a("structures");
        }
        catch (Exception province) {
            // empty catch block
        }
        if (slist == null) {
            slist = new NBTTagList();
        }
        for (int i = 0; i < slist.func_74745_c(); ++i) {
            this.structures.clear();
            Structure s = new Structure();
            s.readNBT(slist.func_150305_b(i));
            this.structures.add(s);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound t) {
        NBTTagList list = new NBTTagList();
        for (Province p : this.provinces) {
            list.func_74742_a((NBTBase)p.writeNBT());
        }
        NBTTagList slist = new NBTTagList();
        for (Structure s : this.structures) {
            list.func_74742_a((NBTBase)s.writeNBT());
        }
        t.func_74782_a("provinces", (NBTBase)list);
        t.func_74782_a("structures", (NBTBase)slist);
        return t;
    }

    public static CivilizationDataAccessor get(World world) {
        MapStorage storage = world.func_175693_T();
        CivilizationsWorldSaveData instance = (CivilizationsWorldSaveData)storage.func_75742_a(CivilizationsWorldSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new CivilizationsWorldSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        instance.world = world;
        return instance;
    }

    @Override
    public List<Province> getProvinces() {
        ArrayList<Province> copy = new ArrayList<Province>();
        copy.addAll(this.provinces);
        return copy;
    }
}

