/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public enum ReputationLevel {
    HERO(0.7),
    ALLY(0.9),
    FRIEND(1.0),
    DRIFTER(1.7),
    OUTCAST(10.0),
    ENEMY(50.0),
    VILLAIN(100.0);

    private double priceMultiplier;

    private ReputationLevel(double priceMultiplier) {
        this.priceMultiplier = priceMultiplier;
    }

    public double getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int adjustPrice(int price) {
        return MathHelper.func_76125_a((int)((int)((double)price * this.priceMultiplier)), (int)1, (int)64);
    }

    public String getLocalname() {
        return I18n.func_135052_a((String)("civilization.reputation_level." + this.toString().toLowerCase()), (Object[])new Object[0]);
    }

    public static ReputationLevel fromReputation(int rep) {
        if (rep <= -1000) {
            return VILLAIN;
        }
        if (rep <= -100) {
            return ENEMY;
        }
        if (rep <= -10) {
            return OUTCAST;
        }
        if (rep < 10) {
            return DRIFTER;
        }
        if (rep < 100) {
            return FRIEND;
        }
        if (rep < 1000) {
            return ALLY;
        }
        return HERO;
    }
}

