/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.player;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.toroquest.civilization.CivilizationEvent;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ReputationLevel;
import net.torocraft.toroquest.civilization.player.PlayerCivilization;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.QuestCourier;
import net.torocraft.toroquest.civilization.quests.QuestEnemyEncampment;
import net.torocraft.toroquest.civilization.quests.QuestFarm;
import net.torocraft.toroquest.civilization.quests.QuestGather;
import net.torocraft.toroquest.civilization.quests.QuestKillMobs;
import net.torocraft.toroquest.civilization.quests.QuestMine;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.QuestDelegator;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessagePlayerCivilizationSetInCiv;
import net.torocraft.toroquest.network.message.MessageSetPlayerReputation;

public class PlayerCivilizationCapabilityImpl
extends PlayerCivilization
implements PlayerCivilizationCapability {
    @CapabilityInject(value=PlayerCivilizationCapability.class)
    public static Capability<PlayerCivilizationCapability> INSTANCE = null;
    private final EntityPlayer player;

    public PlayerCivilizationCapabilityImpl(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void setReputation(CivilizationType civ, int amount) {
        if (civ == null) {
            return;
        }
        this.reputations.put(civ, amount);
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetPlayerReputation(civ, amount), (EntityPlayerMP)this.player);
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.ReputationChange(this.player, civ, amount));
            ReputationLevel reputationLevel = ReputationLevel.fromReputation(amount);
        }
    }

    @Override
    public void adjustReputation(CivilizationType civ, int amount) {
        if (civ == null) {
            return;
        }
        if (this.reputations.get((Object)civ) == null) {
            this.reputations.put(civ, 0);
        }
        this.setReputation(civ, (Integer)this.reputations.get((Object)civ) + amount);
    }

    @Override
    public void syncClient() {
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayerCivilizationSetInCiv(this.inCiv), (EntityPlayerMP)this.player);
            for (Map.Entry entry : this.reputations.entrySet()) {
                ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetPlayerReputation((CivilizationType)((Object)entry.getKey()), (Integer)entry.getValue()), (EntityPlayerMP)this.player);
            }
        }
    }

    @Override
    public ReputationLevel getReputationLevel(CivilizationType civ) {
        return ReputationLevel.fromReputation(this.getReputation(civ));
    }

    @Override
    public int getReputation(CivilizationType civ) {
        return this.i((Integer)this.reputations.get((Object)civ));
    }

    @Override
    public void updatePlayerLocation(int chunkX, int chunkZ) {
        Province prev = this.inCiv;
        Province curr = CivilizationUtil.getProvinceAt(this.player.field_70170_p, chunkX, chunkZ);
        if (PlayerCivilizationCapabilityImpl.equals(prev, curr)) {
            return;
        }
        this.setInCivilization(curr);
        if (!this.player.func_130014_f_().field_72995_K) {
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayerCivilizationSetInCiv(this.inCiv), (EntityPlayerMP)this.player);
        }
        if (prev != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.Leave(this.player, prev));
        }
        if (curr != null) {
            PlayerCivilizationCapabilityImpl.get(this.player).setInCivilization(curr);
            MinecraftForge.EVENT_BUS.post((Event)new CivilizationEvent.Enter(this.player, curr));
        }
    }

    @Override
    public void setInCivilization(Province civ) {
        this.inCiv = civ;
    }

    private static boolean equals(Province a, Province b) {
        CivilizationType civA = PlayerCivilizationCapabilityImpl.getCivilization(a);
        CivilizationType civB = PlayerCivilizationCapabilityImpl.getCivilization(b);
        if (civA == null && civB == null) {
            return true;
        }
        if (civA == null || civB == null) {
            return false;
        }
        return civA.equals((Object)civB);
    }

    private static CivilizationType getCivilization(Province a) {
        if (a == null) {
            return null;
        }
        return a.civilization;
    }

    @Override
    public Province getInCivilization() {
        return this.inCiv;
    }

    public String toString() {
        return "Player Civilization Info: " + this.player.func_70005_c_() + ": IN_CIV[" + this.inCiv + "]";
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerCivilizationCapability.class, (Capability.IStorage)new PlayerCivilization.PlayerCivilizationStorage(), (Callable)new Callable<PlayerCivilizationCapability>(){

            @Override
            public PlayerCivilizationCapability call() throws Exception {
                return null;
            }
        });
    }

    private int i(Integer integer) {
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static PlayerCivilizationCapability get(EntityPlayer player) {
        if (player == null) {
            throw new NullPointerException("NULL player");
        }
        return (PlayerCivilizationCapability)player.getCapability(INSTANCE, null);
    }

    @Override
    public Set<QuestData> getCurrentQuests() {
        return this.quests;
    }

    private boolean removeQuest(QuestData quest) {
        return this.quests.remove(quest);
    }

    @Override
    public QuestData getCurrentQuestFor(Province province) {
        for (QuestData q : this.getCurrentQuests()) {
            if (!q.getProvinceId().equals(province.id)) continue;
            return q;
        }
        return null;
    }

    @Override
    public QuestData getNextQuestFor(Province province) {
        for (QuestData q : this.nextQuests) {
            if (!q.getProvinceId().equals(province.id)) continue;
            return q;
        }
        return this.generateNextQuestFor(province);
    }

    private QuestData generateNextQuestFor(Province province) {
        QuestData q;
        Random rand = new Random();
        ArrayList<QuestBase> possibleQuests = new ArrayList<QuestBase>();
        possibleQuests.add(QuestFarm.INSTANCE);
        possibleQuests.add(QuestGather.INSTANCE);
        possibleQuests.add(QuestMine.INSTANCE);
        possibleQuests.add(QuestKillMobs.INSTANCE);
        if (this.getReputation(province.civilization) > 100) {
            possibleQuests.add(QuestCourier.INSTANCE);
        }
        if (this.getReputation(province.civilization) > 200) {
            possibleQuests.add(QuestEnemyEncampment.INSTANCE);
        }
        if (this.getReputation(province.civilization) > 500) {
            possibleQuests.add(QuestEnemyEncampment.INSTANCE);
        }
        if ((q = ((Quest)possibleQuests.get(rand.nextInt(possibleQuests.size()))).generateQuestFor(this.player, province)) == null) {
            ArrayList<QuestBase> fallbackQuests = new ArrayList<QuestBase>();
            fallbackQuests.add(QuestFarm.INSTANCE);
            fallbackQuests.add(QuestGather.INSTANCE);
            q = ((Quest)fallbackQuests.get(rand.nextInt(fallbackQuests.size()))).generateQuestFor(this.player, province);
        }
        this.nextQuests.add(q);
        return q;
    }

    @Override
    public List<ItemStack> acceptQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        if (this.getCurrentQuestFor(province) != null) {
            return null;
        }
        QuestData data = this.getNextQuestFor(province);
        this.quests.add(data);
        this.nextQuests.remove(data);
        return new QuestDelegator(data).accept(in);
    }

    @Override
    public List<ItemStack> rejectQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        QuestData data = this.getCurrentQuestFor(province);
        if (data == null) {
            return null;
        }
        List<ItemStack> out = new QuestDelegator(data).reject(in);
        if (out == null) {
            return null;
        }
        if (this.removeQuest(data)) {
            if (this.getReputation(province.civilization) > 10) {
                this.adjustReputation(province.civilization, -10);
            }
            return out;
        }
        return null;
    }

    @Override
    public List<ItemStack> completeQuest(List<ItemStack> in) {
        Province province = this.getInCivilization();
        if (province == null) {
            return null;
        }
        QuestData data = this.getCurrentQuestFor(province);
        if (data == null) {
            return null;
        }
        List<ItemStack> reward = new QuestDelegator(data).complete(in);
        if (reward == null) {
            return null;
        }
        if (!this.removeQuest(data)) {
            return null;
        }
        Integer n = this.completedQuests;
        Integer n2 = this.completedQuests = Integer.valueOf(this.completedQuests + 1);
        if (this.completedQuestsByProvince.get(province.id) == null) {
            this.completedQuestsByProvince.put(province.id, 0);
        }
        this.completedQuestsByProvince.put(province.id, (Integer)this.completedQuestsByProvince.get(province.id) + 1);
        return reward;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }
}

