/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestCourier
extends QuestBase
implements Quest {
    public static QuestCourier INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestCourier();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        ItemStack note = this.getNoteFromItems(data, in);
        if (note == null) {
            return null;
        }
        note.func_190920_e(0);
        in.remove(note);
        List<ItemStack> rewards = QuestCourier.getRewardItems(data);
        if (rewards != null) {
            in.addAll(rewards);
        }
        return in;
    }

    protected ItemStack getNoteFromItems(QuestData data, List<ItemStack> in) {
        for (ItemStack s : in) {
            if (!this.isReplyNoteForQuest(data, s)) continue;
            return s;
        }
        return null;
    }

    protected boolean isReplyNoteForQuest(QuestData data, ItemStack item) {
        if (!item.func_77942_o() || !item.func_77942_o()) {
            return false;
        }
        String noteQuestId = item.func_77978_p().func_74779_i("questId");
        Boolean isReply = item.func_77978_p().func_74767_n("reply");
        if (noteQuestId == null) {
            return false;
        }
        if (!isReply.booleanValue()) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("This is not a reply note"));
            return false;
        }
        if (!noteQuestId.equals(data.getQuestId().toString())) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentString("This reply is not for your current quest"));
            return false;
        }
        return true;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        Province deliverToProvince = this.getDeliverToProvince(data);
        ItemStack note = new ItemStack(Items.field_151121_aF);
        note.func_151001_c("Deliver to the Lord of " + deliverToProvince.name);
        note.func_77983_a("toProvince", (NBTBase)new NBTTagString(deliverToProvince.id.toString()));
        note.func_77983_a("questId", (NBTBase)new NBTTagString(data.getQuestId().toString()));
        in.add(note);
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.courier.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        Province deliverToProvince = this.getDeliverToProvince(data);
        BlockPos from = data.getPlayer().func_180425_c();
        BlockPos to = new BlockPos(deliverToProvince.chunkX * 16, from.func_177956_o(), deliverToProvince.chunkZ * 16);
        StringBuilder s = new StringBuilder();
        s.append("quests.courier.description");
        s.append("|").append(deliverToProvince.name);
        s.append("|").append(QuestCourier.getDirections(from, to));
        s.append("|").append(QuestCourier.listItems(QuestCourier.getRewardItems(data)));
        s.append("|").append(QuestCourier.getRewardRep(data));
        return s.toString();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province questProvince) {
        Province deliverToProvince = QuestCourier.chooseRandomProvince(questProvince, player.field_70170_p, true);
        if (deliverToProvince == null) {
            return null;
        }
        QuestData data = new QuestData();
        data.setCiv(questProvince.civilization);
        data.setPlayer(player);
        data.setProvinceId(questProvince.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        this.setDeliverToProvinceId(data, deliverToProvince.id);
        QuestCourier.setDistance(data, (int)Math.round(player.func_180425_c().func_185332_f(deliverToProvince.chunkX * 16, (int)player.field_70163_u, deliverToProvince.chunkZ * 16)));
        QuestCourier.setRewardRep(data, 5 + QuestCourier.getDistance(data) / 50);
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>(1);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, 4 + QuestCourier.getDistance(data) / 200);
        rewards.add(emeralds);
        QuestCourier.setRewardItems(data, rewards);
        return data;
    }

    private void setDeliverToProvinceId(QuestData data, UUID id) {
        data.getsData().put("deliverTo", id.toString());
    }

    private UUID getDeliverToProvinceId(QuestData data) {
        return UUID.fromString(data.getsData().get("deliverTo"));
    }

    private Province getDeliverToProvince(QuestData data) {
        Province p = QuestCourier.getProvinceById(data.getPlayer().field_70170_p, data.getsData().get("deliverTo"));
        if (p == null) {
            throw new UnsupportedOperationException("Deliever to provice ID[" + data.getsData().get("deliverTo") + "] was not found");
        }
        return p;
    }

    public static Integer getDistance(QuestData data) {
        return QuestCourier.i(data.getiData().get("distance"));
    }

    public static void setDistance(QuestData data, Integer distance) {
        data.getiData().put("distance", distance);
    }
}

