/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestEnemyEncampment
extends QuestBase
implements Quest {
    public static int ID;
    public static QuestEnemyEncampment INSTANCE;
    private static final int hutHalfWidth = 6;
    private static final int mobCount = 30;

    public static void init(int id) {
        INSTANCE = new QuestEnemyEncampment();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @Override
    public List<ItemStack> complete(QuestData data, List<ItemStack> in) {
        if (QuestEnemyEncampment.getKills(data) < 1) {
            data.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("quests.enemey_encampment.wasnt_you", new Object[0]));
            return null;
        }
        int count = this.countEntities(data);
        if (count > 0) {
            if (count == 1) {
                data.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("quests.enemey_encampment.one_left", new Object[0]));
            } else {
                data.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("quests.enemey_encampment.some_left", new Object[]{count}));
            }
            return null;
        }
        data.setCompleted(true);
        in.addAll(QuestEnemyEncampment.getRewardItems(data));
        if (QuestEnemyEncampment.getKills(data) == 30) {
            this.addGoldenSword(data, in);
        }
        return in;
    }

    protected void addGoldenSword(QuestData data, List<ItemStack> in) {
        ItemStack sword = new ItemStack(Items.field_151010_B);
        sword.func_77966_a(Enchantment.func_185262_c((int)16), 5);
        sword.func_77966_a(Enchantment.func_185262_c((int)21), 3);
        Province inProvince = PlayerCivilizationCapabilityImpl.get(data.getPlayer()).getInCivilization();
        if (inProvince.id.equals(data.getProvinceId())) {
            sword.func_151001_c("Golden Sword of " + inProvince.name);
        }
        in.add(sword);
    }

    private int countEntities(final QuestData data) {
        Predicate<Entity> filter = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_184216_O().contains("encampment_quest") && entity.func_184216_O().contains(data.getQuestId().toString());
            }
        };
        return data.getPlayer().field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB(this.getSpawnPosition(data)).func_72321_a(80.0, 40.0, 80.0), (Predicate)filter).size();
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        this.spawn(data);
        return in;
    }

    private void spawn(QuestData data) {
        BlockPos pos = this.searchForSuitableLocation(data);
        this.setSpawnPosition(data, pos);
        this.buildHut(data, pos);
        this.addToroSpawner(data, data.getPlayer().func_130014_f_(), this.getSpawnPosition(data), this.getEnemyType(data));
    }

    private BlockPos searchForSuitableLocation(QuestData data) {
        Random rand = data.getPlayer().func_130014_f_().field_73012_v;
        BlockPos pos = null;
        for (int i = 0; i < 100 && (pos = this.randomLocation(data, rand, false)) == null; ++i) {
        }
        if (pos == null) {
            return this.randomLocation(data, rand, true);
        }
        return pos;
    }

    private BlockPos randomLocation(QuestData data, Random rand, boolean force) {
        int distance = rand.nextInt(300) + 500;
        int directionDegrees = rand.nextInt(360);
        int z = distance * (int)Math.round(Math.sin(Math.toRadians(directionDegrees)));
        int x = distance * (int)Math.round(Math.cos(Math.toRadians(directionDegrees)));
        BlockPos pos = this.findSurface(data, x + (int)data.getPlayer().field_70165_t, z + (int)data.getPlayer().field_70161_v, force);
        if (pos == null) {
            return null;
        }
        if (data.getPlayer().field_70170_p.func_175636_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 60.0)) {
            return null;
        }
        try {
            pos = new BlockPos(pos.func_177958_n(), this.getLocalMinimum(data, pos), pos.func_177952_p());
        }
        catch (NotLevelEnoughException e) {
            if (force) {
                return pos;
            }
            return null;
        }
        return pos;
    }

    private int getLocalMinimum(QuestData data, BlockPos pos) throws NotLevelEnoughException {
        int w = 6;
        int max = 0;
        int min = 1000;
        for (int x = -w; x <= w; ++x) {
            for (int z = -w; z <= w; ++z) {
                int y = this.findSurface(data, pos.func_177958_n() + x, pos.func_177952_p() + z, true).func_177956_o();
                max = Math.max(y, max);
                min = Math.min(y, min);
            }
        }
        if (max - min > 5) {
            throw new NotLevelEnoughException("Offest " + (max - min));
        }
        return min;
    }

    private BlockPos findSurface(QuestData data, int x, int z, boolean force) {
        World world = data.getPlayer().func_130014_f_();
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        while (pos.func_177956_o() > 0) {
            IBlockState blockState = world.func_180495_p(pos);
            if (!force && QuestEnemyEncampment.isLiquid(blockState)) {
                return null;
            }
            if (QuestEnemyEncampment.isGroundBlock(blockState)) break;
            pos = pos.func_177977_b();
        }
        return pos.func_177984_a();
    }

    private void buildHut(QuestData data, BlockPos pos) {
        World world = data.getPlayer().func_130014_f_();
        if (pos == null) {
            return;
        }
        int w = 6;
        for (int x = -w; x <= w; ++x) {
            for (int y = 0; y <= w; ++y) {
                for (int z = -w; z <= w; ++z) {
                    BlockPos pointer = pos.func_177982_a(x, y, z);
                    IBlockState block = world.func_180495_p(pointer);
                    if (QuestEnemyEncampment.cantBuildOver(block)) continue;
                    if (y + Math.abs(z) == w) {
                        if (x % 2 == 0) {
                            world.func_175656_a(pointer, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
                            continue;
                        }
                        world.func_175656_a(pointer, Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK));
                        continue;
                    }
                    if (z != 0 || x != w && x != -w) continue;
                    world.func_175656_a(pointer, Blocks.field_180406_aS.func_176223_P());
                }
            }
        }
    }

    private void addToroSpawner(QuestData data, World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(4);
            spawner.setHelmet(new ItemStack((Item)Items.field_151161_ac));
            spawner.setBoots(new ItemStack((Item)Items.field_151175_af));
            spawner.setLeggings(new ItemStack((Item)Items.field_151173_ae));
            spawner.setChestplate(new ItemStack((Item)Items.field_151163_ad));
            spawner.addEntityTag(data.getQuestId().toString());
            spawner.addEntityTag("encampment_quest");
        } else {
            System.out.println("tile entity is missing");
        }
    }

    @Override
    public String getTitle(QuestData data) {
        if (data == null) {
            return "";
        }
        return "quests.enemey_encampment.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("quests.enemey_encampment.description");
        s.append("|").append(this.getEnemyNames(data));
        if (this.getSpawnPosition(data) != null) {
            s.append("|").append(QuestEnemyEncampment.getDirections(QuestEnemyEncampment.getProvincePosition(QuestEnemyEncampment.getQuestProvince(data)), this.getSpawnPosition(data)));
        } else {
            s.append("|").append(" ");
        }
        s.append("|").append(QuestEnemyEncampment.listItems(QuestEnemyEncampment.getRewardItems(data)));
        s.append("|").append(QuestEnemyEncampment.getRewardRep(data));
        return s.toString();
    }

    private String getEnemyNames(QuestData data) {
        String name = this.getEnemyType(data).get(0);
        try {
            Entity entity = TileEntityToroSpawner.getEntityForId(data.getPlayer().field_70170_p, name);
            return entity.func_70005_c_();
        }
        catch (Exception e) {
            System.out.println("failed to get name of entity [" + name + "] : " + e.getMessage());
            return "unknown enemy";
        }
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = player.func_130014_f_().field_73012_v;
        QuestData data = new QuestData();
        data.setCiv(province.civilization);
        data.setPlayer(player);
        data.setProvinceId(province.id);
        data.setQuestId(UUID.randomUUID());
        data.setQuestType(ID);
        data.setCompleted(false);
        this.chooseEnemyType(data);
        QuestEnemyEncampment.setRewardRep(data, 50);
        ArrayList<ItemStack> reward = new ArrayList<ItemStack>(1);
        reward.add(new ItemStack(Items.field_151166_bC, 10));
        QuestEnemyEncampment.setRewardItems(data, reward);
        return data;
    }

    private void chooseEnemyType(QuestData data) {
        ArrayList<String> enemies = new ArrayList<String>();
        for (int i = 0; i < 30; ++i) {
            enemies.add("minecraft:stray");
        }
        this.setEnemyType(data, enemies);
    }

    private BlockPos getSpawnPosition(QuestData data) {
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        if (c.func_74762_e("locationFound") != 1) {
            return null;
        }
        return new BlockPos(c.func_74762_e("pos_x"), c.func_74762_e("pos_y"), c.func_74762_e("pos_z"));
    }

    private void setSpawnPosition(QuestData data, BlockPos pos) {
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        c.func_74768_a("pos_x", pos.func_177958_n());
        c.func_74768_a("pos_y", pos.func_177956_o());
        c.func_74768_a("pos_z", pos.func_177952_p());
        c.func_74768_a("locationFound", 1);
    }

    private List<String> getEnemyType(QuestData data) {
        ArrayList<String> enemies = new ArrayList<String>();
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        try {
            NBTTagList list = (NBTTagList)c.func_74781_a("enemies");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                enemies.add(list.func_150307_f(i));
            }
            return enemies;
        }
        catch (Exception e) {
            System.out.println("Failed to load enemy types: " + e.getMessage());
            return this.getDefaultEnemies(data);
        }
    }

    private List<String> getDefaultEnemies(QuestData data) {
        ArrayList<String> zombies = new ArrayList<String>();
        for (int i = 0; i < 69; ++i) {
            zombies.add("zombie");
        }
        return zombies;
    }

    private void setEnemyType(QuestData data, List<String> enemies) {
        NBTTagCompound c = QuestEnemyEncampment.getCustomNbtTag(data);
        NBTTagList list = new NBTTagList();
        for (String enemy : enemies) {
            list.func_74742_a((NBTBase)new NBTTagString(enemy));
        }
        c.func_74782_a("enemies", (NBTBase)list);
    }

    public static Integer getKills(QuestData data) {
        return QuestEnemyEncampment.coalesce(QuestEnemyEncampment.i(data.getiData().get("kills")), 0);
    }

    private static Integer coalesce(Integer i, int j) {
        if (i == null) {
            return j;
        }
        return i;
    }

    public static void incrementKills(QuestData data) {
        data.getiData().put("kills", QuestEnemyEncampment.getKills(data) + 1);
    }

    @SubscribeEvent
    public void checkkills(LivingDeathEvent event) {
        EntityPlayer player = null;
        EntityLivingBase victum = (EntityLivingBase)event.getEntity();
        DamageSource source = event.getSource();
        if (!victum.func_184216_O().contains("encampment_quest")) {
            return;
        }
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        player = (EntityPlayer)source.func_76346_g();
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        for (QuestData data : quests) {
            if (ID != data.getQuestType() || !victum.func_184216_O().contains(data.getQuestId().toString())) continue;
            QuestEnemyEncampment.incrementKills(data);
            return;
        }
    }

    private static class NotLevelEnoughException
    extends Exception {
        public NotLevelEnoughException(String message) {
            super(message);
        }
    }
}

