/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.civilization.quests;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapability;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.civilization.quests.util.Quest;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.Quests;

public class QuestKillMobs
extends QuestBase
implements Quest {
    private static final String[] MOB_TYPES = new String[]{"zombie", "skeleton", "creeper", "spider"};
    public static QuestKillMobs INSTANCE;
    public static int ID;

    public static void init(int id) {
        INSTANCE = new QuestKillMobs();
        Quests.registerQuest(id, INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ID = id;
    }

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        EntityPlayer player = null;
        EntityLivingBase victim = (EntityLivingBase)event.getEntity();
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)source.func_76346_g();
        }
        if (player == null) {
            return;
        }
        Province province = PlayerCivilizationCapabilityImpl.get(player).getInCivilization();
        if (province == null || province.civilization == null) {
            return;
        }
        this.handleKillMobsQuest(player, province, victim);
    }

    private void handleKillMobsQuest(EntityPlayer player, Province provinceHuntedIn, EntityLivingBase victim) {
        if (victim == null) {
            return;
        }
        Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
        DataWrapper quest = new DataWrapper();
        for (QuestData data : quests) {
            try {
                quest.setData(data);
                quest.huntedMob = EntityList.func_191301_a((Entity)victim).func_110623_a();
                quest.provinceHuntedIn = provinceHuntedIn;
                if (!this.perform(quest)) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean perform(DataWrapper quest) {
        if (quest.getData().getPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!quest.isApplicable()) {
            return false;
        }
        quest.setCurrentAmount(quest.getCurrentAmount() + 1);
        if (quest.getCurrentAmount() >= quest.getTargetAmount()) {
            quest.data.setCompleted(true);
        }
        return true;
    }

    @Override
    public List<ItemStack> complete(QuestData quest, List<ItemStack> items) {
        List<ItemStack> rewards;
        if (!quest.getCompleted().booleanValue()) {
            return null;
        }
        Province province = QuestKillMobs.loadProvince(quest.getPlayer().field_70170_p, quest.getPlayer().func_180425_c());
        if (province == null || province.id == null || !province.id.equals(quest.getProvinceId())) {
            return null;
        }
        PlayerCivilizationCapability playerCiv = PlayerCivilizationCapabilityImpl.get(quest.getPlayer());
        playerCiv.adjustReputation(quest.getCiv(), new DataWrapper().setData(quest).getRewardRep());
        if (playerCiv.getReputation(province.civilization) > 100 && quest.getPlayer().field_70170_p.field_73012_v.nextInt(10) > 8) {
            ItemStack sword = new ItemStack(Items.field_151010_B);
            sword.func_151001_c("Golden Sword of " + province.name);
            items.add(sword);
        }
        if ((rewards = QuestKillMobs.getRewardItems(quest)) != null) {
            items.addAll(rewards);
        }
        return items;
    }

    @Override
    public List<ItemStack> reject(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public List<ItemStack> accept(QuestData data, List<ItemStack> in) {
        return in;
    }

    @Override
    public String getTitle(QuestData data) {
        return "quests.kill_mobs.title";
    }

    @Override
    public String getDescription(QuestData data) {
        if (data == null) {
            return "";
        }
        DataWrapper q = new DataWrapper().setData(data);
        StringBuilder s = new StringBuilder();
        s.append("quests.kill_mobs.description");
        s.append("|").append(q.getTargetAmount());
        s.append("|").append(this.mobName(q.getMobType(), data.getPlayer()));
        s.append("|").append(this.getProvinceName(data.getPlayer(), data.getProvinceId()));
        s.append("|").append(q.getCurrentAmount());
        s.append("|").append(QuestKillMobs.listItems(QuestKillMobs.getRewardItems(q.data)));
        return s.toString();
    }

    private String mobName(Integer mobType, EntityPlayer player) {
        Entity mob = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(MOB_TYPES[mobType]), (World)player.field_70170_p);
        return mob.func_70005_c_();
    }

    @Override
    public QuestData generateQuestFor(EntityPlayer player, Province province) {
        Random rand = player.func_130014_f_().field_73012_v;
        DataWrapper q = new DataWrapper();
        q.data.setCiv(province.civilization);
        q.data.setPlayer(player);
        q.data.setProvinceId(province.id);
        q.data.setQuestId(UUID.randomUUID());
        q.data.setQuestType(ID);
        q.data.setCompleted(false);
        int roll = rand.nextInt(10);
        q.setMobType(rand.nextInt(MOB_TYPES.length));
        q.setCurrentAmount(0);
        q.setRewardRep(0);
        q.setTargetAmount(10 + roll);
        ItemStack emeralds = new ItemStack(Items.field_151166_bC, q.getTargetAmount() / 6);
        ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
        rewardItems.add(emeralds);
        QuestKillMobs.setRewardItems(q.data, rewardItems);
        return q.data;
    }

    public static class DataWrapper {
        private QuestData data = new QuestData();
        private Province provinceHuntedIn;
        private String huntedMob;

        public QuestData getData() {
            return this.data;
        }

        public DataWrapper setData(QuestData data) {
            this.data = data;
            return this;
        }

        public Province getProvinceHuntedIn() {
            return this.provinceHuntedIn;
        }

        public void setProvinceHuntedIn(Province provinceHuntedIn) {
            this.provinceHuntedIn = provinceHuntedIn;
        }

        public String getHuntedMob() {
            return this.huntedMob;
        }

        public void setHuntedMob(String huntedMob) {
            this.huntedMob = huntedMob;
        }

        public Integer getMobType() {
            return this.i(this.data.getiData().get("type"));
        }

        public void setMobType(Integer mobType) {
            this.data.getiData().put("type", mobType);
        }

        public Integer getTargetAmount() {
            return this.i(this.data.getiData().get("target"));
        }

        public void setTargetAmount(Integer targetAmount) {
            this.data.getiData().put("target", targetAmount);
        }

        public Integer getCurrentAmount() {
            return this.i(this.data.getiData().get("amount"));
        }

        public void setCurrentAmount(Integer currentAmount) {
            this.data.getiData().put("amount", currentAmount);
        }

        public Integer getRewardRep() {
            return this.i(this.data.getiData().get("rep"));
        }

        public void setRewardRep(Integer rewardRep) {
            this.data.getiData().put("rep", rewardRep);
        }

        private Integer i(Object o) {
            try {
                return (Integer)o;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private boolean isApplicable() {
            return this.isKillMobsQuest() && this.isInCorrectProvince() && this.isCorrectMob();
        }

        private boolean isKillMobsQuest() {
            return this.data.getQuestType() == ID;
        }

        private boolean isInCorrectProvince() {
            return this.data.getProvinceId().equals(this.getProvinceHuntedIn().id);
        }

        private boolean isCorrectMob() {
            return MOB_TYPES[this.getMobType()].equals(this.getHuntedMob());
        }
    }
}

