/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityVampireBat;
import net.torocraft.toroquest.entities.render.RenderBas;

public class EntityBas
extends EntitySkeleton {
    public static String NAME = "bas";

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityBas.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBas.class, (IRenderFactory)new IRenderFactory<EntityBas>(){

            public Render<EntityBas> createRenderFor(RenderManager manager) {
                return new RenderBas(manager);
            }
        });
    }

    public EntityBas(World world) {
        super(world);
        this.func_70105_a(1.8000001f, 5.9700003f);
        this.field_70728_aV = 75;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
        this.func_184201_a(EntityEquipmentSlot.HEAD, this.colorArmor(new ItemStack((Item)Items.field_151024_Q, 1), 0xB0B0B0));
    }

    protected ItemStack colorArmor(ItemStack stack, int color) {
        ItemArmor armor = (ItemArmor)stack.func_77973_b();
        armor.func_82813_b(stack, color);
        stack.func_77978_p().func_74757_a("Unbreakable", true);
        return stack;
    }

    public float func_70047_e() {
        return super.func_70047_e() * 3.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    private void spawnLimitedBats() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        long start = System.currentTimeMillis();
        int playerCount = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72321_a(40.0, 20.0, 40.0)).size();
        int batCount = this.field_70170_p.func_72872_a(EntityVampireBat.class, new AxisAlignedBB(this.func_180425_c()).func_72321_a(40.0, 20.0, 40.0)).size();
        if (batCount > 7 * playerCount) {
            return;
        }
        this.spawnBats(null);
    }

    private void spawnBats(EntityLivingBase target) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < 3 + this.field_70146_Z.nextInt(4); ++i) {
            this.spawnBat(target);
        }
    }

    protected void spawnBat(EntityLivingBase target) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        EntityVampireBat mob = new EntityVampireBat(this.field_70170_p);
        if (target == null) {
            mob.func_70107_b(this.field_70165_t + (double)this.field_70146_Z.nextInt(6) - 3.0, this.field_70163_u + 4.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(6) - 3.0);
        } else {
            mob.func_70107_b(target.field_70165_t + (double)this.field_70146_Z.nextInt(3) - 1.0, target.field_70163_u + 1.0 + (double)this.field_70146_Z.nextInt(1), target.field_70161_v + (double)this.field_70146_Z.nextInt(3) - 1.0);
        }
        this.field_70170_p.func_72838_d((Entity)mob);
        if (target != null) {
            mob.func_70624_b(target);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_82737_E() % 100L == 0L) {
            this.spawnLimitedBats();
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                boolean flag = true;
                ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_70669_a(itemstack);
                            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            this.attackDistantAttackerWithBats(source);
        }
        return super.func_70097_a(source, amount);
    }

    protected void attackDistantAttackerWithBats(DamageSource source) {
        if (!(source.func_76346_g() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase distantAttacker = (EntityLivingBase)source.func_76346_g();
        this.spawnBats(distantAttacker);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
            this.achievement(cause);
        }
    }

    protected void achievement(DamageSource cause) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = cause.func_76346_g();
        if (entity == null || entity instanceof EntityPlayer) {
            // empty if block
        }
    }

    private void dropLoot() {
        this.dropLootItem(Items.field_151103_aS, this.field_70146_Z.nextInt(100));
        this.dropLootItem(Items.field_151032_g, this.field_70146_Z.nextInt(20));
        this.dropLootItem(Items.field_151045_i, this.field_70146_Z.nextInt(5) + 2);
        this.dropLootItem(Items.field_151166_bC, this.field_70146_Z.nextInt(10) + 10);
        this.dropLootItem(Items.field_151055_y, this.field_70146_Z.nextInt(10));
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

