/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.ai.EntityAIMoveIntoArea;
import net.torocraft.toroquest.entities.ai.EntityAINearestAttackableCivTarget;
import net.torocraft.toroquest.entities.render.RenderGuard;

public class EntityGuard
extends EntityToroNpc {
    private float zombieWidth = -1.0f;
    private float zombieHeight;
    public float capeAni = 0.0f;
    public boolean capeAniUp = true;
    public static String NAME = "guard";
    private EntityAIMoveIntoArea areaAI;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityGuard.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)2, (boolean)true, (int)4141092, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGuard.class, (IRenderFactory)new IRenderFactory<EntityGuard>(){

            public Render<EntityGuard> createRenderFor(RenderManager manager) {
                return new RenderGuard(manager);
            }
        });
    }

    public EntityGuard(World worldIn) {
        this(worldIn, null);
    }

    public EntityGuard(World worldIn, CivilizationType civ) {
        super(worldIn, civ);
        this.func_70105_a(0.6f, 1.95f);
        Arrays.fill(this.field_184655_bs, 0.25f);
        Arrays.fill(this.field_82174_bp, 0.25f);
    }

    protected void func_184651_r() {
        this.areaAI = new EntityAIMoveIntoArea(this, 0.5, 30);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.6, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.areaAI);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableCivTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 10, false, false, (Predicate)new Predicate<EntityMob>(){

            public boolean apply(EntityMob target) {
                return !(target instanceof EntityCreeper);
            }
        }));
    }

    @Override
    public void setCivilization(CivilizationType civ) {
        Province border;
        super.setCivilization(civ);
        if (this.areaAI != null && (border = CivilizationUtil.getProvinceAt(this.field_70170_p, (int)this.field_70165_t / 16, (int)this.field_70161_v / 16)) != null) {
            this.areaAI.setCenter(border.chunkX * 16, border.chunkZ * 16);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!super.func_70097_a(source, amount)) {
            return false;
        }
        EntityLivingBase attacker = this.func_70638_az();
        if (attacker == null && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.callForHelp((EntityLivingBase)source.func_76346_g());
        }
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void onUpdate_OFF() {
        super.func_70071_h_();
        super.func_70071_h_();
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_70721_aZ += (f - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    public boolean func_70652_k(Entity victum) {
        this.attackTargetEntityWithCurrentItem(victum);
        this.removeTargetIfNotFoe(victum);
        return true;
    }

    private void removeTargetIfNotFoe(Entity victum) {
        if (victum instanceof EntityPlayer && !this.isFoe((EntityPlayer)victum)) {
            this.func_70624_b(null);
        }
    }

    protected boolean isFoe(EntityPlayer target) {
        EntityGuard npc = this;
        CivilizationType civ = npc.getCivilization();
        if (civ == null) {
            return false;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(target).getReputation(civ);
        return rep < -100;
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)this)) {
            float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float modifierForCreature = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            if (attackDamage > 0.0f || modifierForCreature > 0.0f) {
                ItemStack itemstack;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
                boolean criticalHit = this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = criticalHit = criticalHit && !this.func_70051_ag();
                if (criticalHit) {
                    attackDamage *= 1.5f;
                }
                attackDamage += modifierForCreature;
                boolean swordSweep = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (!criticalHit && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)) != null && itemstack.func_77973_b() instanceof ItemSword) {
                    swordSweep = true;
                }
                float targetHealth = 0.0f;
                boolean setFireToTarget = false;
                int fireAspectModiferOfGuard = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
                if (targetEntity instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspectModiferOfGuard > 0 && !targetEntity.func_70027_ad()) {
                        setFireToTarget = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double targetMotionX = targetEntity.field_70159_w;
                double targetMotionY = targetEntity.field_70181_x;
                double targetMotionZ = targetEntity.field_70179_y;
                boolean successfulAttack = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
                if (successfulAttack) {
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (swordSweep) {
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r((Entity)entitylivingbase) || !(this.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a((Entity)this, 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                        }
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.spawnSweepParticles();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = targetMotionX;
                        targetEntity.field_70181_x = targetMotionY;
                        targetEntity.field_70179_y = targetMotionZ;
                    }
                    if (criticalHit) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.onCriticalHit(targetEntity);
                    }
                    if (!criticalHit && !swordSweep) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (modifierForCreature > 0.0f) {
                        this.onEnchantmentCritical(targetEntity);
                    }
                    if (!this.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack itemstack3;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemstack2 = this.func_184614_ca();
                        ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                        if (itemstack2 != null && itemstack3 != null && itemstack2.func_77973_b() instanceof ItemAxe && itemstack3.func_77973_b() == Items.field_185159_cQ) {
                            float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                            if (this.field_70146_Z.nextFloat() < f3) {
                                entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
                    ItemStack mainhandItem = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (mainhandItem != null && entity instanceof EntityLivingBase) {
                        mainhandItem.func_77973_b().func_77644_a(mainhandItem, (EntityLivingBase)entity, (EntityLivingBase)this);
                        if (mainhandItem.func_190916_E() <= 0) {
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float damageDealt = targetHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        if (fireAspectModiferOfGuard > 0) {
                            targetEntity.func_70015_d(fireAspectModiferOfGuard * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && damageDealt > 2.0f) {
                            int k = (int)((double)damageDealt * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (setFireToTarget) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    public void onCriticalHit(Entity entityHit) {
    }

    public void onEnchantmentCritical(Entity entityHit) {
    }

    public void spawnSweepParticles() {
        double d0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_98053_h(true);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151048_u, 1));
        this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(Items.field_185159_cQ, 1));
        return livingdata;
    }

    protected void addArmor() {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac, 1));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af, 1));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae, 1));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad, 1));
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.35;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

