/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.ai.EntityAIStayCentered;

public class EntityMonolithEye
extends EntityMob
implements IRangedAttackMob {
    private int clientSideAttackTime;
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.func_187226_a(EntityMonolithEye.class, (DataSerializer)DataSerializers.field_187198_h);
    public static String NAME = "monolitheye";
    private EntityLivingBase targetedEntity;
    private float field_175485_bl;
    private float field_175486_bm;
    private boolean isStunned;
    public BlockPos pos;
    public EntityLivingBase attackedTarget;

    public EntityMonolithEye(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        float damage = 6.0f;
        DamageSource ds = DamageSource.func_76354_b((Entity)this, (Entity)this);
        entityIn.func_70097_a(ds, damage);
        entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityMonolithEye.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStayCentered((EntityLivingBase)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new MonolithEyeTargetSelector(this)));
    }

    public int getAttackDuration() {
        return 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AGGRESSIVE, (Object)false);
        this.pos = this.func_180425_c();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.pos = this.func_180425_c();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187923_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    public void setAggressive(boolean aggressive) {
        this.func_184212_Q().func_187227_b(IS_AGGRESSIVE, (Object)aggressive);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public void func_70636_d() {
        this.updateLogic();
        if (this.field_70170_p.field_72995_K) {
            this.spawnAuraParticle();
        }
        super.func_70636_d();
    }

    protected void updateLogic() {
        BlockPos down;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.handleAttachLogicUpdate();
        if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        }
        if (this.field_70170_p.func_82737_E() % 10L == 0L && this.field_70170_p.func_180495_p(down = this.pos.func_177977_b()).func_177230_c() != Blocks.field_150343_Z) {
            this.func_70606_j(0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnAuraParticle() {
        if (this.field_70146_Z.nextDouble() <= 0.36) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.DRAGON_BREATH, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.06999999523162842, this.field_70163_u + 1.5 + this.field_70146_Z.nextGaussian() * 0.20999999523162843, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.06999999523162842, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnAttackParticles() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    protected void handleAttachLogicUpdate() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 15) {
            this.spawnAttackParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186440_v;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    private void spawnParticles(double xSpeed, double ySpeed, double zSpeed) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, xSpeed, ySpeed, zSpeed, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)42);
        }
    }

    public float func_70047_e() {
        return 1.62f;
    }

    private boolean hitByRangedAttack(DamageSource source) {
        return source instanceof EntityDamageSourceIndirect;
    }

    public boolean getIsStunned() {
        return this.isStunned;
    }

    public void setIsStunned(Boolean bool) {
        this.isStunned = bool;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (source instanceof EntityDamageSourceIndirect) {
                this.redirectArrowAtAttacker(source);
            } else {
                this.redirectAttack(source, amount);
            }
        }
        return false;
    }

    protected void redirectAttack(DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        if (attacker != null) {
            attacker.func_70097_a(source, amount);
        }
    }

    protected void redirectArrowAtAttacker(DamageSource source) {
        if ("arrow".equals(source.func_76355_l())) {
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                this.attackWithArrow((EntityLivingBase)source.func_76346_g());
            }
            if (source.func_76364_f() != null) {
                source.func_76364_f().func_70106_y();
            }
        }
    }

    protected void attackWithArrow(EntityLivingBase target) {
        int charge = 2 + this.field_70146_Z.nextInt(10);
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        entityarrow.func_70239_b((double)((float)charge * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (this.field_70146_Z.nextBoolean()) {
            entityarrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }

    static class AIAttack
    extends EntityAIBase {
        private final EntityMonolithEye theEntity;
        private int tickCounter;

        public AIAttack(EntityMonolithEye guardian) {
            this.theEntity = guardian;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean continueExecuting() {
            return super.func_75253_b() && this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) > 9.0;
        }

        public void func_75249_e() {
            this.tickCounter = -4;
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.theEntity.func_70638_az(), 90.0f, 90.0f);
            this.theEntity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.theEntity.setTargetedEntity(0);
            this.theEntity.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
            if (!this.theEntity.func_70685_l((Entity)entitylivingbase)) {
                this.theEntity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.theEntity.setTargetedEntity(this.theEntity.func_70638_az().func_145782_y());
                } else if (this.tickCounter >= this.theEntity.getAttackDuration()) {
                    float damage = 3.0f;
                    if (this.theEntity.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        damage += 3.0f;
                    }
                    DamageSource ds = DamageSource.func_76354_b((Entity)this.theEntity, (Entity)this.theEntity);
                    entitylivingbase.func_70097_a(ds, damage);
                    entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theEntity), (float)this.theEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.theEntity.attackedTarget = this.theEntity.func_70638_az();
                    this.theEntity.func_70624_b(null);
                    this.theEntity.field_70170_p.func_72960_a((Entity)this.theEntity, (byte)15);
                    this.theEntity.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.theEntity.func_70681_au().nextFloat() * 0.4f + 0.8f));
                }
                super.func_75246_d();
            }
        }
    }

    static class MonolithEyeTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityMonolithEye parentEntity;

        public MonolithEyeTargetSelector(EntityMonolithEye guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable EntityLivingBase p_apply_1_) {
            return (p_apply_1_ instanceof EntityPlayer || p_apply_1_ instanceof EntitySquid) && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }
}

