/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.ai.EntityAIStayCentered;
import net.torocraft.toroquest.entities.render.RenderRainbowGuard;

public class EntityRainbowGuard
extends EntityMob {
    public static String NAME = "rainbow_guard";
    private Color color = Color.RED;
    private static final DataParameter<Boolean> AT_ATTENTION;
    private static final DataParameter<BlockPos> LOOK_AT;
    private static final int WAKE_DIAMETER = 8;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityRainbowGuard.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)90, (int)2, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityRainbowGuard.class, (IRenderFactory)new IRenderFactory<EntityRainbowGuard>(){

            public Render<EntityRainbowGuard> createRenderFor(RenderManager manager) {
                return new RenderRainbowGuard(manager);
            }
        });
    }

    public EntityRainbowGuard(World world) {
        super(world);
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184641_n(false);
        this.field_70180_af.func_187214_a(AT_ATTENTION, (Object)true);
        this.field_70180_af.func_187214_a(LOOK_AT, (Object)this.func_180425_c());
    }

    public boolean isAtAttention() {
        return (Boolean)this.field_70180_af.func_187225_a(AT_ATTENTION);
    }

    private void setAtAttention(boolean b) {
        this.field_70180_af.func_187227_b(AT_ATTENTION, (Object)b);
    }

    public void setLookAt(BlockPos pos) {
        this.field_70180_af.func_187227_b(LOOK_AT, (Object)pos.func_177963_a(0.0, (double)this.func_70047_e(), 0.0));
    }

    private BlockPos getLookAt() {
        return (BlockPos)this.field_70180_af.func_187225_a(LOOK_AT);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184641_n(false);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151010_B, 1));
        this.func_98053_h(false);
        this.addArmor();
        return livingdata;
    }

    protected void addArmor() {
        this.func_184201_a(EntityEquipmentSlot.HEAD, this.colorArmor(new ItemStack((Item)Items.field_151024_Q, 1)));
        this.func_184201_a(EntityEquipmentSlot.FEET, this.colorArmor(new ItemStack((Item)Items.field_151021_T, 1)));
        this.func_184201_a(EntityEquipmentSlot.LEGS, this.colorArmor(new ItemStack((Item)Items.field_151026_S, 1)));
        this.func_184201_a(EntityEquipmentSlot.CHEST, this.colorArmor(new ItemStack((Item)Items.field_151027_R, 1)));
    }

    protected ItemStack colorArmor(ItemStack stack) {
        ItemArmor armor = (ItemArmor)stack.func_77973_b();
        armor.func_82813_b(stack, this.color.getColor());
        return stack;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAtAttention(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.wakeIfPlayerIsClose(true);
    }

    public void wokenByPartner() {
        this.wakeIfPlayerIsClose(false);
    }

    protected void wakeIfPlayerIsClose(boolean wakePartner) {
        List nearbyRainbowGuards;
        if (this.field_70170_p.func_82737_E() % 30L != 0L || !this.isAtAttention()) {
            return;
        }
        List players = this.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72321_a(8.0, 6.0, 8.0), EntitySelectors.field_188444_d);
        if (players.size() < 1) {
            return;
        }
        if (wakePartner && (nearbyRainbowGuards = this.field_70170_p.func_72872_a(EntityRainbowGuard.class, this.func_174813_aQ().func_72321_a(5.0, 4.0, 2.0))) != null && !nearbyRainbowGuards.isEmpty()) {
            ((EntityRainbowGuard)((Object)nearbyRainbowGuards.get(0))).wokenByPartner();
        }
        this.setAtAttention(false);
        this.field_70714_bg.func_85156_a((EntityAIBase)new EntityAIStayCentered((EntityLivingBase)this));
        this.func_70624_b((EntityLivingBase)players.get(this.field_70170_p.field_73012_v.nextInt(players.size())));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityLivingBase attacker;
        if (!super.func_70097_a(source, amount)) {
            return false;
        }
        if (this.isAtAttention()) {
            this.setAtAttention(false);
        }
        if ((attacker = this.func_70638_az()) == null && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
        }
        return true;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        AT_ATTENTION = EntityDataManager.func_187226_a(EntityRainbowGuard.class, (DataSerializer)DataSerializers.field_187198_h);
        LOOK_AT = EntityDataManager.func_187226_a(EntityRainbowGuard.class, (DataSerializer)DataSerializers.field_187200_j);
    }

    public class EntityAIAtAttention
    extends EntityAIBase {
        protected EntityRainbowGuard entity;

        public EntityAIAtAttention(EntityRainbowGuard entitylivingIn) {
            this.entity = entitylivingIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.entity.isAtAttention();
        }

        public boolean continueExecuting() {
            return this.entity.isAtAttention();
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            this.entity.func_70107_b((double)this.entity.func_180425_c().func_177958_n() + 0.5, this.entity.field_70163_u, (double)this.entity.func_180425_c().func_177952_p() + 0.5);
            this.entity.func_70671_ap().func_75650_a((double)EntityRainbowGuard.this.getLookAt().func_177958_n(), (double)EntityRainbowGuard.this.getLookAt().func_177956_o(), (double)EntityRainbowGuard.this.getLookAt().func_177952_p(), (float)this.entity.func_184649_cE(), 0.0f);
        }
    }

    public static enum Color {
        RED(0x993333),
        ORANGE(0xFF9900),
        YELLOW(0xFFFF00),
        GREEN(6717235),
        BLUE(3361970),
        PURPLE(8339378);

        private int color;

        private Color(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

