/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.ai.EntityAINearestAttackableCivTarget;
import net.torocraft.toroquest.entities.render.RenderSentry;

public class EntitySentry
extends EntityToroNpc {
    public static String NAME = "sentry";

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntitySentry.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)2, (boolean)true, (int)4141092, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, (IRenderFactory)new IRenderFactory<EntitySentry>(){

            public Render<EntitySentry> createRenderFor(RenderManager manager) {
                return new RenderSentry(manager);
            }
        });
    }

    public EntitySentry(World world, CivilizationType civ) {
        super(world, civ);
    }

    public EntitySentry(World world) {
        super(world, null);
    }

    @Override
    protected boolean func_70692_ba() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableCivTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 2, false, false, (Predicate)new Predicate<EntityMob>(){

            public boolean apply(EntityMob target) {
                return !(target instanceof EntityCreeper);
            }
        }));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!super.func_70097_a(source, amount)) {
            return false;
        }
        EntityLivingBase attacker = this.func_70638_az();
        if (attacker == null && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.callForHelp((EntityLivingBase)source.func_76346_g());
        }
        return true;
    }

    @Override
    public boolean func_70652_k(Entity victum) {
        super.func_70652_k(victum);
        this.removeTargetIfNotFoe(victum);
        return true;
    }

    private void removeTargetIfNotFoe(Entity victum) {
        if (victum instanceof EntityPlayer && !this.isFoe((EntityPlayer)victum)) {
            this.func_70624_b(null);
        }
    }

    protected boolean isFoe(EntityPlayer target) {
        EntitySentry npc = this;
        CivilizationType civ = npc.getCivilization();
        if (civ == null) {
            return false;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(target).getReputation(civ);
        return rep < -100;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_98053_h(true);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151040_l, 1));
        this.addArmor();
        return livingdata;
    }

    protected void addArmor() {
        this.func_184201_a(EntityEquipmentSlot.HEAD, this.colorArmor(new ItemStack((Item)Items.field_151024_Q, 1)));
        this.func_184201_a(EntityEquipmentSlot.FEET, this.colorArmor(new ItemStack((Item)Items.field_151021_T, 1)));
        this.func_184201_a(EntityEquipmentSlot.LEGS, this.colorArmor(new ItemStack((Item)Items.field_151026_S, 1)));
        this.func_184201_a(EntityEquipmentSlot.CHEST, this.colorArmor(new ItemStack((Item)Items.field_151027_R, 1)));
    }

    protected ItemStack colorArmor(ItemStack stack) {
        if (this.getCivilization() == null) {
            return stack;
        }
        ItemArmor armor = (ItemArmor)stack.func_77973_b();
        armor.func_82813_b(stack, this.determineColorByCiv());
        return stack;
    }

    private int determineColorByCiv() {
        int color = 0;
        switch (this.getCivilization()) {
            case EARTH: {
                color = 6717235;
                break;
            }
            case FIRE: {
                color = 0xFF9900;
                break;
            }
            case MOON: {
                color = 0x333333;
                break;
            }
            case SUN: {
                color = 0xFFFF00;
                break;
            }
            case WATER: {
                color = 2844140;
                break;
            }
            case WIND: {
                color = 0xFFFFFF;
            }
        }
        return color;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

