/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.ReputationLevel;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.render.RenderShopkeeper;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForEarth;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForFire;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForMoon;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForSun;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForWater;
import net.torocraft.toroquest.entities.trades.ShopkeeperTradesForWind;

public class EntityShopkeeper
extends EntityVillager
implements IMerchant {
    public static String NAME = "shopkeeper";

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityShopkeeper.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true, (int)0, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityShopkeeper.class, (IRenderFactory)new IRenderFactory<EntityShopkeeper>(){

            public Render<EntityShopkeeper> createRenderFor(RenderManager manager) {
                return new RenderShopkeeper(manager);
            }
        });
    }

    public EntityShopkeeper(World worldIn) {
        super(worldIn, 3);
    }

    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        return p_190672_2_;
    }

    public boolean processInteract(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        boolean flag;
        boolean bl = flag = stack != null && stack.func_77973_b() == Items.field_151063_bx;
        if (!(flag || !this.func_70089_S() || this.func_70940_q() || this.func_70631_g_() || player.func_70093_af())) {
            if (!this.field_70170_p.field_72995_K) {
                RepData rep = this.getReputation(player);
                if (rep.rep.equals((Object)ReputationLevel.OUTCAST) || rep.rep.equals((Object)ReputationLevel.ENEMY) || rep.rep.equals((Object)ReputationLevel.VILLAIN)) {
                    this.chat(player, "I WILL NOT TRADE WITH A " + (Object)((Object)rep.rep));
                } else {
                    this.func_70932_a_(player);
                    player.func_180472_a((IMerchant)this);
                }
            }
            player.func_71029_a(StatList.field_188074_H);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70932_a_(EntityPlayer player) {
        super.func_70932_a_(player);
    }

    public EntityPlayer func_70931_l_() {
        return super.func_70931_l_();
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        return this.createTradesBaseOnRep(player);
    }

    protected MerchantRecipeList createTradesBaseOnRep(EntityPlayer player) {
        RepData rep = this.getReputation(player);
        switch (rep.civ) {
            case WIND: {
                return ShopkeeperTradesForWind.trades(player, rep.rep);
            }
            case EARTH: {
                return ShopkeeperTradesForEarth.trades(player, rep.rep);
            }
            case FIRE: {
                return ShopkeeperTradesForFire.trades(player, rep.rep);
            }
            case MOON: {
                return ShopkeeperTradesForMoon.trades(player, rep.rep);
            }
            case SUN: {
                return ShopkeeperTradesForSun.trades(player, rep.rep);
            }
            case WATER: {
                return ShopkeeperTradesForWater.trades(player, rep.rep);
            }
        }
        return new MerchantRecipeList();
    }

    public ITextComponent func_145748_c_() {
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("entity.toroquest.shopkeeper.name", new Object[0]);
        textcomponenttranslation.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponenttranslation.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponenttranslation;
    }

    private void chat(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private RepData getReputation(EntityPlayer player) {
        RepData rep = new RepData();
        if (player == null) {
            return rep;
        }
        Province province = CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj);
        if (province == null) {
            return rep;
        }
        rep.civ = province.civilization;
        if (rep.civ == null) {
            return rep;
        }
        rep.rep = ReputationLevel.fromReputation(PlayerCivilizationCapabilityImpl.get(player).getReputation(rep.civ));
        return rep;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }

    private static class RepData {
        CivilizationType civ = CivilizationType.EARTH;
        ReputationLevel rep = ReputationLevel.DRIFTER;

        private RepData() {
        }
    }
}

