/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.model.ModelToro;
import net.torocraft.toroquest.entities.render.RenderToro;
import net.torocraft.toroquest.item.ItemToroLeather;

public class EntityToro
extends EntityTameable {
    public static String NAME = "toro";
    private static final DataParameter<Boolean> CHARGING;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityToro.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)60, (int)2, (boolean)true, (int)4141092, (int)14735033);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityToro.class, (IRenderFactory)new IRenderFactory<EntityToro>(){

            public Render<EntityToro> createRenderFor(RenderManager manager) {
                return new RenderToro(manager, (ModelBase)new ModelToro(), 0.7f);
            }
        });
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
    }

    private void setCharging(boolean b) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)b);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public EntityToro(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.75, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)ToroQuestConfiguration.toroHealthMultiplier);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0 * (double)ToroQuestConfiguration.toroAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (!CHARGING.equals(key) || !this.isCharging() || this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_184206_a(key);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.ignoreableAttack(source)) {
            this.func_70624_b(this.getAttacker(source));
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean ignoreableAttack(DamageSource source) {
        return !this.func_180431_b(source) && !(source instanceof EntityDamageSourceIndirect);
    }

    private EntityLivingBase getAttacker(DamageSource source) {
        try {
            return (EntityLivingBase)source.func_76346_g();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        try {
            if (this.field_70170_p.func_82737_E() % 100L == 0L) {
                this.syncChargingWithAttackTarget();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void syncChargingWithAttackTarget() {
        this.setCharging(this.func_70638_az() != null || this.func_70638_az() != null);
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.syncChargingWithAttackTarget();
    }

    public boolean func_70652_k(Entity victim) {
        boolean wasDamaged;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 2;
        if (victim instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)victim).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (wasDamaged = victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            this.func_70604_c(this.func_70638_az());
            this.func_70624_b(null);
            if (knockback > 0 && victim instanceof EntityLivingBase) {
                ((EntityLivingBase)victim).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (victim instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)victim;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, victim);
        }
        return wasDamaged;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityCow createChild(EntityAgeable ageable) {
        return new EntityCow(this.field_70170_p);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.3f;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
        }
    }

    private void dropLoot() {
        this.dropBeef();
        this.dropLeather();
    }

    protected void dropBeef() {
        ItemStack stack = new ItemStack(Items.field_151082_bd, this.field_70146_Z.nextInt(3) + 2);
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    protected void dropLeather() {
        ItemStack stack = new ItemStack((Item)ItemToroLeather.INSTANCE, 1);
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        CHARGING = EntityDataManager.func_187226_a(EntityToro.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

