/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntitySentry;

public class EntityToroNpc
extends EntityCreature {
    private static final DataParameter<String> CIV = EntityDataManager.func_187226_a(EntityEnderman.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityToroNpc(World worldIn, CivilizationType civ) {
        super(worldIn);
        this.field_70728_aV = 5;
        this.setCivilization(civ);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        String civ = this.s(this.getCivilization());
        if (this.isSet(civ)) {
            compound.func_74778_a("civilization", this.s(this.getCivilization()));
        } else {
            compound.func_82580_o("civilization");
        }
    }

    private boolean isSet(String civ) {
        return civ != null && civ.length() > 0;
    }

    public void func_70624_b(EntityLivingBase e) {
        if (!this.isCivilizationAlly(e)) {
            super.func_70624_b(e);
        }
    }

    public boolean isCivilizationAlly(EntityLivingBase e) {
        if (!(e instanceof EntityToroNpc)) {
            return false;
        }
        CivilizationType otherCiv = ((EntityToroNpc)e).getCivilization();
        if (otherCiv == null) {
            return false;
        }
        return otherCiv.equals((Object)this.getCivilization());
    }

    private String s(CivilizationType civilization) {
        if (civilization == null) {
            return null;
        }
        return civilization.toString();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCivilization(this.e(compound.func_74779_i("civilization")));
    }

    private CivilizationType e(String s) {
        try {
            return CivilizationType.valueOf(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCivilization(CivilizationType civ) {
        if (civ == null) {
            this.field_70180_af.func_187227_b(CIV, (Object)"");
        } else {
            this.field_70180_af.func_187227_b(CIV, (Object)civ.toString());
        }
        this.field_70180_af.func_187217_b(CIV);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CIV, (Object)"");
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public CivilizationType getCivilization() {
        return this.enumCiv((String)this.field_70180_af.func_187225_a(CIV));
    }

    private CivilizationType enumCiv(String s) {
        try {
            CivilizationType civ = CivilizationType.valueOf(s);
            return civ;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
        this.pledgeAllegianceIfUnaffiliated();
    }

    private void pledgeAllegianceIfUnaffiliated() {
        if (this.field_70170_p.func_82737_E() % 80L != 0L) {
            return;
        }
        if (this.getCivilization() != null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Province civ = CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj);
        if (civ == null || civ.civilization == null) {
            return;
        }
        this.setCivilization(civ.civilization);
        this.onPledgeAllegiance();
    }

    public void onPledgeAllegiance() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean successfulAttack;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (successfulAttack = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            this.handleSuccessfulAttack(entityIn, knockback);
        }
        return successfulAttack;
    }

    protected void handleSuccessfulAttack(Entity entityIn, int knockback) {
        int j;
        if (knockback > 0 && entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
        }
        if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
            entityIn.func_70015_d(j * 4);
        }
        if (entityIn instanceof EntityPlayer) {
            ItemStack itemstack1;
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            ItemStack itemstack = this.func_184614_ca();
            ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
            if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                if (this.field_70146_Z.nextFloat() < f1) {
                    entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                    this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                }
            }
        }
        this.func_174815_a((EntityLivingBase)this, entityIn);
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void callForHelp(EntityLivingBase attacker) {
        List help = this.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(this.func_180425_c()).func_72321_a(16.0, 6.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                if (!(entity instanceof EntityGuard) && !(entity instanceof EntitySentry)) {
                    return false;
                }
                CivilizationType civ = entity.getCivilization();
                if (civ == null) {
                    return false;
                }
                return civ.equals((Object)EntityToroNpc.this.getCivilization());
            }
        });
        for (EntityToroNpc entity : help) {
            entity.func_70624_b(attacker);
        }
    }

    protected boolean func_146066_aG() {
        return true;
    }
}

