/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.entities.EntityToroNpc;

public class EntityAINearestAttackableCivTarget
extends EntityAITarget {
    protected final EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<EntityPlayer> targetEntitySelector;
    protected EntityLivingBase targetEntity;
    protected EntityToroNpc field_75299_d;

    public EntityAINearestAttackableCivTarget(EntityToroNpc npc) {
        super((EntityCreature)npc, false, false);
        this.field_75299_d = npc;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)npc);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer target) {
                if (target == null) {
                    return false;
                }
                if (!EntitySelectors.field_180132_d.apply((Object)target)) {
                    return false;
                }
                if (!EntityAITarget.func_179445_a((EntityLiving)EntityAINearestAttackableCivTarget.this.field_75299_d, (EntityLivingBase)target, (boolean)false, (boolean)true)) {
                    return false;
                }
                return EntityAINearestAttackableCivTarget.this.shouldAttackPlayerBasedOnCivilization(target);
            }
        };
    }

    protected boolean shouldAttackPlayerBasedOnCivilization(EntityPlayer target) {
        if (!(this.field_75299_d instanceof EntityToroNpc)) {
            return false;
        }
        if (!(target instanceof EntityPlayer)) {
            return false;
        }
        EntityToroNpc npc = this.field_75299_d;
        CivilizationType civ = npc.getCivilization();
        if (civ == null) {
            return false;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(target).getReputation(civ);
        if (rep > -10) {
            return false;
        }
        if (rep < -800) {
            return true;
        }
        int attackOdds = rep < -400 ? 10 : (rep < -200 ? 40 : (rep < -100 ? 200 : (rep < -50 ? 400 : 800)));
        return target.func_130014_f_().field_73012_v.nextInt(attackOdds) == 0;
    }

    public boolean func_75250_a() {
        if (this.field_75299_d.getCivilization() == null) {
            return false;
        }
        if (this.shouldExecuteNonPlayer()) {
            return true;
        }
        return this.shouldExecutePlayer();
    }

    protected boolean shouldExecutePlayer() {
        double maxXZDistance = this.func_111175_f();
        double maxYDistance = this.func_111175_f();
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, maxXZDistance, maxYDistance, null, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected boolean shouldExecuteNonPlayer() {
        List list = this.field_75299_d.field_70170_p.func_72872_a(EntityToroNpc.class, this.getTargetableArea(this.func_111175_f()));
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        CivilizationType ownerCiv = this.field_75299_d.getCivilization();
        for (EntityToroNpc npc : list) {
            CivilizationType npcCiv = npc.getCivilization();
            if (npcCiv == null || npcCiv.equals((Object)ownerCiv)) continue;
            this.targetEntity = npc;
            return true;
        }
        return false;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72321_a(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

