/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.model;

import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.entities.EntityGuard;

@SideOnly(value=Side.CLIENT)
public class ModelGuard
extends ModelBiped {
    private ModelRenderer[] capes = new ModelRenderer[CivilizationType.values().length];
    private final float modelSize;
    private final float yOffset = 0.0f;
    private CivilizationType civ;
    private static final float DEFAULT_CAPE_ANGLE = 0.08f;
    private static final float MAX_CAPE_ANI = 0.07f;

    public ModelGuard() {
        this(0.0f);
    }

    public ModelGuard(float modelSize) {
        super(modelSize, 0.0f, 64, 64);
        this.modelSize = modelSize;
        for (CivilizationType civ : CivilizationType.values()) {
            this.buildCape(civ);
        }
    }

    public void setCivilization(CivilizationType civ) {
        this.civ = civ;
    }

    protected CivilizationType randomCivilizationType() {
        Random rand = new Random();
        return CivilizationType.values()[rand.nextInt(CivilizationType.values().length)];
    }

    protected void buildCape(CivilizationType civ) {
        ModelRenderer cape = new ModelRenderer((ModelBase)this, 0, 32);
        cape.func_78787_b(64, 64);
        switch (civ) {
            case SUN: {
                cape.func_78784_a(0, 32);
                break;
            }
            case EARTH: {
                cape.func_78784_a(20, 32);
                break;
            }
            case WATER: {
                cape.func_78784_a(40, 32);
                break;
            }
            case WIND: {
                cape.func_78784_a(0, 47);
                break;
            }
            case MOON: {
                cape.func_78784_a(20, 47);
                break;
            }
            case FIRE: {
                cape.func_78784_a(40, 47);
                break;
            }
            default: {
                cape.func_78784_a(0, 32);
            }
        }
        cape.func_78790_a(-4.5f, 0.0f, 0.0f, 9, 14, 1, this.modelSize);
        cape.func_78793_a(0.0f, 0.0f, 0.0f);
        cape.field_82907_q = 0.17f;
        cape.field_82908_p = 0.05f;
        cape.field_78795_f = 0.08f;
        this.field_78115_e.func_78792_a(cape);
        cape.field_78807_k = true;
        this.capes[civ.ordinal()] = cape;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        this.capeAnimation((EntityGuard)entityIn);
    }

    protected void capeAnimation(EntityGuard entityIn) {
        if (this.civ == null) {
            return;
        }
        this.showCurrentCape();
        float speed = (float)(entityIn.field_70159_w * entityIn.field_70159_w + entityIn.field_70179_y * entityIn.field_70179_y);
        float rot = speed * 40.0f;
        if (rot > 0.6f) {
            rot = 0.6f;
        }
        if (entityIn.capeAniUp && entityIn.capeAni > 0.07f) {
            entityIn.capeAniUp = false;
        } else if (!entityIn.capeAniUp && entityIn.capeAni < 0.0f) {
            entityIn.capeAniUp = true;
        }
        entityIn.capeAni = entityIn.capeAniUp ? (float)((double)entityIn.capeAni + 2.5E-4) : (float)((double)entityIn.capeAni - 2.5E-4);
        this.capes[this.civ.ordinal()].field_78795_f = rot += entityIn.capeAni;
    }

    private void showCurrentCape() {
        for (ModelRenderer cape : this.capes) {
            cape.field_78807_k = true;
        }
        this.capes[this.civ.ordinal()].field_78807_k = false;
    }
}

