/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.entities.EntityMage;

public class MageTowerGenerator
extends WorldGenerator {
    private int floorHieght = 0;
    private int radius = 0;
    private int floors = 0;
    private int height = 0;
    protected IBlockState[] aFloorBlock = new IBlockState[]{Blocks.field_150385_bj.func_176223_P(), Blocks.field_150347_e.func_176223_P(), ((BlockStoneBrick)Blocks.field_150417_aV).func_176203_a(1), Blocks.field_150336_V.func_176223_P()};
    protected IBlockState[] aWallDecorationBlock = new IBlockState[]{Blocks.field_150426_aN.func_176223_P(), Blocks.field_180398_cJ.func_176223_P()};
    protected IBlockState[] aWallBlock = new IBlockState[]{Blocks.field_150371_ca.func_176223_P(), Blocks.field_150417_aV.func_176223_P()};
    protected IBlockState[] aWallRandBlock = new IBlockState[]{((BlockQuartz)Blocks.field_150371_ca).func_176203_a(1), Blocks.field_150347_e.func_176223_P()};
    protected BlockStairs stairsBlock = (BlockStairs)Blocks.field_150370_cb;
    protected IBlockState stairsFoundationBlock = ((BlockStoneBrick)Blocks.field_150417_aV).func_176203_a(1);
    protected IBlockState stairsConnectorBlock = Blocks.field_150371_ca.func_176223_P();
    protected IBlockState stairsColumnBlock = Blocks.field_150371_ca.func_176223_P();
    protected IBlockState wallBlock;
    protected IBlockState wallRandBlock;
    protected IBlockState floorBlock;
    protected IBlockState wallDecorationBlock;
    protected IBlockState windowBlock = Blocks.field_180406_aS.func_176223_P();
    List<BlockPos> spawners;

    public boolean generate(int floors, int radius, int floorHieght, World world, Random rand, BlockPos pos) {
        this.radius = radius;
        this.floors = floors;
        this.floorHieght = floorHieght;
        this.height = floors * floorHieght + 2;
        return this.func_180709_b(world, rand, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.randomizeBlocks(rand);
        this.randomizeParameters(rand);
        BlockPos surface = this.findSurface(world, pos);
        if (surface == null) {
            return false;
        }
        this.placeTower(world, rand, surface);
        this.spawnMage(world, surface);
        return true;
    }

    protected void randomizeParameters(Random rand) {
        if (this.radius == 0) {
            this.radius = 7 + rand.nextInt(12);
        }
        if (this.floors == 0) {
            this.floors = 3 + rand.nextInt(7);
        }
        if (this.floorHieght == 0) {
            this.floorHieght = 5 + rand.nextInt(5);
        }
        this.height = this.floors * this.floorHieght + 2;
    }

    private void randomizeBlocks(Random rand) {
        this.wallBlock = this.randomPick(rand, this.aWallBlock);
        this.wallRandBlock = this.randomPick(rand, this.aWallRandBlock);
        this.floorBlock = this.randomPick(rand, this.aFloorBlock);
        this.wallDecorationBlock = this.randomPick(rand, this.aWallDecorationBlock);
    }

    private IBlockState randomPick(Random rand, IBlockState[] a) {
        return a[0];
    }

    private void spawnMage(World world, BlockPos pos) {
        EntityMage e = new EntityMage(world);
        e.func_70107_b(pos.func_177958_n() + 3, pos.func_177956_o() + this.floors * this.floorHieght + 1, pos.func_177952_p() + 3);
        world.func_72838_d((Entity)e);
    }

    private BlockPos findSurface(World world, BlockPos start) {
        int minY = world.func_72940_L();
        int maxY = 0;
        int radiusSquared = this.radius * this.radius;
        for (int x = -this.radius - 1; x <= this.radius + 1; ++x) {
            block1: for (int z = -this.radius - 1; z <= this.radius + 1; ++z) {
                int magSq = x * x + z * z;
                if (this.isOutsideTower(radiusSquared, magSq, 0)) continue;
                int verticalSpace = 0;
                for (int y = world.func_72940_L(); y > 0; --y) {
                    BlockPos pos = new BlockPos(start.func_177958_n() + x, y, start.func_177952_p() + z);
                    IBlockState blockState = world.func_180495_p(pos);
                    if (this.isLiquid(blockState)) {
                        return null;
                    }
                    if (this.isGroundBlock(blockState)) {
                        if (y < minY) {
                            minY = y;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        if (verticalSpace >= this.height) continue block1;
                        return null;
                    }
                    ++verticalSpace;
                }
            }
        }
        if (maxY - minY > 4) {
            return null;
        }
        return new BlockPos(start.func_177958_n(), minY, start.func_177952_p());
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    private void placeTower(World world, Random rand, BlockPos pos) {
        int z;
        int x;
        int y;
        int radiusSquared = this.radius * this.radius;
        int innerRadiusSquared = (this.radius - 2) * this.radius;
        this.spawners = new ArrayList<BlockPos>();
        for (y = 0; y < 6; ++y) {
            for (x = -this.radius - 1; x <= this.radius + 1; ++x) {
                for (z = -this.radius - 1; z <= this.radius + 1; ++z) {
                    this.placeTowerBlock(world, rand, pos, radiusSquared, innerRadiusSquared, y, x, z);
                }
            }
        }
        for (y = 6; y < this.height; ++y) {
            for (x = -this.radius; x <= this.radius; ++x) {
                for (z = -this.radius; z <= this.radius; ++z) {
                    this.placeTowerBlock(world, rand, pos, radiusSquared, innerRadiusSquared, y, x, z);
                }
            }
        }
        for (BlockPos p : this.spawners) {
            MageTowerGenerator.placeSpawner(world, p.func_177971_a((Vec3i)pos), this.randomMob(rand));
        }
    }

    private void placeSpikes(World world, BlockPos pos) {
        int l = this.radius / 2;
        int h = Long.valueOf(Math.round((double)l * 1.5)).intValue();
        BlockPos locPos = pos.func_177982_a(0, this.height - 1, 0);
        int z = 0;
        for (int y = 0; y <= h; ++y) {
            for (int x = l; x <= this.radius + 1; ++x) {
                if (x - l - 1 <= y / 2 && x != this.radius + 1) continue;
                this.func_175903_a(world, locPos.func_177982_a(x, y, z), this.wallBlock);
                this.func_175903_a(world, locPos.func_177982_a(-x, y, z), this.wallBlock);
                this.func_175903_a(world, locPos.func_177982_a(z, y, x), this.wallBlock);
                this.func_175903_a(world, locPos.func_177982_a(z, y, -x), this.wallBlock);
            }
        }
    }

    private String randomMob(Random rand) {
        switch (rand.nextInt(7)) {
            case 0: {
                return "cave_spider";
            }
            case 1: {
                return "blaze";
            }
            case 2: {
                return "skeleton";
            }
            case 3: {
                return "spider";
            }
            case 5: {
                return "zombie";
            }
            case 6: {
                return "zombie_pigman";
            }
        }
        return "zombie";
    }

    public static void placeSpawner(World world, BlockPos pos, String mob) {
        MageTowerGenerator.placeBlock(world, pos, Blocks.field_150474_ac);
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        logic.func_190894_a(new ResourceLocation(mob));
    }

    public static void placeBlock(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, block.func_176223_P());
    }

    private void placeTowerBlock(World world, Random rand, BlockPos pos, int radiusSquared, int innerRadiusSquared, int y, int x, int z) {
        IBlockState block = null;
        int magSq = x * x + z * z;
        if (!this.isOutsideTower(radiusSquared, magSq, y)) {
            block = Blocks.field_150350_a.func_176223_P();
            block = this.getBlockAtLocation(rand, innerRadiusSquared, magSq, block, y, x, z);
        } else if (y == 0) {
            block = this.stairsFoundationBlock;
        }
        if (this.isDoorwayLocation(x, y, z)) {
            block = this.getDoorwayBlock(x, y, z);
        }
        if (block != null) {
            BlockPos placementPos = pos.func_177982_a(x, y, z);
            this.func_175903_a(world, placementPos, block);
            this.addLootToChest(world, block, placementPos);
        }
    }

    protected void addLootToChest(World world, IBlockState block, BlockPos placementPos) {
        TileEntity tileentity;
        if (block.func_177230_c() == Blocks.field_150486_ae && (tileentity = world.func_175625_s(placementPos)) instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186421_c, world.field_73012_v.nextLong());
        }
    }

    private IBlockState getDoorwayBlock(int x, int y, int z) {
        IBlockState block = Blocks.field_150350_a.func_176223_P();
        int xm = Math.abs(x);
        int zm = Math.abs(z);
        if (y == 5 || y == 0) {
            block = this.wallBlock;
        }
        if (xm == 2 || zm == 2) {
            block = this.wallBlock;
        }
        return block;
    }

    private IBlockState getBlockAtLocation(Random rand, int innerRadiusSquared, int magSq, IBlockState currentBlock, int y, int x, int z) {
        if (this.isFloor(y)) {
            currentBlock = this.floorBlock;
        }
        if (this.isWallLocation(innerRadiusSquared, magSq)) {
            currentBlock = this.getWallBlock(rand, y, x, z);
        }
        if (this.isChestLocation(rand, x, y, z)) {
            currentBlock = this.getChestBlock(x, z);
        }
        if (this.isStairsLocation(x, y, z)) {
            currentBlock = this.getStairBlock(x, y, z);
        }
        if (this.isSpawnerLocation(x, y, z)) {
            this.spawners.add(new BlockPos(x, y, z));
        }
        return currentBlock;
    }

    private boolean isDoorwayLocation(int x, int y, int z) {
        if (y >= 0 && y < 6) {
            int zm;
            int xm = Math.abs(x);
            return this.isXDoorwayLocation(xm, zm = Math.abs(z)) || this.isZDoorwayLocation(xm, zm);
        }
        return false;
    }

    private boolean isXDoorwayLocation(int xm, int zm) {
        return xm <= 2 && zm >= this.radius - 2;
    }

    private boolean isZDoorwayLocation(int xm, int zm) {
        return zm <= 2 && xm >= this.radius - 2;
    }

    private IBlockState getChestBlock(int x, int z) {
        IBlockState currentBlock = x > 1 ? Blocks.field_150486_ae.func_176203_a(4) : (x < -1 ? Blocks.field_150486_ae.func_176203_a(5) : (z > 1 ? Blocks.field_150486_ae.func_176203_a(2) : (z < -1 ? Blocks.field_150486_ae.func_176203_a(3) : Blocks.field_150350_a.func_176223_P())));
        return currentBlock;
    }

    private IBlockState getWallBlock(Random rand, int y, int x, int z) {
        IBlockState currentBlock = this.isWindowLocation(x, y, z) ? this.windowBlock : (this.isHelixLocation(y, x, z) ? this.wallDecorationBlock : (rand.nextInt(100) > 10 ? this.wallBlock : this.wallRandBlock));
        return currentBlock;
    }

    private IBlockState getStairBlock(int x, int y, int z) {
        if (y > this.height - 2) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (y < 1) {
            return this.stairsFoundationBlock;
        }
        if (x == 0 && z == 0) {
            return this.stairsColumnBlock;
        }
        int yAdj = (y + 1) % 4;
        switch (yAdj) {
            case 0: {
                if (x == 1 && z == 0) {
                    return this.stairsBlock.func_176203_a(2);
                }
                if (x != 1 || z != 1) break;
                return this.stairsConnectorBlock;
            }
            case 1: {
                if (x == 0 && z == 1) {
                    return this.stairsBlock.func_176203_a(1);
                }
                if (x != -1 || z != 1) break;
                return this.stairsConnectorBlock;
            }
            case 2: {
                if (x == -1 && z == 0) {
                    return this.stairsBlock.func_176203_a(3);
                }
                if (x != -1 || z != -1) break;
                return this.stairsConnectorBlock;
            }
            case 3: {
                if (x == 0 && z == -1) {
                    return this.stairsBlock.func_176203_a(0);
                }
                if (x != 1 || z != -1) break;
                return this.stairsConnectorBlock;
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private boolean isStairsLocation(int x, int y, int z) {
        return Math.abs(x) < 2 && Math.abs(z) < 2;
    }

    private boolean isHelixLocation(int y, int x, int z) {
        int angle = (int)Math.round(MageTowerGenerator.getAngle(x, z));
        int coAngle = this.coAngle(angle);
        int yAdj = y * 16 % 360;
        return MageTowerGenerator.isClose(yAdj, angle, 20) || MageTowerGenerator.isClose(yAdj, this.coAngle(angle), 20);
    }

    private int coAngle(int angle) {
        int a = angle - 180;
        if (a < 0) {
            a += 360;
        }
        return a;
    }

    public static boolean isClose(int a, int b, int tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static double getAngle(int x, int z) {
        double angle = Math.toDegrees(Math.atan2(z, x));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    private boolean isWallLocation(int innerRadiusSquared, int magSq) {
        return magSq >= innerRadiusSquared;
    }

    private boolean isChestLocation(Random rand, int x, int y, int z) {
        if (y < this.height - 4 && rand.nextInt(10) > 1) {
            return false;
        }
        if (y % this.floorHieght != 1) {
            return false;
        }
        return Math.abs(x) == this.radius - 2 && z == 0 || Math.abs(z) == this.radius - 2 && x == 0;
    }

    private boolean isSpawnerLocation(int x, int y, int z) {
        if (y % this.floorHieght != this.floorHieght - 2) {
            return false;
        }
        return Math.abs(x) == this.radius - this.radius / 2 && z == 0 || Math.abs(z) == this.radius - this.radius / 2 && x == 0;
    }

    private boolean isWindowLocation(int x, int y, int z) {
        return false;
    }

    private boolean isOutsideTower(int radiusSquared, int magSq, int y) {
        if (y < this.height - 3) {
            return magSq > radiusSquared - 2;
        }
        return magSq > radiusSquared + 25;
    }

    private boolean isFloor(int y) {
        return y % this.floorHieght == 0;
    }
}

