/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.generation.BastionsLairGenerator;
import net.torocraft.toroquest.generation.GraveyardGenerator;
import net.torocraft.toroquest.generation.MageTowerGenerator;
import net.torocraft.toroquest.generation.MonolithGenerator;
import net.torocraft.toroquest.generation.ThroneRoomGenerator;

public class WorldGenPlacer
implements IWorldGenerator {
    public static final int LOW_CHANCE = 2000;
    public static final int MID_CHANCE = 800;
    public static final int HIGH_CHANCE = 100;

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlacer(), (int)2);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(ToroQuestConfiguration.structureSpawnChance) != 0 || world.field_73011_w.getDimension() != 0) {
            return;
        }
        int roll = random.nextInt(5);
        switch (roll) {
            case 0: {
                this.genMonolith(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.genBastionsLair(world, random, chunkX, chunkZ);
                break;
            }
            case 2: {
                this.genMageTower(world, random, chunkX, chunkZ);
                break;
            }
            case 3: {
                this.genThroneRoom(world, random, chunkX, chunkZ);
                break;
            }
            case 4: {
                this.genGraveyard(world, random, chunkX, chunkZ);
            }
        }
    }

    private void genMageTower(World world, Random random, int chunkX, int chunkZ) {
        if (!CivilizationsWorldSaveData.get(world).canGenStructure("mage_tower", chunkX, chunkZ)) {
            return;
        }
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), world.func_72940_L(), chunkZ * 16 + random.nextInt(16));
        if (new MageTowerGenerator().func_180709_b(world, random, pos)) {
            System.out.println("ToroQuest Gen Placer: Mage Tower " + pos);
        }
    }

    private void genBastionsLair(World world, Random random, int chunkX, int chunkZ) {
        if (!CivilizationsWorldSaveData.get(world).canGenStructure("bastions_lair", chunkX, chunkZ)) {
            return;
        }
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), world.func_72940_L(), chunkZ * 16 + random.nextInt(16));
        if (new BastionsLairGenerator().func_180709_b(world, random, pos)) {
            System.out.println("ToroQuest Gen Placer: Bastion's Lair " + pos);
        }
    }

    private void genMonolith(World world, Random random, int chunkX, int chunkZ) {
        if (!CivilizationsWorldSaveData.get(world).canGenStructure("monolith", chunkX, chunkZ)) {
            return;
        }
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), world.func_72940_L(), chunkZ * 16 + random.nextInt(16));
        if (new MonolithGenerator().func_180709_b(world, random, pos)) {
            System.out.println("ToroQuest Gen Placer: Monolith " + pos);
        }
    }

    private void genThroneRoom(World world, Random random, int chunkX, int chunkZ) {
        if (!CivilizationsWorldSaveData.get(world).canGenStructure("throne_room", chunkX, chunkZ)) {
            return;
        }
        int y = random.nextInt(20) + 10;
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), y, chunkZ * 16 + random.nextInt(16));
        if (new ThroneRoomGenerator().func_180709_b(world, random, pos)) {
            System.out.println("ToroQuest Gen Placer: Throne Room " + pos);
        }
    }

    private void genGraveyard(World world, Random random, int chunkX, int chunkZ) {
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), world.func_72940_L(), chunkZ * 16 + random.nextInt(16));
        if (new GraveyardGenerator().func_180709_b(world, random, pos)) {
            System.out.println("ToroQuest Gen Placer: Graveyard " + pos);
        }
    }
}

