/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.quests.QuestBase;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.inventory.IVillageLordInventory;

public class VillageLordInventory
extends InventoryBasic
implements IVillageLordInventory {
    private final EntityVillageLord lord;
    private static int DONATE_BOX_INDEX = 8;

    public VillageLordInventory(EntityVillageLord lord, String inventoryTitle, int slotCount) {
        super(inventoryTitle, false, slotCount);
        this.lord = lord;
    }

    @SideOnly(value=Side.CLIENT)
    public VillageLordInventory(EntityVillageLord lord, ITextComponent inventoryTitle, int slotCount) {
        super(inventoryTitle, slotCount);
        this.lord = lord;
    }

    @Override
    public List<ItemStack> getGivenItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            items.add(this.func_70304_b(i));
        }
        return items;
    }

    @Override
    public void setGivenItems(List<ItemStack> items) {
        this.dropItems(this.getGivenItems());
        items = QuestBase.removeEmptyItemStacks(items);
        items = this.dropOverItems(items, 4);
        for (int i = 0; i < 4; ++i) {
            if (i >= items.size()) {
                this.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            this.func_70299_a(i, items.get(i));
        }
    }

    @Override
    public List<ItemStack> getReturnItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            items.add(this.func_70304_b(i + 4));
        }
        return items;
    }

    @Override
    public void setReturnItems(List<ItemStack> items) {
        this.dropItems(this.getReturnItems());
        items = QuestBase.removeEmptyItemStacks(items);
        items = this.dropOverItems(items, 4);
        for (int i = 0; i < 4; ++i) {
            if (i >= items.size()) {
                this.func_70299_a(i + 4, ItemStack.field_190927_a);
                continue;
            }
            this.func_70299_a(i + 4, items.get(i));
        }
    }

    @Override
    public ItemStack getDonationItem() {
        return this.func_70301_a(DONATE_BOX_INDEX);
    }

    @Override
    public void setDonationItem(ItemStack item) {
        this.func_70299_a(DONATE_BOX_INDEX, item);
    }

    private List<ItemStack> dropOverItems(List<ItemStack> items, int maxIndex) {
        if (items.size() <= maxIndex) {
            return items;
        }
        ArrayList<ItemStack> over = new ArrayList<ItemStack>();
        for (int i = maxIndex; i < items.size(); ++i) {
            over.add(items.get(i));
        }
        for (ItemStack item : over) {
            items.remove(item);
        }
        this.dropItems(over);
        return items;
    }

    private void dropItems(List<ItemStack> items) {
        for (ItemStack stack : items) {
            EntityItem dropItem = new EntityItem(this.lord.field_70170_p, this.lord.field_70165_t, this.lord.field_70163_u, this.lord.field_70161_v, stack);
            dropItem.func_174868_q();
            this.lord.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    public NBTTagList saveAllItems() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            list.func_74742_a((NBTBase)nbttagcompound);
        }
        return list;
    }

    public void loadAllItems(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            int slot = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(nbttagcompound));
        }
    }

    @Override
    public Province getProvince() {
        return CivilizationsWorldSaveData.get(this.lord.field_70170_p).atLocation(this.lord.field_70176_ah, this.lord.field_70164_aj);
    }

    @Override
    public int getEntityId() {
        return this.lord.func_145782_y();
    }
}

