/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.item.armor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.material.ArmorMaterials;

@Mod.EventBusSubscriber
public class ItemReinforcedDiamondArmor
extends ItemArmor {
    public static final String NAME = "reinforced_diamond";
    public static ItemReinforcedDiamondArmor helmetItem;
    public static ItemReinforcedDiamondArmor chestplateItem;
    public static ItemReinforcedDiamondArmor leggingsItem;
    public static ItemReinforcedDiamondArmor bootsItem;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        bootsItem = new ItemReinforcedDiamondArmor("reinforced_diamond_boots", 1, EntityEquipmentSlot.FEET);
        leggingsItem = new ItemReinforcedDiamondArmor("reinforced_diamond_leggings", 2, EntityEquipmentSlot.LEGS);
        helmetItem = new ItemReinforcedDiamondArmor("reinforced_diamond_helmet", 1, EntityEquipmentSlot.HEAD);
        chestplateItem = new ItemReinforcedDiamondArmor("reinforced_diamond_chestplate", 1, EntityEquipmentSlot.CHEST);
        bootsItem.setRegistryName(new ResourceLocation("toroquest", "reinforced_diamond_boots"));
        event.getRegistry().register((IForgeRegistryEntry)bootsItem);
        leggingsItem.setRegistryName(new ResourceLocation("toroquest", "reinforced_diamond_leggings"));
        event.getRegistry().register((IForgeRegistryEntry)leggingsItem);
        helmetItem.setRegistryName(new ResourceLocation("toroquest", "reinforced_diamond_helmet"));
        event.getRegistry().register((IForgeRegistryEntry)helmetItem);
        chestplateItem.setRegistryName(new ResourceLocation("toroquest", "reinforced_diamond_chestplate"));
        event.getRegistry().register((IForgeRegistryEntry)chestplateItem);
    }

    public static void registerRenders() {
        ItemReinforcedDiamondArmor.registerRendersHelmet();
        ItemReinforcedDiamondArmor.registerRendersChestPlate();
        ItemReinforcedDiamondArmor.registerRendersLeggings();
        ItemReinforcedDiamondArmor.registerRendersBoots();
    }

    private static void registerRendersBoots() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)bootsItem, 0, ItemReinforcedDiamondArmor.model("boots"));
    }

    private static void registerRendersLeggings() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)leggingsItem, 0, ItemReinforcedDiamondArmor.model("leggings"));
    }

    private static void registerRendersHelmet() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)helmetItem, 0, ItemReinforcedDiamondArmor.model("helmet"));
    }

    private static void registerRendersChestPlate() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)chestplateItem, 0, ItemReinforcedDiamondArmor.model("chestplate"));
    }

    private static ModelResourceLocation model(String model) {
        return new ModelResourceLocation("toroquest:reinforced_diamond_" + model, "inventory");
    }

    public ItemReinforcedDiamondArmor(String unlocalizedName, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(ArmorMaterials.REINFORCED_DIAMOND, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(unlocalizedName);
        this.func_77656_e(8588);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.func_70090_H()) {
            // empty if block
        }
        this.effectPlayer(player, MobEffects.field_76421_d, 2);
        if (player.field_82175_bq) {
            player.func_71020_j(0.025f);
        }
    }

    private void effectPlayer(EntityPlayer player, Potion potion, int amplifier) {
        if (player.func_70660_b(potion) == null || player.func_70660_b(potion).func_76459_b() <= 1) {
            player.func_70690_d(new PotionEffect(potion, 159, amplifier, true, false));
        }
    }

    public static class EventHandlers {
        @SubscribeEvent
        public void postInit(LivingHurtEvent e) {
            DamageSource source = e.getSource();
            Iterable armorStacks = e.getEntityLiving().func_184193_aE();
            float reduction = 0.0f;
            for (ItemStack armorStack : armorStacks) {
                if (!this.isHeavyArmor(armorStack) || !source.func_76352_a() && !source.func_94541_c()) continue;
                reduction = (float)((double)reduction + 0.2);
            }
            if (reduction > 0.0f) {
                float newDamage = (1.0f - reduction) * e.getAmount();
                System.out.println("Heavy armor reduction: [" + reduction + "] IN[" + e.getAmount() + "] OUT[" + newDamage + "]");
                e.setAmount(newDamage);
            }
        }

        private boolean isHeavyArmor(ItemStack armorStack) {
            if (armorStack == null || armorStack.func_77973_b() == null) {
                return false;
            }
            Item item = armorStack.func_77973_b();
            return item == helmetItem || item == chestplateItem || item == leggingsItem || item == bootsItem;
        }
    }
}

