/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.item.ItemFireSword;
import net.torocraft.toroquest.item.ItemObsidianSword;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageSetItemReputationAmount;
import net.torocraft.toroquest.network.message.MessageSetQuestInfo;

public class MessageQuestUpdate
implements IMessage {
    public Action action;
    public int lordEntityId;

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.lordEntityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.lordEntityId);
    }

    private static boolean isSet(String s) {
        return s != null && s.trim().length() > 0;
    }

    private static boolean isEmpty(String s) {
        return !MessageQuestUpdate.isSet(s);
    }

    public static DonationReward getRepForDonation(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        if (item.func_77973_b() instanceof ItemTool) {
            String material;
            switch (material = ((ItemTool)item.func_77973_b()).func_77861_e()) {
                case "DIAMOND": {
                    return new DonationReward(2, null);
                }
                case "GOLD": {
                    return new DonationReward(1, null);
                }
            }
            return null;
        }
        if (item.func_77973_b() instanceof ItemSword) {
            String material = ((ItemSword)item.func_77973_b()).func_150932_j();
            if (item.func_77973_b() == ItemObsidianSword.INSTANCE || item.func_77973_b() == ItemFireSword.INSTANCE) {
                return new DonationReward(3, null);
            }
            if ("DIAMOND".equals(material)) {
                return new DonationReward(2, null);
            }
            if ("GOLD".equals(material)) {
                return new DonationReward(1, null);
            }
            return null;
        }
        if (item.func_77973_b() == Items.field_151045_i) {
            return new DonationReward(1 * item.func_190916_E(), null);
        }
        if (item.func_77973_b() == Items.field_151166_bC) {
            return new DonationReward(2 * item.func_190916_E(), null);
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)item.func_77973_b()).func_179223_d();
            if (Blocks.field_150484_ah == block) {
                return new DonationReward(9 * item.func_190916_E(), null);
            }
            if (Blocks.field_150475_bE == block) {
                return new DonationReward(18 * item.func_190916_E(), null);
            }
        }
        DonationReward reward = new DonationReward();
        if (MessageQuestUpdate.is(item, Items.field_151025_P, Items.field_151174_bG, Items.field_151034_e)) {
            reward.rep = 3 * MathHelper.func_76141_d((float)(item.func_190916_E() / 16));
        }
        if (MessageQuestUpdate.is(item, Items.field_151172_bF, Items.field_185164_cV)) {
            reward.rep = 2 * MathHelper.func_76141_d((float)(item.func_190916_E() / 16));
        }
        if (MessageQuestUpdate.is(item, Items.field_151015_O)) {
            reward.rep = 1 * MathHelper.func_76141_d((float)(item.func_190916_E() / 16));
        }
        if (MessageQuestUpdate.is(item, Items.field_151076_bf, Items.field_151077_bg, Items.field_151147_al, Items.field_151157_am, Items.field_179561_bm, Items.field_179557_bn, Items.field_179558_bo, Items.field_179559_bp, Items.field_151115_aP, Items.field_179566_aV, Items.field_151082_bd, Items.field_151083_be)) {
            reward.rep = 4 * MathHelper.func_76141_d((float)(item.func_190916_E() / 16));
        }
        if (reward.rep == 0) {
            return null;
        }
        if (item.func_190916_E() >= 64) {
            reward.item = Items.field_151074_bl;
        }
        return reward;
    }

    private static boolean is(ItemStack stack, Item ... items) {
        for (Item item : items) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static class DonationReward {
        public Item item;
        public int rep;

        public DonationReward() {
        }

        public DonationReward(int rep, Item item) {
            this.rep = rep;
            this.item = item;
        }
    }

    public static class Handler
    implements IMessageHandler<MessageQuestUpdate, IMessage> {
        public IMessage onMessage(final MessageQuestUpdate message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                return null;
            }
            final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            WorldServer worldServer = player.func_71121_q();
            worldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    new Worker(message.action).work(message, (EntityPlayer)player);
                }
            });
            return null;
        }
    }

    public static class Worker {
        private final Action action;

        public Worker(Action action) {
            this.action = action;
        }

        void work(MessageQuestUpdate message, EntityPlayer player) {
            Province province = CivilizationUtil.getProvinceAt(player.func_130014_f_(), player.field_70176_ah, player.field_70164_aj);
            EntityVillageLord lord = (EntityVillageLord)player.field_70170_p.func_73045_a(message.lordEntityId);
            IVillageLordInventory inventory = lord.getInventory(player.func_110124_au());
            switch (this.action) {
                case ACCEPT: {
                    this.processAccept(player, province, inventory);
                    break;
                }
                case COMPLETE: {
                    this.processComplete(player, province, inventory);
                    break;
                }
                case REJECT: {
                    this.processReject(player, province, inventory);
                    break;
                }
                case DONATE: {
                    this.processDonate(player, province, inventory);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid quest action [" + (Object)((Object)this.action) + "]");
                }
            }
        }

        private void processDonate(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            ItemStack donation = inventory.getDonationItem();
            if (MessageSetItemReputationAmount.isNoteForLord(province, donation)) {
                this.writeReplyNote(inventory, donation);
                return;
            }
            if (MessageSetItemReputationAmount.isStolenItemForProvince(province, donation)) {
                this.handleReturnStolenItem(player, province, inventory, donation);
                return;
            }
            DonationReward reward = MessageQuestUpdate.getRepForDonation(donation);
            if (reward != null) {
                PlayerCivilizationCapabilityImpl.get(player).adjustReputation(province.civilization, reward.rep);
                inventory.setDonationItem(ItemStack.field_190927_a);
                inventory.setReturnItems(this.l(new ItemStack(reward.item)));
            }
        }

        private <T> List<T> l(T ... items) {
            ArrayList<T> l = new ArrayList<T>();
            for (T item : items) {
                l.add(item);
            }
            return l;
        }

        private void handleReturnStolenItem(EntityPlayer player, Province province, IVillageLordInventory inventory, ItemStack stack) {
            inventory.setDonationItem(ItemStack.field_190927_a);
            ItemStack emeralds = new ItemStack(Items.field_151166_bC, 2 + player.field_70170_p.field_73012_v.nextInt(3));
            ArrayList<ItemStack> l = new ArrayList<ItemStack>(1);
            l.add(emeralds);
            inventory.setReturnItems(l);
            PlayerCivilizationCapabilityImpl.get(player).adjustReputation(province.civilization, 2 + player.field_70170_p.field_73012_v.nextInt(3));
        }

        private void writeReplyNote(IVillageLordInventory inventory, ItemStack donation) {
            String sToProvinceId = donation.func_77978_p().func_74779_i("toProvince");
            String sQuestId = donation.func_77978_p().func_74779_i("questId");
            if (MessageQuestUpdate.isEmpty(sToProvinceId) || MessageQuestUpdate.isEmpty(sQuestId)) {
                return;
            }
            inventory.setDonationItem(ItemStack.field_190927_a);
            donation.func_151001_c("Reply Note");
            donation.func_77978_p().func_74757_a("reply", true);
            ArrayList<ItemStack> l = new ArrayList<ItemStack>(1);
            l.add(donation);
            inventory.setReturnItems(l);
        }

        protected void processAccept(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).acceptQuest(inputItems);
            if (outputItems == null) {
                inventory.setGivenItems(inputItems);
                return;
            }
            inventory.setReturnItems(outputItems);
            QuestData currentQuest = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, currentQuest, null), (EntityPlayerMP)player);
        }

        protected void processReject(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).rejectQuest(inputItems);
            if (outputItems == null) {
                inventory.setGivenItems(inputItems);
                return;
            }
            inventory.setReturnItems(outputItems);
            QuestData nextQuest = PlayerCivilizationCapabilityImpl.get(player).getNextQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, null, nextQuest), (EntityPlayerMP)player);
        }

        protected void processComplete(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).completeQuest(inputItems);
            if (outputItems == null) {
                inventory.setGivenItems(inputItems);
                return;
            }
            inventory.setReturnItems(outputItems);
            QuestData nextQuest = PlayerCivilizationCapabilityImpl.get(player).getNextQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, null, nextQuest), (EntityPlayerMP)player);
        }
    }

    public static enum Action {
        ACCEPT,
        REJECT,
        COMPLETE,
        DONATE;

    }
}

